/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis.encoding;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEncodingReference
implements PsiReference,
EmptyResolveMessageProvider,
Comparable<XmlEncodingReference> {
    private final XmlAttributeValue myValue;
    private final String myCharsetName;
    private final TextRange myRangeInElement;
    private final int myPriority;

    public XmlEncodingReference(XmlAttributeValue value, String charsetName, TextRange rangeInElement, int priority) {
        this.myValue = value;
        this.myCharsetName = charsetName;
        this.myRangeInElement = rangeInElement;
        this.myPriority = priority;
    }

    public PsiElement getElement() {
        return this.myValue;
    }

    public TextRange getRangeInElement() {
        return this.myRangeInElement;
    }

    @Nullable
    public PsiElement resolve() {
        return CharsetToolkit.forName((String)this.myCharsetName) == null ? null : this.myValue;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = XmlErrorMessages.message("unknown.encoding.0", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/encoding/XmlEncodingReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myCharsetName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/encoding/XmlEncodingReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/analysis/encoding/XmlEncodingReference", "bindToElement"));
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        Charset[] charsets = CharsetToolkit.getAvailableCharsets();
        ArrayList<LookupElementBuilder> suggestions = new ArrayList<LookupElementBuilder>(charsets.length);
        for (Charset charset : charsets) {
            suggestions.add(LookupElementBuilder.create((String)charset.name()).withCaseSensitivity(false));
        }
        Object[] objectArray = suggestions.toArray(new LookupElement[suggestions.size()]);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/encoding/XmlEncodingReference", "getVariants"));
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public int compareTo(@NotNull XmlEncodingReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/analysis/encoding/XmlEncodingReference", "compareTo"));
        }
        return this.myPriority - ref.myPriority;
    }
}

