/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.XmlNSColorProvider;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NotNull;

public class XmlNamespaceAnnotator
implements Annotator {
    private static final XmlNSColorProvider[] PROVIDERS = (XmlNSColorProvider[])XmlNSColorProvider.EXTENSION_POINT_NAME.getExtensions();

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/analysis/XmlNamespaceAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/analysis/XmlNamespaceAnnotator", "annotate"));
        }
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            String namespace = tag.getNamespace();
            for (XmlNSColorProvider provider : PROVIDERS) {
                TextRange endTagRange;
                TextAttributesKey key = provider.getKeyForNamespace(namespace, (XmlElement)tag);
                if (key == null) continue;
                TextRange range = XmlTagUtil.getStartTagRange((XmlTag)tag);
                if (range != null) {
                    holder.createInfoAnnotation(range, null).setTextAttributes(key);
                }
                if ((endTagRange = XmlTagUtil.getEndTagRange((XmlTag)tag)) != null) {
                    holder.createInfoAnnotation(endTagRange, null).setTextAttributes(key);
                }
                return;
            }
        }
    }
}

