/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InsertRequiredAttributeFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private final String myAttrName;
    private final String[] myValues;
    @NonNls
    private static final String NAME_TEMPLATE_VARIABLE = "name";

    public InsertRequiredAttributeFix(@NotNull XmlTag tag, @NotNull String attrName, String ... values) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix", "<init>"));
        }
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix", "<init>"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix", "<init>"));
        }
        super((PsiElement)tag);
        this.myAttrName = attrName;
        this.myValues = values;
    }

    @NotNull
    public String getText() {
        String string = XmlErrorMessages.message("insert.required.attribute.quickfix.text", this.myAttrName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlErrorMessages.message("insert.required.attribute.quickfix.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix", "getFamilyName"));
        }
        return string;
    }

    public void invoke(final @NotNull Project project, @NotNull PsiFile file, final @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        boolean anchorIsEmptyTag;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        XmlTag myTag = (XmlTag)startElement;
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)myTag);
        XmlElementDescriptor descriptor = myTag.getDescriptor();
        if (descriptor == null) {
            return;
        }
        XmlAttributeDescriptor attrDescriptor = descriptor.getAttributeDescriptor(this.myAttrName, myTag);
        boolean indirectSyntax = XmlExtension.getExtension(myTag.getContainingFile()).isIndirectSyntax(attrDescriptor);
        PsiElement anchor = SourceTreeToPsiMap.treeElementToPsi(XmlChildRole.EMPTY_TAG_END_FINDER.findChild(treeElement));
        boolean bl = anchorIsEmptyTag = anchor != null;
        if (anchor == null) {
            anchor = SourceTreeToPsiMap.treeElementToPsi(XmlChildRole.START_TAG_END_FINDER.findChild(treeElement));
        }
        if (anchor == null) {
            return;
        }
        final Template template = TemplateManager.getInstance(project).createTemplate("", "");
        if (indirectSyntax) {
            if (anchorIsEmptyTag) {
                template.addTextSegment(">");
            }
            template.addTextSegment("<jsp:attribute name=\"" + this.myAttrName + "\">");
        } else {
            template.addTextSegment(" " + this.myAttrName + "=\"");
        }
        Expression expression = new Expression(){
            TextResult result = new TextResult("");

            public Result calculateResult(ExpressionContext context) {
                return this.result;
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return null;
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                LookupElement[] items = new LookupElement[InsertRequiredAttributeFix.this.myValues.length];
                for (int i = 0; i < items.length; ++i) {
                    items[i] = LookupElementBuilder.create((String)InsertRequiredAttributeFix.this.myValues[i]);
                }
                return items;
            }
        };
        template.addVariable(NAME_TEMPLATE_VARIABLE, expression, expression, true);
        if (indirectSyntax) {
            template.addTextSegment("</jsp:attribute>");
            template.addEndVariable();
            if (anchorIsEmptyTag) {
                template.addTextSegment("</" + myTag.getName() + ">");
            }
        } else {
            template.addTextSegment("\"");
        }
        final PsiElement anchor1 = anchor;
        final boolean indirectSyntax1 = indirectSyntax;
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        int textOffset = anchor1.getTextOffset();
                        if (!anchorIsEmptyTag && indirectSyntax1) {
                            ++textOffset;
                        }
                        editor.getCaretModel().moveToOffset(textOffset);
                        if (anchorIsEmptyTag && indirectSyntax1) {
                            editor.getDocument().deleteString(textOffset, textOffset + 2);
                        }
                        TemplateManager.getInstance(project).startTemplate(editor, template);
                    }
                });
            }
        };
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Runnable commandRunnable = new Runnable(){

                @Override
                public void run() {
                    CommandProcessor.getInstance().executeCommand(project, runnable, InsertRequiredAttributeFix.this.getText(), (Object)InsertRequiredAttributeFix.this.getFamilyName());
                }
            };
            ApplicationManager.getApplication().invokeLater(commandRunnable);
        } else {
            runnable.run();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

