/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.util.HtmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HtmlFileReferenceHelper
extends FileReferenceHelper {
    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile vFile) {
        Module module;
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/analysis/HtmlFileReferenceHelper", "getContexts"));
        }
        PsiFile file = PsiManager.getInstance((Project)project).findFile(vFile);
        Module module2 = module = file != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)file) : null;
        if (module == null || !(file instanceof XmlFile)) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HtmlFileReferenceHelper", "getContexts"));
            }
            return list;
        }
        String basePath = HtmlUtil.getHrefBase((XmlFile)file);
        if (basePath != null && !HtmlUtil.hasHtmlPrefix(basePath)) {
            for (VirtualFile virtualFile : this.getBaseRoots(module)) {
                VirtualFile base = virtualFile.findFileByRelativePath(basePath);
                PsiDirectory result = base != null ? PsiManager.getInstance((Project)project).findDirectory(base) : null;
                if (result == null) continue;
                List<PsiDirectory> list = Collections.singletonList(result);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HtmlFileReferenceHelper", "getContexts"));
                }
                return list;
            }
        }
        List<PsiFileSystemItem> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HtmlFileReferenceHelper", "getContexts"));
        }
        return list;
    }

    protected Collection<VirtualFile> getBaseRoots(Module module) {
        return Arrays.asList(ModuleRootManager.getInstance((Module)module).getContentRoots());
    }

    @Override
    public boolean isMine(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/analysis/HtmlFileReferenceHelper", "isMine"));
        }
        FileType fileType = file.getFileType();
        return ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file) && fileType == HtmlFileType.INSTANCE || fileType == XHtmlFileType.INSTANCE;
    }
}

