/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomHighlightInfoHolder
extends HighlightInfoHolder {
    private final EditorColorsScheme myCustomColorsScheme;

    public CustomHighlightInfoHolder(@NotNull PsiFile contextFile, HighlightInfoFilter ... filters) {
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/analysis/CustomHighlightInfoHolder", "<init>"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/analysis/CustomHighlightInfoHolder", "<init>"));
        }
        this(contextFile, (EditorColorsScheme)null, filters);
    }

    public CustomHighlightInfoHolder(@NotNull PsiFile contextFile, @Nullable EditorColorsScheme customColorsScheme, HighlightInfoFilter ... filters) {
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/analysis/CustomHighlightInfoHolder", "<init>"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/analysis/CustomHighlightInfoHolder", "<init>"));
        }
        super(contextFile, filters);
        this.myCustomColorsScheme = customColorsScheme;
    }

    @Override
    @NotNull
    public TextAttributesScheme getColorsScheme() {
        if (this.myCustomColorsScheme != null) {
            EditorColorsScheme editorColorsScheme = this.myCustomColorsScheme;
            if (editorColorsScheme == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/CustomHighlightInfoHolder", "getColorsScheme"));
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/CustomHighlightInfoHolder", "getColorsScheme"));
        }
        return editorColorsScheme;
    }
}

