/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBatchSuppressByNoInspectionCommentFix
implements SuppressQuickFix,
Iconable {
    @NotNull
    protected final String myID;
    private final boolean myReplaceOtherSuppressionIds;
    private String myText;

    @Nullable
    public abstract PsiElement getContainer(PsiElement var1);

    public AbstractBatchSuppressByNoInspectionCommentFix(@NotNull String ID2, boolean replaceOtherSuppressionIds) {
        if (ID2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "<init>"));
        }
        this.myText = "";
        this.myID = ID2;
        this.myReplaceOtherSuppressionIds = replaceOtherSuppressionIds;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "getName"));
        }
        return string;
    }

    public Icon getIcon(int flags) {
        return AllIcons.General.InspectionsOff;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "getText"));
        }
        return string;
    }

    protected void setText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "setText"));
        }
        this.myText = text;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public String toString() {
        return this.getText();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "applyFix"));
        }
        PsiElement element = descriptor.getStartElement();
        if (element == null) {
            return;
        }
        this.invoke(project, element);
    }

    protected final void replaceSuppressionComment(@NotNull PsiElement comment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "replaceSuppressionComment"));
        }
        SuppressionUtil.replaceSuppressionComment(comment, this.myID, this.myReplaceOtherSuppressionIds, this.getCommentLanguage(comment));
    }

    protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "createSuppression"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "createSuppression"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "createSuppression"));
        }
        SuppressionUtil.createSuppression(project, container, this.myID, this.getCommentLanguage(element));
    }

    @NotNull
    protected Language getCommentLanguage(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "getCommentLanguage"));
        }
        Language language = element.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "getCommentLanguage"));
        }
        return language;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "isAvailable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "isAvailable"));
        }
        return context.isValid() && PsiManager.getInstance((Project)project).isInProject(context) && this.getContainer(context) != null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "invoke"));
        }
        if (!this.isAvailable(project, element)) {
            return;
        }
        PsiElement container = this.getContainer(element);
        if (container == null) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(container)) {
            return;
        }
        if (this.replaceSuppressionComments(container)) {
            return;
        }
        this.createSuppression(project, element, container);
        UndoUtil.markPsiFileForUndo((PsiFile)element.getContainingFile());
    }

    protected boolean replaceSuppressionComments(PsiElement container) {
        List<? extends PsiElement> comments = this.getCommentsFor(container);
        if (comments != null) {
            for (PsiElement psiElement : comments) {
                if (!(psiElement instanceof PsiComment) || !SuppressionUtil.isSuppressionComment(psiElement)) continue;
                this.replaceSuppressionComment(psiElement);
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected List<? extends PsiElement> getCommentsFor(@NotNull PsiElement container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "getCommentsFor"));
        }
        PsiElement prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)container, (Class[])new Class[]{PsiWhiteSpace.class});
        if (prev == null) {
            return null;
        }
        return Collections.singletonList(prev);
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"suppress.inspection.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "getFamilyName"));
        }
        return string;
    }
}

