/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VisibleHighlightingPassFactory
extends AbstractProjectComponent {
    public VisibleHighlightingPassFactory(Project project) {
        super(project);
    }

    @NotNull
    public static ProperTextRange calculateVisibleRange(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/VisibleHighlightingPassFactory", "calculateVisibleRange"));
        }
        Rectangle rect = editor.getScrollingModel().getVisibleArea();
        LogicalPosition startPosition = editor.xyToLogicalPosition(new Point(rect.x, rect.y));
        int visibleStart = editor.logicalPositionToOffset(startPosition);
        LogicalPosition endPosition = editor.xyToLogicalPosition(new Point(rect.x + rect.width, rect.y + rect.height));
        int visibleEnd = editor.logicalPositionToOffset(new LogicalPosition(endPosition.line + 1, 0));
        ProperTextRange properTextRange = new ProperTextRange(visibleStart, Math.max(visibleEnd, visibleStart));
        if (properTextRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/VisibleHighlightingPassFactory", "calculateVisibleRange"));
        }
        return properTextRange;
    }

    @Nullable
    protected static TextRange calculateRangeToProcess(Editor editor) {
        TextRange dirtyTextRange = FileStatusMap.getDirtyTextRange(editor, 4);
        if (dirtyTextRange == null) {
            return null;
        }
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
        TextRange textRange = dirtyTextRange.intersection((TextRange)visibleRange);
        if (textRange == null || textRange.isEmpty() || textRange.equals((Object)dirtyTextRange)) {
            return null;
        }
        return textRange;
    }
}

