/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TruncatingIcon;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrafficLightRenderer
implements ErrorStripeRenderer,
Disposable {
    private static final Icon IN_PROGRESS_ICON = AllIcons.General.ErrorsInProgress;
    private static final Icon NO_ANALYSIS_ICON = AllIcons.General.NoAnalysis;
    private static final Icon NO_ICON = new EmptyIcon(IN_PROGRESS_ICON.getIconWidth(), IN_PROGRESS_ICON.getIconHeight());
    private static final Icon STARING_EYE_ICON = AllIcons.General.InspectionInProgress;
    private final Project myProject;
    private final Document myDocument;
    private final PsiFile myFile;
    private final DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer;
    private final SeverityRegistrar mySeverityRegistrar;
    private int[] errorCount;

    public TrafficLightRenderer(@Nullable Project project, Document document, PsiFile file) {
        this.myProject = project;
        this.myDaemonCodeAnalyzer = project == null ? null : (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
        this.myDocument = document;
        this.myFile = file;
        this.mySeverityRegistrar = SeverityRegistrar.getSeverityRegistrar(this.myProject);
        this.refresh();
        if (project != null) {
            final MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project, true);
            model.addMarkupModelListener(this, new MarkupModelListener.Adapter(){

                @Override
                public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                    if (highlighter == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$1", "afterAdded"));
                    }
                    TrafficLightRenderer.this.incErrorCount(highlighter, 1);
                }

                @Override
                public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                    if (highlighter == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$1", "beforeRemoved"));
                    }
                    TrafficLightRenderer.this.incErrorCount(highlighter, -1);
                }
            });
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (RangeHighlighter rangeHighlighter : model.getAllHighlighters()) {
                        TrafficLightRenderer.this.incErrorCount(rangeHighlighter, 1);
                    }
                }
            });
        }
    }

    private void refresh() {
        int maxIndex = this.mySeverityRegistrar.getSeverityMaxIndex();
        if (this.errorCount != null && maxIndex == this.errorCount.length) {
            return;
        }
        int[] newErrors = new int[maxIndex + 1];
        if (this.errorCount != null) {
            System.arraycopy(this.errorCount, 0, newErrors, 0, Math.min(this.errorCount.length, newErrors.length));
        }
        this.errorCount = newErrors;
    }

    public static void setOrRefreshErrorStripeRenderer(@NotNull EditorMarkupModel editorMarkupModel, @NotNull Project project, @NotNull Document document, PsiFile file) {
        if (editorMarkupModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer", "setOrRefreshErrorStripeRenderer"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer", "setOrRefreshErrorStripeRenderer"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer", "setOrRefreshErrorStripeRenderer"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!editorMarkupModel.isErrorStripeVisible() || !DaemonCodeAnalyzer.getInstance((Project)project).isHighlightingAvailable(file)) {
            return;
        }
        ErrorStripeRenderer renderer = editorMarkupModel.getErrorStripeRenderer();
        if (renderer instanceof TrafficLightRenderer) {
            TrafficLightRenderer tlr = (TrafficLightRenderer)renderer;
            tlr.refresh();
            ((EditorMarkupModelImpl)editorMarkupModel).repaintVerticalScrollBar();
            if (tlr.myFile == null || tlr.myFile.isValid()) {
                return;
            }
            Disposer.dispose((Disposable)tlr);
        }
        renderer = new TrafficLightRenderer(project, document, file);
        Disposer.register((Disposable)((EditorImpl)editorMarkupModel.getEditor()).getDisposable(), (Disposable)((Disposable)renderer));
        editorMarkupModel.setErrorStripeRenderer(renderer);
    }

    public void dispose() {
    }

    private void incErrorCount(RangeHighlighter highlighter, int delta) {
        Object o = highlighter.getErrorStripeTooltip();
        if (!(o instanceof HighlightInfo)) {
            return;
        }
        HighlightInfo info = (HighlightInfo)o;
        HighlightSeverity infoSeverity = info.getSeverity();
        int severityIdx = this.mySeverityRegistrar.getSeverityIdx(infoSeverity);
        if (severityIdx != -1) {
            int n = severityIdx;
            this.errorCount[n] = this.errorCount[n] + delta;
        }
    }

    @Nullable
    protected DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(boolean fillErrorsCount, SeverityRegistrar severityRegistrar) {
        if (this.myFile == null || this.myProject.isDisposed() || !this.myDaemonCodeAnalyzer.isHighlightingAvailable(this.myFile)) {
            return null;
        }
        ArrayList<String> noInspectionRoots = new ArrayList<String>();
        ArrayList<String> noHighlightingRoots = new ArrayList<String>();
        FileViewProvider provider = this.myFile.getViewProvider();
        Set languages = provider.getLanguages();
        for (Language language : languages) {
            PsiFile root = provider.getPsi(language);
            if (!HighlightingLevelManager.getInstance(this.myProject).shouldHighlight((PsiElement)root)) {
                noHighlightingRoots.add(language.getID());
                continue;
            }
            if (HighlightingLevelManager.getInstance(this.myProject).shouldInspect((PsiElement)root)) continue;
            noInspectionRoots.add(language.getID());
        }
        DaemonCodeAnalyzerStatus status = new DaemonCodeAnalyzerStatus();
        status.noInspectionRoots = noInspectionRoots.isEmpty() ? null : ArrayUtil.toStringArray(noInspectionRoots);
        status.noHighlightingRoots = noHighlightingRoots.isEmpty() ? null : ArrayUtil.toStringArray(noHighlightingRoots);
        status.errorCount = (int[])this.errorCount.clone();
        status.rootsNumber = languages.size();
        this.fillDaemonCodeAnalyzerErrorsStatus(status, fillErrorsCount, severityRegistrar);
        List<TextEditorHighlightingPass> passes = this.myDaemonCodeAnalyzer.getPassesToShowProgressFor(this.myDocument);
        status.passStati = passes.isEmpty() ? Collections.emptyList() : new ArrayList(passes.size());
        for (int i = 0; i < passes.size(); ++i) {
            ProgressableTextEditorHighlightingPass pass;
            TextEditorHighlightingPass tepass = passes.get(i);
            if (!(tepass instanceof ProgressableTextEditorHighlightingPass) || (pass = (ProgressableTextEditorHighlightingPass)tepass).getProgress() < 0.0) continue;
            status.passStati.add(pass);
        }
        status.errorAnalyzingFinished = this.myDaemonCodeAnalyzer.isAllAnalysisFinished(this.myFile);
        status.enabled = this.myDaemonCodeAnalyzer.isUpdateByTimerEnabled();
        return status;
    }

    protected void fillDaemonCodeAnalyzerErrorsStatus(DaemonCodeAnalyzerStatus status, boolean fillErrorsCount, SeverityRegistrar severityRegistrar) {
    }

    public final Project getProject() {
        return this.myProject;
    }

    public String getTooltipMessage() {
        return null;
    }

    public void paint(Component c, Graphics g, Rectangle r) {
        DaemonCodeAnalyzerStatus status = this.getDaemonCodeAnalyzerStatus(false, this.mySeverityRegistrar);
        Icon icon = this.getIcon(status);
        int height = icon.getIconHeight();
        int width = icon.getIconWidth();
        int x = r.x + (r.width - width) / 2;
        int y = r.y + (r.height - height) / 2;
        icon.paintIcon(c, g, x, y);
    }

    private Icon getIcon(DaemonCodeAnalyzerStatus status) {
        if (status == null) {
            return NO_ICON;
        }
        if (status.noHighlightingRoots != null && status.noHighlightingRoots.length == status.rootsNumber) {
            return NO_ANALYSIS_ICON;
        }
        Icon icon = HighlightDisplayLevel.DO_NOT_SHOW.getIcon();
        for (int i = status.errorCount.length - 1; i >= 0; --i) {
            if (status.errorCount[i] == 0) continue;
            icon = this.mySeverityRegistrar.getRendererIconByIndex(i);
            break;
        }
        if (status.errorAnalyzingFinished) {
            if (this.myProject != null && DumbService.isDumb((Project)this.myProject)) {
                return new LayeredIcon(new Icon[]{NO_ANALYSIS_ICON, icon, STARING_EYE_ICON});
            }
            return icon;
        }
        if (!status.enabled) {
            return NO_ANALYSIS_ICON;
        }
        double progress = TrafficLightRenderer.getOverallProgress(status);
        TruncatingIcon trunc = new TruncatingIcon(icon, icon.getIconWidth(), (int)((double)icon.getIconHeight() * progress));
        return new LayeredIcon(new Icon[]{NO_ANALYSIS_ICON, trunc, STARING_EYE_ICON});
    }

    private static double getOverallProgress(DaemonCodeAnalyzerStatus status) {
        long advancement = 0L;
        long limit = 0L;
        for (ProgressableTextEditorHighlightingPass ps : status.passStati) {
            advancement += ps.getProgressCount();
            limit += ps.getProgressLimit();
        }
        return limit == 0L ? (status.errorAnalyzingFinished ? 1.0 : 0.0) : (double)advancement * 1.0 / (double)limit;
    }

    public static class DaemonCodeAnalyzerStatus {
        public boolean errorAnalyzingFinished;
        public List<ProgressableTextEditorHighlightingPass> passStati = Collections.emptyList();
        public String[] noHighlightingRoots;
        public String[] noInspectionRoots;
        public int[] errorCount = ArrayUtil.EMPTY_INT_ARRAY;
        public boolean enabled = true;
        public int rootsNumber;

        public String toString() {
            String s = "DS: finished=" + this.errorAnalyzingFinished;
            s = s + "; pass statuses: " + this.passStati.size() + "; ";
            for (ProgressableTextEditorHighlightingPass passStatus : this.passStati) {
                s = s + String.format("(%s %2.0f%% %b)", passStatus.getPresentableName(), passStatus.getProgress() * 100.0, passStatus.isFinished());
            }
            s = s + "; error count: " + this.errorCount.length + ": " + new TIntArrayList(this.errorCount);
            return s;
        }
    }
}

