/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveSuppressWarningAction
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.RemoveSuppressWarningAction");
    private final String myID;
    private final String myProblemLine;

    public RemoveSuppressWarningAction(String ID2, String problemLine) {
        this.myID = ID2;
        this.myProblemLine = problemLine;
    }

    public RemoveSuppressWarningAction(String id) {
        int idx = id.indexOf(";");
        if (idx > -1) {
            this.myID = id.substring(0, idx);
            this.myProblemLine = id.substring(idx);
        } else {
            this.myID = id;
            this.myProblemLine = null;
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.suppression.action.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/RemoveSuppressWarningAction", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/RemoveSuppressWarningAction", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/RemoveSuppressWarningAction", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        try {
            if (element instanceof PsiIdentifier) {
                if (!FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
                    return;
                }
                PsiIdentifier identifier = (PsiIdentifier)element;
                PsiDocCommentOwner commentOwner = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)identifier, PsiDocCommentOwner.class);
                if (commentOwner != null) {
                    PsiElement psiElement = JavaSuppressionUtil.getElementMemberSuppressedIn(commentOwner, this.myID);
                    if (psiElement instanceof PsiAnnotation) {
                        this.removeFromAnnotation((PsiAnnotation)psiElement);
                    } else if (psiElement instanceof PsiDocComment) {
                        this.removeFromJavaDoc((PsiDocComment)psiElement);
                    } else {
                        final HashSet comments = new HashSet();
                        commentOwner.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                            public void visitComment(PsiComment comment) {
                                super.visitComment(comment);
                                if (comment.getText().contains(RemoveSuppressWarningAction.this.myID)) {
                                    comments.add(comment);
                                }
                            }
                        });
                        for (PsiComment comment : comments) {
                            try {
                                this.removeFromComment(comment, comments.size() > 1);
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    }
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public String getName() {
        String string = QuickFixBundle.message("remove.suppression.action.name", this.myID);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/RemoveSuppressWarningAction", "getName"));
        }
        return string;
    }

    private void removeFromComment(PsiComment comment, boolean checkLine) throws IncorrectOperationException {
        PsiStatement statement;
        if (checkLine && (statement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)comment, PsiStatement.class)) != null && !Comparing.strEqual((String)statement.getText(), (String)this.myProblemLine)) {
            return;
        }
        String newText = this.removeFromElementText(new PsiElement[]{comment});
        if (newText != null) {
            if (newText.isEmpty()) {
                comment.delete();
            } else {
                PsiComment newComment = JavaPsiFacade.getInstance((Project)comment.getProject()).getElementFactory().createCommentFromText("// noinspection " + newText, (PsiElement)comment);
                comment.replace((PsiElement)newComment);
            }
        }
    }

    private void removeFromJavaDoc(PsiDocComment docComment) throws IncorrectOperationException {
        PsiDocTag tag = docComment.findTagByName("noinspection");
        if (tag == null) {
            return;
        }
        String newText = this.removeFromElementText(tag.getDataElements());
        if (newText != null && newText.isEmpty()) {
            tag.delete();
        } else if (newText != null) {
            newText = "@noinspection " + newText;
            PsiDocTag newTag = JavaPsiFacade.getInstance((Project)tag.getProject()).getElementFactory().createDocTagFromText(newText);
            tag.replace((PsiElement)newTag);
        }
    }

    @Nullable
    private String removeFromElementText(PsiElement ... elements) {
        String text = "";
        for (PsiElement element : elements) {
            text = text + StringUtil.trimStart((String)element.getText(), (String)"//").trim();
        }
        text = StringUtil.trimStart((String)text, (String)"@").trim();
        List ids = StringUtil.split((String)(text = StringUtil.trimStart((String)text, (String)"noinspection").trim()), (String)",");
        int i = ArrayUtil.find((Object[])ids.toArray(), (Object)this.myID);
        if (i == -1) {
            return null;
        }
        ids.remove(i);
        return StringUtil.join((Collection)ids, (String)",");
    }

    private void removeFromAnnotation(PsiAnnotation annotation) throws IncorrectOperationException {
        PsiNameValuePair[] attributes;
        for (PsiNameValuePair attribute : attributes = annotation.getParameterList().getAttributes()) {
            PsiAnnotationMemberValue value = attribute.getValue();
            if (value instanceof PsiArrayInitializerMemberValue) {
                PsiAnnotationMemberValue[] initializers;
                for (PsiAnnotationMemberValue initializer : initializers = ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                    if (!this.removeFromValue((PsiAnnotationMemberValue)annotation, initializer, initializers.length == 1)) continue;
                    return;
                }
            }
            if (!this.removeFromValue((PsiAnnotationMemberValue)annotation, value, attributes.length == 1)) continue;
            return;
        }
    }

    private boolean removeFromValue(PsiAnnotationMemberValue parent, PsiAnnotationMemberValue value, boolean removeParent) throws IncorrectOperationException {
        String text = value.getText();
        text = StringUtil.trimStart((String)text, (String)"\"");
        if (this.myID.equals(text = StringUtil.trimEnd((String)text, (String)"\""))) {
            if (removeParent) {
                parent.delete();
            } else {
                value.delete();
            }
            return true;
        }
        return false;
    }
}

