/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProgressableTextEditorHighlightingPass
extends TextEditorHighlightingPass {
    private volatile boolean myFinished;
    private volatile long myProgressLimit;
    private final AtomicLong myProgressCount;
    private volatile long myNextChunkThreshold;
    private final String myPresentableName;
    protected final PsiFile myFile;
    @Nullable
    private final Editor myEditor;
    @NotNull
    protected final TextRange myRestrictRange;
    @NotNull
    protected final HighlightInfoProcessor myHighlightInfoProcessor;
    protected HighlightingSession myHighlightingSession;

    protected ProgressableTextEditorHighlightingPass(@NotNull Project project, @Nullable Document document, @NotNull String presentableName, @Nullable PsiFile file, @Nullable Editor editor, @NotNull TextRange restrictRange, boolean runIntentionPassAfter, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass", "<init>"));
        }
        if (restrictRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass", "<init>"));
        }
        if (highlightInfoProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass", "<init>"));
        }
        super(project, document, runIntentionPassAfter);
        this.myProgressLimit = 0L;
        this.myProgressCount = new AtomicLong();
        this.myPresentableName = presentableName;
        this.myFile = file;
        this.myEditor = editor;
        this.myRestrictRange = restrictRange;
        this.myHighlightInfoProcessor = highlightInfoProcessor;
    }

    @NotNull
    private HighlightingSession sessionCreated(@NotNull TextRange restrictRange, @NotNull PsiFile file, @Nullable Editor editor, @NotNull ProgressIndicator progress, EditorColorsScheme scheme, int passId) {
        if (restrictRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass", "sessionCreated"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass", "sessionCreated"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass", "sessionCreated"));
        }
        HighlightingSessionImpl impl = new HighlightingSessionImpl(file, editor, progress, scheme, passId, restrictRange);
        this.myHighlightingSession = impl;
        HighlightingSessionImpl highlightingSessionImpl = impl;
        if (highlightingSessionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass", "sessionCreated"));
        }
        return highlightingSessionImpl;
    }

    private void sessionFinished() {
        this.advanceProgress(Math.max(1L, this.myProgressLimit - this.myProgressCount.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass", "doCollectInformation"));
        }
        this.myFinished = false;
        if (this.myFile != null) {
            this.myHighlightingSession = this.sessionCreated(this.myRestrictRange, this.myFile, this.myEditor, progress, this.getColorsScheme(), this.getId());
        }
        try {
            this.collectInformationWithProgress(progress);
        }
        finally {
            if (this.myFile != null) {
                this.sessionFinished();
            }
        }
    }

    protected abstract void collectInformationWithProgress(@NotNull ProgressIndicator var1);

    @Override
    public final void doApplyInformationToEditor() {
        this.myFinished = true;
        this.applyInformationWithProgress();
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        daemonCodeAnalyzer.getFileStatusMap().markFileUpToDate(this.myDocument, this.getId());
    }

    protected abstract void applyInformationWithProgress();

    public double getProgress() {
        long progressLimit = this.getProgressLimit();
        if (progressLimit == 0L) {
            return -1.0;
        }
        long progressCount = this.getProgressCount();
        return progressCount > progressLimit ? 1.0 : (double)progressCount / (double)progressLimit;
    }

    public long getProgressLimit() {
        return this.myProgressLimit;
    }

    public long getProgressCount() {
        return this.myProgressCount.get();
    }

    public boolean isFinished() {
        return this.myFinished;
    }

    protected String getPresentableName() {
        return this.myPresentableName;
    }

    public void setProgressLimit(long limit) {
        this.myProgressLimit = limit;
        this.myNextChunkThreshold = Math.max(1L, limit / 100L);
    }

    public void advanceProgress(long delta) {
        long current;
        if (this.myHighlightingSession != null && (current = this.myProgressCount.addAndGet(delta)) >= this.myNextChunkThreshold) {
            double progress = this.getProgress();
            this.myNextChunkThreshold += Math.max(1L, this.myProgressLimit / 100L);
            this.myHighlightInfoProcessor.progressIsAdvanced(this.myHighlightingSession, progress);
        }
    }

    public static class EmptyPass
    extends TextEditorHighlightingPass {
        public EmptyPass(Project project, @Nullable Document document) {
            super(project, document, false);
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass$EmptyPass", "doCollectInformation"));
            }
        }

        @Override
        public void doApplyInformationToEditor() {
            FileStatusMap statusMap = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap();
            statusMap.markFileUpToDate(this.getDocument(), this.getId());
        }
    }
}

