/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdentifierUtil {
    @Nullable
    public static PsiElement getNameIdentifier(@NotNull PsiElement element) {
        PsiElement potentialIdentifier;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/IdentifierUtil", "getNameIdentifier"));
        }
        if (element instanceof PsiNameIdentifierOwner) {
            return ((PsiNameIdentifierOwner)element).getNameIdentifier();
        }
        if (element.isPhysical() && element instanceof PsiNamedElement && element.getContainingFile() != null && element.getTextRange() != null && (potentialIdentifier = element.findElementAt(element.getTextOffset() - element.getTextRange().getStartOffset())) != null && Comparing.equal((String)potentialIdentifier.getText(), (String)((PsiNamedElement)element).getName(), (boolean)false)) {
            return potentialIdentifier;
        }
        return null;
    }
}

