/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class IdentifierHighlighterPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass");
    private final PsiFile myFile;
    private final Editor myEditor;
    private final Collection<TextRange> myReadAccessRanges = Collections.synchronizedList(new ArrayList());
    private final Collection<TextRange> myWriteAccessRanges = Collections.synchronizedList(new ArrayList());
    private final int myCaretOffset;

    protected IdentifierHighlighterPass(Project project, PsiFile file, Editor editor) {
        super(project, editor.getDocument(), false);
        this.myFile = file;
        this.myEditor = editor;
        this.myCaretOffset = this.myEditor.getCaretModel().getOffset();
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        Editor injectedEditor;
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass", "doCollectInformation"));
        }
        HighlightUsagesHandlerBase handler = HighlightUsagesHandler.createCustomHandler(this.myEditor, this.myFile);
        if (handler != null) {
            List targets = handler.getTargets();
            handler.computeUsages(targets);
            List<TextRange> readUsages = handler.getReadUsages();
            for (TextRange readUsage : readUsages) {
                LOG.assertTrue(readUsage != null, (Object)("null text range from " + handler));
            }
            this.myReadAccessRanges.addAll(readUsages);
            List<TextRange> writeUsages = handler.getWriteUsages();
            for (TextRange writeUsage : writeUsages) {
                LOG.assertTrue(writeUsage != null, (Object)("null text range from " + handler));
            }
            this.myWriteAccessRanges.addAll(writeUsages);
            return;
        }
        int flags = 3;
        PsiElement myTarget = TargetElementUtilBase.getInstance().findTargetElement(this.myEditor, flags, this.myCaretOffset);
        if (myTarget == null && !PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(this.myEditor.getDocument()) && (injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.myFile, this.myCaretOffset)) != null) {
            myTarget = TargetElementUtilBase.getInstance().findTargetElement(injectedEditor, flags, injectedEditor.getCaretModel().getOffset());
        }
        if (myTarget != null) {
            this.highlightTargetUsages(myTarget);
        } else {
            ResolveResult[] results;
            PsiReference ref = TargetElementUtilBase.findReference(this.myEditor);
            if (ref instanceof PsiPolyVariantReference && (results = ((PsiPolyVariantReference)ref).multiResolve(false)).length > 0) {
                for (ResolveResult result : results) {
                    PsiElement target = result.getElement();
                    if (target == null) continue;
                    this.highlightTargetUsages(target);
                }
            }
        }
    }

    private void highlightTargetUsages(@NotNull PsiElement target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass", "highlightTargetUsages"));
        }
        ReadWriteAccessDetector detector = ReadWriteAccessDetector.findDetector((PsiElement)target);
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)target.getProject())).getFindUsagesManager();
        FindUsagesHandler findUsagesHandler = findUsagesManager.getFindUsagesHandler(target, true);
        LocalSearchScope scope = new LocalSearchScope((PsiElement)this.myFile);
        Collection refs = findUsagesHandler != null ? findUsagesHandler.findReferencesToHighlight(target, (SearchScope)scope) : ReferencesSearch.search((PsiElement)target, (SearchScope)scope).findAll();
        for (PsiReference psiReference : refs) {
            List<TextRange> textRanges = HighlightUsagesHandler.getRangesToHighlight(psiReference);
            if (detector == null || detector.getReferenceAccess(target, psiReference) == ReadWriteAccessDetector.Access.Read) {
                this.myReadAccessRanges.addAll(textRanges);
                continue;
            }
            this.myWriteAccessRanges.addAll(textRanges);
        }
        TextRange declRange = HighlightUsagesHandler.getNameIdentifierRange(this.myFile, target);
        if (declRange != null) {
            if (detector != null && detector.isDeclarationWriteAccess(target)) {
                this.myWriteAccessRanges.add(declRange);
            } else {
                this.myReadAccessRanges.add(declRange);
            }
        }
    }

    @Override
    public void doApplyInformationToEditor() {
        boolean virtSpace = TargetElementUtilBase.inVirtualSpace(this.myEditor, this.myEditor.getCaretModel().getOffset());
        List<HighlightInfo> infos = virtSpace ? Collections.emptyList() : this.getHighlights();
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, 0, this.myFile.getTextLength(), infos, this.getColorsScheme(), this.getId());
    }

    private List<HighlightInfo> getHighlights() {
        if (this.myReadAccessRanges.isEmpty() && this.myWriteAccessRanges.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Pair<Object, TextRange>> existingMarkupTooltips = new HashSet<Pair<Object, TextRange>>();
        for (RangeHighlighter highlighter : this.myEditor.getMarkupModel().getAllHighlighters()) {
            existingMarkupTooltips.add(Pair.create((Object)highlighter.getErrorStripeTooltip(), (Object)new TextRange(highlighter.getStartOffset(), highlighter.getEndOffset())));
        }
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>(this.myReadAccessRanges.size() + this.myWriteAccessRanges.size());
        for (TextRange range : this.myReadAccessRanges) {
            ContainerUtil.addIfNotNull((Object)this.createHighlightInfo(range, HighlightInfoType.ELEMENT_UNDER_CARET_READ, existingMarkupTooltips), result);
        }
        for (TextRange range : this.myWriteAccessRanges) {
            ContainerUtil.addIfNotNull((Object)this.createHighlightInfo(range, HighlightInfoType.ELEMENT_UNDER_CARET_WRITE, existingMarkupTooltips), result);
        }
        return result;
    }

    private HighlightInfo createHighlightInfo(TextRange range, HighlightInfoType type, Set<Pair<Object, TextRange>> existingMarkupTooltips) {
        int start = range.getStartOffset();
        String tooltip = start <= this.myDocument.getTextLength() ? HighlightHandlerBase.getLineTextErrorStripeTooltip(this.myDocument, start, false) : null;
        String unescapedTooltip = existingMarkupTooltips.contains(new Pair((Object)tooltip, (Object)range)) ? null : tooltip;
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(type).range(range);
        if (unescapedTooltip != null) {
            builder.unescapedToolTip(unescapedTooltip);
        }
        return builder.createUnconditionally();
    }

    public static void clearMyHighlights(Document document, Project project) {
        MarkupModel markupModel = DocumentMarkupModel.forDocument(document, project, true);
        for (RangeHighlighter highlighter : markupModel.getAllHighlighters()) {
            Object tooltip = highlighter.getErrorStripeTooltip();
            if (!(tooltip instanceof HighlightInfo)) continue;
            HighlightInfo info = (HighlightInfo)tooltip;
            if (info.type != HighlightInfoType.ELEMENT_UNDER_CARET_READ && info.type != HighlightInfoType.ELEMENT_UNDER_CARET_WRITE) continue;
            highlighter.dispose();
        }
    }
}

