/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.BatchSuppressableTool;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.codeInspection.actions.CleanupInspectionIntention;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightInfo
implements Segment {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.HighlightInfo");
    public static final HighlightInfo[] EMPTY_ARRAY = new HighlightInfo[0];
    private static final String DESCRIPTION_PLACEHOLDER = "{\u0000}";
    JComponent fileLevelComponent;
    public final TextAttributes forcedTextAttributes;
    public final TextAttributesKey forcedTextAttributesKey;
    @NotNull
    public final HighlightInfoType type;
    private int group;
    public final int startOffset;
    public final int endOffset;
    private int fixStartOffset;
    private int fixEndOffset;
    RangeMarker fixMarker;
    private final String description;
    private final String toolTip;
    @NotNull
    private final HighlightSeverity severity;
    final int navigationShift;
    volatile RangeHighlighterEx highlighter;
    public List<Pair<IntentionActionDescriptor, TextRange>> quickFixActionRanges;
    public List<Pair<IntentionActionDescriptor, RangeMarker>> quickFixActionMarkers;
    private final GutterMark gutterIconRenderer;
    private final ProblemGroup myProblemGroup;
    private volatile byte myFlags;
    private static final int BIJECTIVE_FLAG = 0;
    private static final int HAS_HINT_FLAG = 1;
    private static final int FROM_INJECTION_FLAG = 2;
    private static final int AFTER_END_OF_LINE_FLAG = 3;
    private static final int FILE_LEVEL_ANNOTATION_FLAG = 4;
    private static final int NEEDS_UPDATE_ON_TYPING_FLAG = 5;
    PsiElement psiElement;
    @NotNull
    private static final HighlightInfoFilter[] FILTERS = (HighlightInfoFilter[])HighlightInfoFilter.EXTENSION_POINT_NAME.getExtensions();
    public static final String ANNOTATOR_INSPECTION_SHORT_NAME = "Annotator";

    @NotNull
    ProperTextRange getFixTextRange() {
        ProperTextRange properTextRange = new ProperTextRange(this.fixStartOffset, this.fixEndOffset);
        if (properTextRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "getFixTextRange"));
        }
        return properTextRange;
    }

    void setFromInjection(boolean fromInjection) {
        this.setFlag(2, fromInjection);
    }

    public String getToolTip() {
        String toolTip = this.toolTip;
        String description = this.description;
        if (toolTip == null || description == null || !toolTip.contains(DESCRIPTION_PLACEHOLDER)) {
            return toolTip;
        }
        String decoded = StringUtil.replace((String)toolTip, (String)DESCRIPTION_PLACEHOLDER, (String)XmlStringUtil.escapeString((String)description));
        String niceTooltip = XmlStringUtil.wrapInHtml((CharSequence)decoded);
        return niceTooltip;
    }

    private static String encodeTooltip(String toolTip, String description) {
        String encoded;
        if (toolTip == null || description == null) {
            return toolTip;
        }
        String unescaped = StringUtil.unescapeXml((String)XmlStringUtil.stripHtml((String)toolTip));
        String string = encoded = description.isEmpty() ? unescaped : StringUtil.replace((String)unescaped, (String)description, (String)DESCRIPTION_PLACEHOLDER);
        if (encoded == unescaped) {
            return toolTip;
        }
        if (encoded.equals(DESCRIPTION_PLACEHOLDER)) {
            encoded = DESCRIPTION_PLACEHOLDER;
        }
        return encoded;
    }

    public String getDescription() {
        return this.description;
    }

    private boolean isFlagSet(@FlagConstant int flag) {
        assert (flag < 8);
        int state = this.myFlags >> flag;
        return (state & 1) != 0;
    }

    private void setFlag(@FlagConstant int flag, boolean value) {
        assert (flag < 8);
        int state = value ? 1 : 0;
        this.myFlags = (byte)(this.myFlags & ~(1 << flag) | state << flag);
    }

    boolean isFileLevelAnnotation() {
        return this.isFlagSet(4);
    }

    boolean isBijective() {
        return this.isFlagSet(0);
    }

    void setBijective(boolean bijective) {
        this.setFlag(0, bijective);
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.severity;
        if (highlightSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "getSeverity"));
        }
        return highlightSeverity;
    }

    public boolean isAfterEndOfLine() {
        return this.isFlagSet(3);
    }

    @Nullable
    public TextAttributes getTextAttributes(@Nullable PsiElement element, @Nullable EditorColorsScheme editorColorsScheme) {
        if (this.forcedTextAttributes != null) {
            return this.forcedTextAttributes;
        }
        EditorColorsScheme colorsScheme = HighlightInfo.getColorsScheme(editorColorsScheme);
        if (colorsScheme == null) {
            return null;
        }
        if (this.forcedTextAttributesKey != null) {
            return colorsScheme.getAttributes(this.forcedTextAttributesKey);
        }
        return HighlightInfo.getAttributesByType(element, this.type, (TextAttributesScheme)colorsScheme);
    }

    public static TextAttributes getAttributesByType(@Nullable PsiElement element, @NotNull HighlightInfoType type, @NotNull TextAttributesScheme colorsScheme) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "getAttributesByType"));
        }
        if (colorsScheme == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "getAttributesByType"));
        }
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(element != null ? element.getProject() : null);
        TextAttributes textAttributes = severityRegistrar.getTextAttributesBySeverity(type.getSeverity(element));
        if (textAttributes != null) {
            return textAttributes;
        }
        TextAttributesKey key = type.getAttributesKey();
        return colorsScheme.getAttributes(key);
    }

    @Nullable
    public Color getErrorStripeMarkColor(@NotNull PsiElement element, @Nullable EditorColorsScheme colorsScheme) {
        Color errorStripeColor;
        TextAttributes forcedTextAttributes;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "getErrorStripeMarkColor"));
        }
        if (this.forcedTextAttributes != null && this.forcedTextAttributes.getErrorStripeColor() != null) {
            return this.forcedTextAttributes.getErrorStripeColor();
        }
        EditorColorsScheme scheme = HighlightInfo.getColorsScheme(colorsScheme);
        if (scheme == null) {
            return null;
        }
        if (this.forcedTextAttributesKey != null && (forcedTextAttributes = scheme.getAttributes(this.forcedTextAttributesKey)) != null && (errorStripeColor = forcedTextAttributes.getErrorStripeColor()) != null) {
            return errorStripeColor;
        }
        if (this.getSeverity() == HighlightSeverity.ERROR) {
            return scheme.getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.WARNING) {
            return scheme.getAttributes(CodeInsightColors.WARNINGS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.INFO) {
            return scheme.getAttributes(CodeInsightColors.INFO_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.WEAK_WARNING) {
            return scheme.getAttributes(CodeInsightColors.WEAK_WARNING_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING) {
            return scheme.getAttributes(CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING).getErrorStripeColor();
        }
        TextAttributes attributes = HighlightInfo.getAttributesByType(element, this.type, (TextAttributesScheme)scheme);
        return attributes == null ? null : attributes.getErrorStripeColor();
    }

    @Nullable
    private static EditorColorsScheme getColorsScheme(@Nullable EditorColorsScheme customScheme) {
        if (customScheme != null) {
            return customScheme;
        }
        return EditorColorsManager.getInstance().getGlobalScheme();
    }

    @Nullable
    @NonNls
    private static String htmlEscapeToolTip(@Nullable String unescapedTooltip) {
        return unescapedTooltip == null ? null : XmlStringUtil.wrapInHtml((CharSequence)XmlStringUtil.escapeString((String)unescapedTooltip));
    }

    public boolean needUpdateOnTyping() {
        return this.isFlagSet(5);
    }

    HighlightInfo(@Nullable TextAttributes forcedTextAttributes, @Nullable TextAttributesKey forcedTextAttributesKey, @NotNull HighlightInfoType type, int startOffset, int endOffset, @Nullable String escapedDescription, @Nullable String escapedToolTip, @NotNull HighlightSeverity severity, boolean afterEndOfLine, @Nullable Boolean needsUpdateOnTyping, boolean isFileLevelAnnotation, int navigationShift, ProblemGroup problemGroup, GutterMark gutterIconRenderer) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "<init>"));
        }
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "<init>"));
        }
        if (startOffset < 0 || startOffset > endOffset) {
            LOG.error("Incorrect highlightInfo bounds. description=" + escapedDescription + "; startOffset=" + startOffset + "; endOffset=" + endOffset + ";type=" + type);
        }
        this.forcedTextAttributes = forcedTextAttributes;
        this.forcedTextAttributesKey = forcedTextAttributesKey;
        this.type = type;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.fixStartOffset = startOffset;
        this.fixEndOffset = endOffset;
        this.description = escapedDescription;
        this.toolTip = HighlightInfo.encodeTooltip(escapedToolTip, escapedDescription);
        this.severity = severity;
        this.setFlag(3, afterEndOfLine);
        this.setFlag(5, HighlightInfo.calcNeedUpdateOnTyping(needsUpdateOnTyping, type));
        this.setFlag(4, isFileLevelAnnotation);
        this.navigationShift = navigationShift;
        this.myProblemGroup = problemGroup;
        this.gutterIconRenderer = gutterIconRenderer;
    }

    private static boolean calcNeedUpdateOnTyping(@Nullable Boolean needsUpdateOnTyping, HighlightInfoType type) {
        if (needsUpdateOnTyping != null) {
            return needsUpdateOnTyping;
        }
        if (type == HighlightInfoType.TODO) {
            return false;
        }
        if (type == HighlightInfoType.LOCAL_VARIABLE) {
            return false;
        }
        if (type == HighlightInfoType.INSTANCE_FIELD) {
            return false;
        }
        if (type == HighlightInfoType.STATIC_FIELD) {
            return false;
        }
        if (type == HighlightInfoType.STATIC_FINAL_FIELD) {
            return false;
        }
        if (type == HighlightInfoType.PARAMETER) {
            return false;
        }
        if (type == HighlightInfoType.METHOD_CALL) {
            return false;
        }
        if (type == HighlightInfoType.METHOD_DECLARATION) {
            return false;
        }
        if (type == HighlightInfoType.STATIC_METHOD) {
            return false;
        }
        if (type == HighlightInfoType.ABSTRACT_METHOD) {
            return false;
        }
        if (type == HighlightInfoType.INHERITED_METHOD) {
            return false;
        }
        if (type == HighlightInfoType.CONSTRUCTOR_CALL) {
            return false;
        }
        if (type == HighlightInfoType.CONSTRUCTOR_DECLARATION) {
            return false;
        }
        if (type == HighlightInfoType.INTERFACE_NAME) {
            return false;
        }
        if (type == HighlightInfoType.ABSTRACT_CLASS_NAME) {
            return false;
        }
        if (type == HighlightInfoType.ENUM_NAME) {
            return false;
        }
        if (type == HighlightInfoType.CLASS_NAME) {
            return false;
        }
        return type != HighlightInfoType.ANONYMOUS_CLASS_NAME;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HighlightInfo)) {
            return false;
        }
        HighlightInfo info = (HighlightInfo)obj;
        return info.getSeverity() == this.getSeverity() && info.startOffset == this.startOffset && info.endOffset == this.endOffset && Comparing.equal((Object)info.type, (Object)this.type) && Comparing.equal((Object)info.gutterIconRenderer, (Object)this.gutterIconRenderer) && Comparing.equal((Object)info.forcedTextAttributes, (Object)this.forcedTextAttributes) && Comparing.equal((Object)info.forcedTextAttributesKey, (Object)this.forcedTextAttributesKey) && Comparing.strEqual((String)info.getDescription(), (String)this.getDescription());
    }

    public boolean equalsByActualOffset(HighlightInfo info) {
        if (info == this) {
            return true;
        }
        return info.getSeverity() == this.getSeverity() && info.getActualStartOffset() == this.getActualStartOffset() && info.getActualEndOffset() == this.getActualEndOffset() && Comparing.equal((Object)info.type, (Object)this.type) && Comparing.equal((Object)info.gutterIconRenderer, (Object)this.gutterIconRenderer) && Comparing.equal((Object)info.forcedTextAttributes, (Object)this.forcedTextAttributes) && Comparing.equal((Object)info.forcedTextAttributesKey, (Object)this.forcedTextAttributesKey) && Comparing.strEqual((String)info.getDescription(), (String)this.getDescription());
    }

    public int hashCode() {
        return this.startOffset;
    }

    @NonNls
    public String toString() {
        return this.getDescription() != null ? this.getDescription() : "";
    }

    public String paramString() {
        String s = "HighlightInfo(" + this.startOffset + "," + this.endOffset + ")";
        if (this.getActualStartOffset() != this.startOffset || this.getActualEndOffset() != this.endOffset) {
            s = s + "; actual: (" + this.getActualStartOffset() + "," + this.getActualEndOffset() + ")";
        }
        if (this.highlighter != null) {
            s = s + " text='" + this.getText() + "'";
        }
        if (this.getDescription() != null) {
            s = s + ", description='" + this.getDescription() + "'";
        }
        s = s + " severity=" + this.getSeverity();
        s = s + " group=" + this.getGroup();
        if (this.quickFixActionRanges != null) {
            s = s + "; quickFixes: " + this.quickFixActionRanges;
        }
        if (this.gutterIconRenderer != null) {
            s = s + "; gutter: " + this.gutterIconRenderer;
        }
        return s;
    }

    @NotNull
    public static Builder newHighlightInfo(@NotNull HighlightInfoType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "newHighlightInfo"));
        }
        B b = new B(type);
        if (b == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "newHighlightInfo"));
        }
        return b;
    }

    void setGroup(int group) {
        this.group = group;
    }

    private static boolean isAcceptedByFilters(@NotNull HighlightInfo info, @Nullable PsiElement psiElement) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "isAcceptedByFilters"));
        }
        PsiFile file = psiElement == null ? null : psiElement.getContainingFile();
        for (HighlightInfoFilter filter : FILTERS) {
            if (filter.accept(info, file)) continue;
            return false;
        }
        info.psiElement = psiElement;
        return true;
    }

    public GutterMark getGutterIconRenderer() {
        return this.gutterIconRenderer;
    }

    @Nullable
    public ProblemGroup getProblemGroup() {
        return this.myProblemGroup;
    }

    @NotNull
    public static HighlightInfo fromAnnotation(@NotNull Annotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "fromAnnotation"));
        }
        HighlightInfo highlightInfo = HighlightInfo.fromAnnotation(annotation, null, false);
        if (highlightInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "fromAnnotation"));
        }
        return highlightInfo;
    }

    @NotNull
    public static HighlightInfo fromAnnotation(@NotNull Annotation annotation, @Nullable TextRange fixedRange, boolean batchMode) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "fromAnnotation"));
        }
        TextAttributes forcedAttributes = annotation.getEnforcedTextAttributes();
        TextAttributesKey forcedAttributesKey = forcedAttributes == null ? annotation.getTextAttributes() : null;
        HighlightInfo info = new HighlightInfo(forcedAttributes, forcedAttributesKey, HighlightInfo.convertType(annotation), fixedRange != null ? fixedRange.getStartOffset() : annotation.getStartOffset(), fixedRange != null ? fixedRange.getEndOffset() : annotation.getEndOffset(), annotation.getMessage(), annotation.getTooltip(), annotation.getSeverity(), annotation.isAfterEndOfLine(), annotation.needsUpdateOnTyping(), annotation.isFileLevelAnnotation(), 0, annotation.getProblemGroup(), (GutterMark)annotation.getGutterIconRenderer());
        HighlightInfo.appendFixes(fixedRange, info, batchMode ? annotation.getBatchFixes() : annotation.getQuickFixes());
        HighlightInfo highlightInfo = info;
        if (highlightInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "fromAnnotation"));
        }
        return highlightInfo;
    }

    private static void appendFixes(@Nullable TextRange fixedRange, @NotNull HighlightInfo info, List<Annotation.QuickFixInfo> fixes) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "appendFixes"));
        }
        if (fixes != null) {
            for (Annotation.QuickFixInfo quickFixInfo : fixes) {
                TextRange range = fixedRange != null ? fixedRange : quickFixInfo.textRange;
                HighlightDisplayKey key = quickFixInfo.key != null ? quickFixInfo.key : HighlightDisplayKey.find((String)ANNOTATOR_INSPECTION_SHORT_NAME);
                info.registerFix(quickFixInfo.quickFix, null, HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)key), range, key);
            }
        }
    }

    public static HighlightInfoType convertType(@NotNull Annotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "convertType"));
        }
        ProblemHighlightType type = annotation.getHighlightType();
        if (type == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
            return HighlightInfoType.UNUSED_SYMBOL;
        }
        if (type == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL) {
            return HighlightInfoType.WRONG_REF;
        }
        if (type == ProblemHighlightType.LIKE_DEPRECATED) {
            return HighlightInfoType.DEPRECATED;
        }
        return HighlightInfo.convertSeverity(annotation.getSeverity());
    }

    @NotNull
    public static HighlightInfoType convertSeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "convertSeverity"));
        }
        HighlightInfoType highlightInfoType = severity == HighlightSeverity.ERROR ? HighlightInfoType.ERROR : (severity == HighlightSeverity.WARNING ? HighlightInfoType.WARNING : (severity == HighlightSeverity.INFO ? HighlightInfoType.INFO : (severity == HighlightSeverity.WEAK_WARNING ? HighlightInfoType.WEAK_WARNING : (severity == HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING ? HighlightInfoType.GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER : HighlightInfoType.INFORMATION))));
        if (highlightInfoType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "convertSeverity"));
        }
        return highlightInfoType;
    }

    public static ProblemHighlightType convertType(HighlightInfoType infoType) {
        if (infoType == HighlightInfoType.ERROR || infoType == HighlightInfoType.WRONG_REF) {
            return ProblemHighlightType.ERROR;
        }
        if (infoType == HighlightInfoType.WARNING) {
            return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }
        if (infoType == HighlightInfoType.INFORMATION) {
            return ProblemHighlightType.INFORMATION;
        }
        return ProblemHighlightType.WEAK_WARNING;
    }

    public static ProblemHighlightType convertSeverityToProblemHighlight(HighlightSeverity severity) {
        return severity == HighlightSeverity.ERROR ? ProblemHighlightType.ERROR : (severity == HighlightSeverity.WARNING ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : (severity == HighlightSeverity.INFO ? ProblemHighlightType.INFO : (severity == HighlightSeverity.WEAK_WARNING ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION)));
    }

    public boolean hasHint() {
        return this.isFlagSet(1);
    }

    void setHint(boolean hasHint) {
        this.setFlag(1, hasHint);
    }

    public int getActualStartOffset() {
        RangeHighlighterEx h = this.highlighter;
        return h == null || !h.isValid() ? this.startOffset : h.getStartOffset();
    }

    public int getActualEndOffset() {
        RangeHighlighterEx h = this.highlighter;
        return h == null || !h.isValid() ? this.endOffset : h.getEndOffset();
    }

    public int getStartOffset() {
        return this.getActualStartOffset();
    }

    public int getEndOffset() {
        return this.getActualEndOffset();
    }

    int getGroup() {
        return this.group;
    }

    boolean isFromInjection() {
        return this.isFlagSet(2);
    }

    @NotNull
    public String getText() {
        RangeHighlighterEx highlighter = this.highlighter;
        if (highlighter == null) {
            throw new RuntimeException("info not applied yet");
        }
        if (!highlighter.isValid()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "getText"));
            }
            return "";
        }
        String string = highlighter.getDocument().getText(TextRange.create((Segment)highlighter));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "getText"));
        }
        return string;
    }

    public void registerFix(@Nullable IntentionAction action, @Nullable List<IntentionAction> options, @Nullable String displayName, @Nullable TextRange fixRange, @Nullable HighlightDisplayKey key) {
        if (action == null) {
            return;
        }
        if (fixRange == null) {
            fixRange = new TextRange(this.startOffset, this.endOffset);
        }
        if (this.quickFixActionRanges == null) {
            this.quickFixActionRanges = ContainerUtil.createLockFreeCopyOnWriteList();
        }
        IntentionActionDescriptor desc = new IntentionActionDescriptor(action, options, displayName, null, key, this.getProblemGroup());
        this.quickFixActionRanges.add((Pair<IntentionActionDescriptor, TextRange>)Pair.create((Object)desc, (Object)fixRange));
        this.fixStartOffset = Math.min(this.fixStartOffset, fixRange.getStartOffset());
        this.fixEndOffset = Math.max(this.fixEndOffset, fixRange.getEndOffset());
        if (action instanceof HintAction) {
            this.setHint(true);
        }
    }

    public void unregisterQuickFix(@NotNull Condition<IntentionAction> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "unregisterQuickFix"));
        }
        Iterator<Pair<IntentionActionDescriptor, TextRange>> it = this.quickFixActionRanges.iterator();
        while (it.hasNext()) {
            Pair<IntentionActionDescriptor, TextRange> pair = it.next();
            if (!condition.value((Object)((IntentionActionDescriptor)pair.first).getAction())) continue;
            it.remove();
        }
    }

    public static class IntentionActionDescriptor {
        private final IntentionAction myAction;
        private volatile List<IntentionAction> myOptions;
        private volatile HighlightDisplayKey myKey;
        private final ProblemGroup myProblemGroup;
        private final String myDisplayName;
        private final Icon myIcon;

        public IntentionActionDescriptor(@NotNull IntentionAction action, List<IntentionAction> options, String displayName) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor", "<init>"));
            }
            this(action, options, displayName, null);
        }

        public IntentionActionDescriptor(@NotNull IntentionAction action, Icon icon) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor", "<init>"));
            }
            this(action, null, null, icon);
        }

        public IntentionActionDescriptor(@NotNull IntentionAction action, @Nullable List<IntentionAction> options, @Nullable String displayName, @Nullable Icon icon) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor", "<init>"));
            }
            this(action, options, displayName, icon, null, null);
        }

        public IntentionActionDescriptor(@NotNull IntentionAction action, @Nullable List<IntentionAction> options, @Nullable String displayName, @Nullable Icon icon, @Nullable HighlightDisplayKey key, @Nullable ProblemGroup problemGroup) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor", "<init>"));
            }
            this.myAction = action;
            this.myOptions = options;
            this.myDisplayName = displayName;
            this.myIcon = icon;
            this.myKey = key;
            this.myProblemGroup = problemGroup;
        }

        @NotNull
        public IntentionAction getAction() {
            IntentionAction intentionAction = this.myAction;
            if (intentionAction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor", "getAction"));
            }
            return intentionAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public List<IntentionAction> getOptions(@NotNull PsiElement element, @Nullable Editor editor) {
            HighlightDisplayKey idkey;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor", "getOptions"));
            }
            if (editor != null && Boolean.FALSE.equals(editor.getUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY))) {
                return null;
            }
            List options = this.myOptions;
            HighlightDisplayKey key = this.myKey;
            if (this.myProblemGroup != null) {
                HighlightDisplayKey problemGroupKey;
                String problemName = this.myProblemGroup.getProblemName();
                HighlightDisplayKey highlightDisplayKey = problemGroupKey = problemName != null ? HighlightDisplayKey.findById((String)problemName) : null;
                if (problemGroupKey != null) {
                    key = problemGroupKey;
                }
            }
            if (options != null || key == null) {
                return options;
            }
            List newOptions = IntentionManager.getInstance().getStandardIntentionOptions(key, element);
            InspectionProfile profile = InspectionProjectProfileManager.getInstance(element.getProject()).getInspectionProfile();
            InspectionToolWrapper toolWrapper = profile.getInspectionTool(key.toString(), element);
            if (!(toolWrapper instanceof LocalInspectionToolWrapper) && (idkey = HighlightDisplayKey.findById((String)key.toString())) != null) {
                toolWrapper = profile.getInspectionTool(idkey.toString(), element);
            }
            if (toolWrapper != null) {
                Object[] suppressActions;
                Class<?> aClass;
                InspectionProfileEntry wrappedTool;
                if (toolWrapper instanceof LocalInspectionToolWrapper) {
                    wrappedTool = ((LocalInspectionToolWrapper)toolWrapper).getTool();
                    aClass = this.myAction.getClass();
                    if (this.myAction instanceof QuickFixWrapper) {
                        aClass = ((QuickFixWrapper)this.myAction).getFix().getClass();
                    }
                    newOptions.add(new CleanupInspectionIntention(toolWrapper, aClass));
                } else if (toolWrapper instanceof GlobalInspectionToolWrapper) {
                    wrappedTool = ((GlobalInspectionToolWrapper)toolWrapper).getTool();
                    if (wrappedTool instanceof GlobalSimpleInspectionTool && (this.myAction instanceof LocalQuickFix || this.myAction instanceof QuickFixWrapper)) {
                        aClass = this.myAction.getClass();
                        if (this.myAction instanceof QuickFixWrapper) {
                            aClass = ((QuickFixWrapper)this.myAction).getFix().getClass();
                        }
                        newOptions.add(new CleanupInspectionIntention(toolWrapper, aClass));
                    }
                } else {
                    throw new AssertionError((Object)("unknown tool: " + toolWrapper + "; key: " + this.myKey));
                }
                if (wrappedTool instanceof CustomSuppressableInspectionTool && (suppressActions = ((CustomSuppressableInspectionTool)wrappedTool).getSuppressActions(element)) != null) {
                    ContainerUtil.addAll((Collection)newOptions, (Object[])suppressActions);
                }
                if (wrappedTool instanceof BatchSuppressableTool) {
                    suppressActions = ((BatchSuppressableTool)wrappedTool).getBatchSuppressActions(element);
                    ContainerUtil.addAll((Collection)newOptions, (Iterable)ContainerUtil.map((Object[])suppressActions, (Function)new Function<SuppressQuickFix, IntentionAction>(){

                        public IntentionAction fun(SuppressQuickFix fix) {
                            return SuppressIntentionActionFromFix.convertBatchToSuppressIntentionAction(fix);
                        }
                    }));
                }
            }
            if (this.myProblemGroup instanceof SuppressableProblemGroup) {
                Object[] suppressActions = ((SuppressableProblemGroup)this.myProblemGroup).getSuppressActions(element);
                ContainerUtil.addAll((Collection)newOptions, (Object[])suppressActions);
            }
            IntentionActionDescriptor intentionActionDescriptor = this;
            synchronized (intentionActionDescriptor) {
                options = this.myOptions;
                if (options == null) {
                    this.myOptions = options = newOptions;
                }
                this.myKey = null;
            }
            return options;
        }

        @Nullable
        public String getDisplayName() {
            return this.myDisplayName;
        }

        @NonNls
        public String toString() {
            String text = this.getAction().getText();
            return "descriptor: " + (text.isEmpty() ? this.getAction().getClass() : text);
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        public boolean equals(Object obj) {
            return obj instanceof IntentionActionDescriptor && this.myAction.equals(((IntentionActionDescriptor)obj).myAction);
        }
    }

    private static class B
    implements Builder {
        private Boolean myNeedsUpdateOnTyping;
        private TextAttributes forcedTextAttributes;
        private TextAttributesKey forcedTextAttributesKey;
        private final HighlightInfoType type;
        private int startOffset;
        private int endOffset;
        private String escapedDescription;
        private String escapedToolTip;
        private HighlightSeverity severity;
        private boolean isAfterEndOfLine;
        private boolean isFileLevelAnnotation;
        private int navigationShift;
        private GutterIconRenderer gutterIconRenderer;
        private ProblemGroup problemGroup;
        private PsiElement psiElement;

        public B(@NotNull HighlightInfoType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "<init>"));
            }
            this.startOffset = -1;
            this.endOffset = -1;
            this.navigationShift = 0;
            this.type = type;
        }

        @Override
        @NotNull
        public Builder gutterIconRenderer(@NotNull GutterIconRenderer gutterIconRenderer) {
            if (gutterIconRenderer == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "gutterIconRenderer"));
            }
            assert (this.gutterIconRenderer == null) : "gutterIconRenderer already set";
            this.gutterIconRenderer = gutterIconRenderer;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "gutterIconRenderer"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder problemGroup(@NotNull ProblemGroup problemGroup) {
            if (problemGroup == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "problemGroup"));
            }
            assert (this.problemGroup == null) : "problemGroup already set";
            this.problemGroup = problemGroup;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "problemGroup"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder description(@NotNull String description) {
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "description"));
            }
            assert (this.escapedDescription == null) : "description already set";
            this.escapedDescription = description;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "description"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder descriptionAndTooltip(@NotNull String description) {
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "descriptionAndTooltip"));
            }
            Builder builder = this.description(description).unescapedToolTip(description);
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "descriptionAndTooltip"));
            }
            return builder;
        }

        @Override
        @NotNull
        public Builder textAttributes(@NotNull TextAttributes attributes) {
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "textAttributes"));
            }
            assert (this.forcedTextAttributes == null) : "textattributes already set";
            this.forcedTextAttributes = attributes;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "textAttributes"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder textAttributes(@NotNull TextAttributesKey attributesKey) {
            if (attributesKey == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "textAttributes"));
            }
            assert (this.forcedTextAttributesKey == null) : "textattributesKey already set";
            this.forcedTextAttributesKey = attributesKey;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "textAttributes"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder unescapedToolTip(@NotNull String unescapedToolTip) {
            if (unescapedToolTip == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "unescapedToolTip"));
            }
            assert (this.escapedToolTip == null) : "Tooltip was already set";
            this.escapedToolTip = HighlightInfo.htmlEscapeToolTip(unescapedToolTip);
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "unescapedToolTip"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder escapedToolTip(@NotNull String escapedToolTip) {
            if (escapedToolTip == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "escapedToolTip"));
            }
            assert (this.escapedToolTip == null) : "Tooltip was already set";
            this.escapedToolTip = escapedToolTip;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "escapedToolTip"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder range(int start, int end) {
            assert (this.startOffset == -1 && this.endOffset == -1) : "Offsets already set";
            this.startOffset = start;
            this.endOffset = end;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder range(@NotNull TextRange textRange) {
            if (textRange == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            assert (this.startOffset == -1 && this.endOffset == -1) : "Offsets already set";
            this.startOffset = textRange.getStartOffset();
            this.endOffset = textRange.getEndOffset();
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder range(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            Builder builder = this.range(node.getPsi());
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            return builder;
        }

        @Override
        @NotNull
        public Builder range(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            assert (this.psiElement == null) : " psiElement already set";
            this.psiElement = element;
            Builder builder = this.range(element.getTextRange());
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            return builder;
        }

        @Override
        @NotNull
        public Builder range(@NotNull PsiElement element, int start, int end) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            assert (this.psiElement == null) : " psiElement already set";
            this.psiElement = element;
            Builder builder = this.range(start, end);
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            return builder;
        }

        @Override
        @NotNull
        public Builder endOfLine() {
            this.isAfterEndOfLine = true;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "endOfLine"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder needsUpdateOnTyping(boolean update) {
            assert (this.myNeedsUpdateOnTyping == null) : " needsUpdateOnTyping already set";
            this.myNeedsUpdateOnTyping = update;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "needsUpdateOnTyping"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder severity(@NotNull HighlightSeverity severity) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "severity"));
            }
            assert (this.severity == null) : " severity already set";
            this.severity = severity;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "severity"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder fileLevelAnnotation() {
            this.isFileLevelAnnotation = true;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "fileLevelAnnotation"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder navigationShift(int navigationShift) {
            this.navigationShift = navigationShift;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "navigationShift"));
            }
            return b;
        }

        @Override
        @Nullable
        public HighlightInfo create() {
            HighlightInfo info = this.createUnconditionally();
            LOG.assertTrue(this.psiElement != null || this.severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY || this.severity == HighlightInfoType.INJECTED_FRAGMENT_SEVERITY || ArrayUtilRt.find((Object[])HighlightSeverity.DEFAULT_SEVERITIES, (Object)this.severity) != -1, (Object)"Custom type requires not-null element to detect its text attributes");
            if (!HighlightInfo.isAcceptedByFilters(info, this.psiElement)) {
                return null;
            }
            return info;
        }

        @Override
        @NotNull
        public HighlightInfo createUnconditionally() {
            if (this.severity == null) {
                this.severity = this.type.getSeverity(this.psiElement);
            }
            HighlightInfo highlightInfo = new HighlightInfo(this.forcedTextAttributes, this.forcedTextAttributesKey, this.type, this.startOffset, this.endOffset, this.escapedDescription, this.escapedToolTip, this.severity, this.isAfterEndOfLine, this.myNeedsUpdateOnTyping, this.isFileLevelAnnotation, this.navigationShift, this.problemGroup, (GutterMark)this.gutterIconRenderer);
            if (highlightInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "createUnconditionally"));
            }
            return highlightInfo;
        }
    }

    public static interface Builder {
        @NotNull
        public Builder range(@NotNull TextRange var1);

        @NotNull
        public Builder range(@NotNull ASTNode var1);

        @NotNull
        public Builder range(@NotNull PsiElement var1);

        @NotNull
        public Builder range(@NotNull PsiElement var1, int var2, int var3);

        @NotNull
        public Builder range(int var1, int var2);

        @NotNull
        public Builder gutterIconRenderer(@NotNull GutterIconRenderer var1);

        @NotNull
        public Builder problemGroup(@NotNull ProblemGroup var1);

        @NotNull
        public Builder description(@NotNull String var1);

        @NotNull
        public Builder descriptionAndTooltip(@NotNull String var1);

        @NotNull
        public Builder textAttributes(@NotNull TextAttributes var1);

        @NotNull
        public Builder textAttributes(@NotNull TextAttributesKey var1);

        @NotNull
        public Builder unescapedToolTip(@NotNull String var1);

        @NotNull
        public Builder escapedToolTip(@NotNull String var1);

        @NotNull
        public Builder endOfLine();

        @NotNull
        public Builder needsUpdateOnTyping(boolean var1);

        @NotNull
        public Builder severity(@NotNull HighlightSeverity var1);

        @NotNull
        public Builder fileLevelAnnotation();

        @NotNull
        public Builder navigationShift(int var1);

        @Nullable(value="null means filtered out")
        public HighlightInfo create();

        @NotNull
        public HighlightInfo createUnconditionally();
    }

    static @interface FlagConstant {
    }
}

