/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.ExternalToolPassFactory;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExternalToolPass
extends TextEditorHighlightingPass {
    private final PsiFile myFile;
    private final int myStartOffset;
    private final int myEndOffset;
    private final AnnotationHolderImpl myAnnotationHolder;
    private final Editor myEditor;
    private final Map<ExternalAnnotator, MyData> myAnnotator2DataMap;
    private final ExternalToolPassFactory myExternalToolPassFactory;

    public ExternalToolPass(@NotNull ExternalToolPassFactory externalToolPassFactory, @NotNull PsiFile file, @NotNull Editor editor, int startOffset, int endOffset) {
        if (externalToolPassFactory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "<init>"));
        }
        super(file.getProject(), editor.getDocument(), false);
        this.myAnnotator2DataMap = new HashMap();
        this.myEditor = editor;
        this.myFile = file;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myAnnotationHolder = new AnnotationHolderImpl(new AnnotationSession(file));
        this.myExternalToolPassFactory = externalToolPassFactory;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "doCollectInformation"));
        }
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        Set relevantLanguages = viewProvider.getLanguages();
        for (Language language : relevantLanguages) {
            List externalAnnotators;
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!HighlightingLevelManager.getInstance(this.myProject).shouldInspect((PsiElement)psiRoot) || (externalAnnotators = ExternalLanguageAnnotators.allForFile((Language)language, (PsiFile)psiRoot)).isEmpty()) continue;
            DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
            boolean errorFound = daemonCodeAnalyzer.getFileStatusMap().wasErrorFound(this.myDocument);
            for (ExternalAnnotator externalAnnotator : externalAnnotators) {
                Object collectedInfo = externalAnnotator.collectInformation(psiRoot, this.myEditor, errorFound);
                if (collectedInfo == null) continue;
                this.myAnnotator2DataMap.put(externalAnnotator, new MyData(psiRoot, collectedInfo));
            }
        }
    }

    @Override
    public void doApplyInformationToEditor() {
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        daemonCodeAnalyzer.getFileStatusMap().markFileUpToDate(this.myDocument, this.getId());
        final long modificationStampBefore = this.myDocument.getModificationStamp();
        Update update = new Update(this.myFile){

            public void setRejected() {
                super.setRejected();
                ExternalToolPass.this.doFinish(Collections.emptyList());
            }

            public void run() {
                if (ExternalToolPass.this.documentChanged(modificationStampBefore) || ExternalToolPass.this.myProject.isDisposed()) {
                    ExternalToolPass.this.doFinish(Collections.emptyList());
                    return;
                }
                ExternalToolPass.this.doAnnotate();
                if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (ExternalToolPass.this.documentChanged(modificationStampBefore) || ExternalToolPass.this.myProject.isDisposed()) {
                            ExternalToolPass.this.doFinish(Collections.emptyList());
                            return;
                        }
                        ExternalToolPass.this.collectHighlighters();
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                List highlights = ExternalToolPass.this.documentChanged(modificationStampBefore) || ExternalToolPass.this.myProject.isDisposed() ? Collections.emptyList() : ExternalToolPass.this.getHighlights();
                                ExternalToolPass.this.doFinish(highlights);
                            }
                        }, ModalityState.stateForComponent((Component)ExternalToolPass.this.myEditor.getComponent()));
                    }
                })) {
                    ExternalToolPass.this.doFinish(Collections.emptyList());
                }
            }
        };
        this.myExternalToolPassFactory.scheduleExternalActivity(update);
    }

    private boolean documentChanged(long modificationStampBefore) {
        return this.myDocument.getModificationStamp() != modificationStampBefore;
    }

    @NotNull
    private List<HighlightInfo> getHighlights() {
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        Iterator i$ = this.myAnnotationHolder.iterator();
        while (i$.hasNext()) {
            Annotation annotation = (Annotation)i$.next();
            infos.add(HighlightInfo.fromAnnotation(annotation));
        }
        ArrayList<HighlightInfo> arrayList = infos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "getHighlights"));
        }
        return arrayList;
    }

    private void collectHighlighters() {
        for (ExternalAnnotator annotator : this.myAnnotator2DataMap.keySet()) {
            MyData data = this.myAnnotator2DataMap.get(annotator);
            if (data == null) continue;
            annotator.apply(data.myPsiRoot, data.myAnnotationResult, (AnnotationHolder)this.myAnnotationHolder);
        }
    }

    private void doFinish(final @NotNull List<HighlightInfo> highlights) {
        if (highlights == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "doFinish"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!ExternalToolPass.this.myProject.isDisposed()) {
                    UpdateHighlightersUtil.setHighlightersToEditor(ExternalToolPass.this.myProject, ExternalToolPass.this.myDocument, ExternalToolPass.this.myStartOffset, ExternalToolPass.this.myEndOffset, highlights, ExternalToolPass.this.getColorsScheme(), ExternalToolPass.this.getId());
                }
            }
        });
    }

    private void doAnnotate() {
        for (ExternalAnnotator annotator : this.myAnnotator2DataMap.keySet()) {
            MyData data = this.myAnnotator2DataMap.get(annotator);
            if (data == null) continue;
            data.myAnnotationResult = annotator.doAnnotate(data.myCollectedInfo);
        }
    }

    private static class MyData {
        private final PsiFile myPsiRoot;
        private final Object myCollectedInfo;
        private volatile Object myAnnotationResult;

        private MyData(@NotNull PsiFile psiRoot, @NotNull Object collectedInfo) {
            if (psiRoot == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/ExternalToolPass$MyData", "<init>"));
            }
            if (collectedInfo == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/ExternalToolPass$MyData", "<init>"));
            }
            this.myPsiRoot = psiRoot;
            this.myCollectedInfo = collectedInfo;
        }
    }
}

