/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

class CodeFoldingPass
extends TextEditorHighlightingPass
implements DumbAware {
    private static final Key<Boolean> THE_FIRST_TIME = Key.create((String)"FirstFoldingPass");
    private Runnable myRunnable;
    private final Editor myEditor;
    private final PsiFile myFile;

    CodeFoldingPass(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/CodeFoldingPass", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/CodeFoldingPass", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/CodeFoldingPass", "<init>"));
        }
        super(project, editor.getDocument(), false);
        this.myEditor = editor;
        this.myFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/CodeFoldingPass", "doCollectInformation"));
        }
        boolean firstTime = CodeFoldingPass.isFirstTime(this.myFile, this.myEditor, THE_FIRST_TIME);
        Runnable runnable = CodeFoldingManager.getInstance(this.myProject).updateFoldRegionsAsync(this.myEditor, firstTime);
        CodeFoldingPass codeFoldingPass = this;
        synchronized (codeFoldingPass) {
            this.myRunnable = runnable;
        }
    }

    static boolean isFirstTime(PsiFile file, Editor editor, Key<Boolean> key) {
        return file.getUserData(key) == null || editor.getUserData(key) == null;
    }

    static void clearFirstTimeFlag(PsiFile file, Editor editor, Key<Boolean> key) {
        file.putUserData(key, (Object)Boolean.FALSE);
        editor.putUserData(key, (Object)Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doApplyInformationToEditor() {
        Runnable runnable;
        CodeFoldingPass codeFoldingPass = this;
        synchronized (codeFoldingPass) {
            runnable = this.myRunnable;
        }
        if (runnable != null) {
            try {
                runnable.run();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        if (InjectedLanguageManager.getInstance((Project)this.myFile.getProject()).getTopLevelFile((PsiElement)this.myFile) == this.myFile) {
            CodeFoldingPass.clearFirstTimeFlag(this.myFile, this.myEditor, THE_FIRST_TIME);
        }
    }
}

