/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.editor.HectorComponentPanelsProvider;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.psi.PsiFile;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PowerSaveHectorProvider
implements HectorComponentPanelsProvider {
    public HectorComponentPanel createConfigurable(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/PowerSaveHectorProvider", "createConfigurable"));
        }
        return new HectorComponentPanel(){
            private final JCheckBox myCheckBox = new JCheckBox("Power Save Mode");

            public JComponent createComponent() {
                return this.myCheckBox;
            }

            public boolean isModified() {
                return this.myCheckBox.isSelected() != PowerSaveMode.isEnabled();
            }

            public void apply() throws ConfigurationException {
                PowerSaveMode.setEnabled(this.myCheckBox.isSelected());
            }

            public void reset() {
                this.myCheckBox.setSelected(PowerSaveMode.isEnabled());
            }

            public void disposeUIResources() {
            }
        };
    }
}

