/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class JavaProblemHighlightFilter
extends ProblemHighlightFilter {
    public boolean shouldHighlight(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/JavaProblemHighlightFilter", "shouldHighlight"));
        }
        return psiFile.getFileType() != StdFileTypes.JAVA || !JavaProjectRootsUtil.isOutsideJavaSourceRoot(psiFile);
    }

    public boolean shouldProcessInBatch(@NotNull PsiFile psiFile) {
        VirtualFile virtualFile;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/JavaProblemHighlightFilter", "shouldProcessInBatch"));
        }
        boolean shouldHighlight = JavaProblemHighlightFilter.shouldHighlightFile((PsiFile)psiFile);
        if (shouldHighlight && psiFile.getFileType() == StdFileTypes.JAVA && (virtualFile = psiFile.getVirtualFile()) != null && ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex().isInLibrarySource(virtualFile)) {
            return false;
        }
        return shouldHighlight;
    }
}

