/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManagerImpl;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="DaemonCodeAnalyzerSettings", storages={@Storage(file="$APP_CONFIG$/editor.codeinsight.xml")})
public class DaemonCodeAnalyzerSettingsImpl
extends DaemonCodeAnalyzerSettings
implements PersistentStateComponent<Element>,
Cloneable,
ExportableComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings");
    @NonNls
    private static final String ROOT_TAG = "root";
    @NonNls
    private static final String PROFILE_ATT = "profile";
    private final InspectionProfileManagerImpl myManager;

    public DaemonCodeAnalyzerSettingsImpl(InspectionProfileManager manager) {
        this.myManager = (InspectionProfileManagerImpl)manager;
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((String)"editor.codeinsight")};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/DaemonCodeAnalyzerSettingsImpl", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = DaemonBundle.message((String)"error.highlighting.settings", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/DaemonCodeAnalyzerSettingsImpl", "getPresentableName"));
        }
        return string;
    }

    @Override
    public boolean isCodeHighlightingChanged(DaemonCodeAnalyzerSettings oldSettings) {
        try {
            Element rootNew = new Element(ROOT_TAG);
            this.writeExternal(rootNew);
            Element rootOld = new Element(ROOT_TAG);
            ((DaemonCodeAnalyzerSettingsImpl)oldSettings).writeExternal(rootOld);
            return !JDOMUtil.areElementsEqual((Element)rootOld, (Element)rootNew);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    public DaemonCodeAnalyzerSettingsImpl clone() {
        DaemonCodeAnalyzerSettingsImpl settings = new DaemonCodeAnalyzerSettingsImpl(this.myManager);
        settings.AUTOREPARSE_DELAY = this.AUTOREPARSE_DELAY;
        settings.SHOW_ADD_IMPORT_HINTS = this.SHOW_ADD_IMPORT_HINTS;
        settings.SHOW_METHOD_SEPARATORS = this.SHOW_METHOD_SEPARATORS;
        settings.NO_AUTO_IMPORT_PATTERN = this.NO_AUTO_IMPORT_PATTERN;
        settings.SHOW_SMALL_ICONS_IN_GUTTER = this.SHOW_SMALL_ICONS_IN_GUTTER;
        return settings;
    }

    public Element getState() {
        Element e = new Element("state");
        try {
            this.writeExternal(e);
        }
        catch (WriteExternalException ex) {
            LOG.error((Throwable)ex);
        }
        return e;
    }

    public void loadState(Element state) {
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    private void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.myManager.getConverter().storeEditorHighlightingProfile(element, new InspectionProfileImpl("EditorHighlightingSettings"));
        this.myManager.setRootProfile(element.getAttributeValue(PROFILE_ATT));
    }

    private void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        element.setAttribute(PROFILE_ATT, this.myManager.getRootProfile().getName());
    }
}

