/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.scope;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.Nullable;

public class CompletionElement {
    private final Object myElement;
    private final PsiSubstitutor mySubstitutor;

    public CompletionElement(Object element, PsiSubstitutor substitutor) {
        this.myElement = element;
        this.mySubstitutor = substitutor;
    }

    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    public Object getElement() {
        return this.myElement;
    }

    @Nullable
    Object getUniqueId() {
        if (this.myElement instanceof PsiClass) {
            return ((PsiClass)this.myElement).getQualifiedName();
        }
        if (this.myElement instanceof PsiPackage) {
            return ((PsiPackage)this.myElement).getQualifiedName();
        }
        if (this.myElement instanceof PsiMethod) {
            return ((PsiMethod)this.myElement).getSignature(this.mySubstitutor);
        }
        if (this.myElement instanceof PsiVariable) {
            return CompletionElement.getVariableUniqueId((PsiVariable)this.myElement);
        }
        return null;
    }

    public static String getVariableUniqueId(PsiVariable variable) {
        return "#" + variable.getName();
    }
}

