/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import org.jetbrains.annotations.NotNull;

public class RealPrefixMatchingWeigher
extends LookupElementWeigher {
    private final CompletionLocation myLocation;

    public RealPrefixMatchingWeigher(CompletionLocation location) {
        super("prefix", false, true);
        this.myLocation = location;
    }

    public Comparable weigh(@NotNull LookupElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/impl/RealPrefixMatchingWeigher", "weigh"));
        }
        return Integer.valueOf(RealPrefixMatchingWeigher.getBestMatchingDegree(element, CompletionServiceImpl.getItemMatcher(element, this.myLocation.getCompletionParameters().getLookup())));
    }

    public static int getBestMatchingDegree(LookupElement element, PrefixMatcher matcher) {
        int max = Integer.MIN_VALUE;
        for (String lookupString : element.getAllLookupStrings()) {
            max = Math.max(max, matcher.matchingDegree(lookupString));
        }
        return -max;
    }
}

