/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CamelHumpMatcher
extends PrefixMatcher {
    private final MinusculeMatcher myMatcher;
    private final MinusculeMatcher myCaseInsensitiveMatcher;
    private final boolean myCaseSensitive;
    private static boolean ourForceStartMatching;

    public CamelHumpMatcher(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/impl/CamelHumpMatcher", "<init>"));
        }
        this(prefix, true);
    }

    public CamelHumpMatcher(String prefix, boolean caseSensitive) {
        super(prefix);
        this.myCaseSensitive = caseSensitive;
        this.myMatcher = this.createMatcher(this.myCaseSensitive);
        this.myCaseInsensitiveMatcher = this.createMatcher(false);
    }

    public boolean isStartMatch(String name) {
        return this.myMatcher.isStartMatch(name);
    }

    public boolean isStartMatch(LookupElement element) {
        for (String s : element.getAllLookupStrings()) {
            FList ranges = this.myCaseInsensitiveMatcher.matchingFragments(s);
            if (ranges == null || !ranges.isEmpty() && CamelHumpMatcher.skipUnderscores(s) < ((TextRange)ranges.get(0)).getStartOffset()) continue;
            return true;
        }
        return false;
    }

    private static int skipUnderscores(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/impl/CamelHumpMatcher", "skipUnderscores"));
        }
        return CharArrayUtil.shiftForward((CharSequence)name, (int)0, (String)"_");
    }

    public boolean prefixMatches(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/impl/CamelHumpMatcher", "prefixMatches"));
        }
        return this.myMatcher.matches(name);
    }

    public boolean prefixMatches(@NotNull LookupElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/impl/CamelHumpMatcher", "prefixMatches"));
        }
        return this.prefixMatchersInternal(element, !element.isCaseSensitive());
    }

    private boolean prefixMatchersInternal(LookupElement element, boolean itemCaseInsensitive) {
        for (String name : element.getAllLookupStrings()) {
            if (itemCaseInsensitive && StringUtil.startsWithIgnoreCase((String)name, (String)this.myPrefix) || this.prefixMatches(name)) {
                return true;
            }
            if (!itemCaseInsensitive || 1 == CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE || !this.myCaseInsensitiveMatcher.matches(name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/impl/CamelHumpMatcher", "cloneWithPrefix"));
        }
        CamelHumpMatcher camelHumpMatcher = new CamelHumpMatcher(prefix, this.myCaseSensitive);
        if (camelHumpMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/impl/CamelHumpMatcher", "cloneWithPrefix"));
        }
        return camelHumpMatcher;
    }

    private MinusculeMatcher createMatcher(boolean caseSensitive) {
        String prefix = CamelHumpMatcher.applyMiddleMatching(this.myPrefix);
        if (!caseSensitive) {
            return NameUtil.buildMatcher((String)prefix, (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        }
        switch (CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE) {
            case 2: {
                return NameUtil.buildMatcher((String)prefix, (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
            }
            case 3: {
                return NameUtil.buildMatcher((String)prefix, (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.FIRST_LETTER);
            }
        }
        return NameUtil.buildMatcher((String)prefix, (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.ALL);
    }

    public static String applyMiddleMatching(String prefix) {
        if (Registry.is((String)"ide.completion.middle.matching") && !prefix.isEmpty() && !ourForceStartMatching) {
            return "*" + StringUtil.replace((String)prefix, (String)".", (String)". ").trim();
        }
        return prefix;
    }

    public String toString() {
        return this.myPrefix;
    }

    @Deprecated
    public static void forceStartMatching(Disposable parent) {
        ourForceStartMatching = true;
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                ourForceStartMatching = false;
            }
        });
    }

    public int matchingDegree(String string) {
        FList ranges = this.myCaseInsensitiveMatcher.matchingFragments(string);
        if (ranges != null && !ranges.isEmpty()) {
            int matchStart = ((TextRange)ranges.get(0)).getStartOffset();
            int underscoreEnd = CamelHumpMatcher.skipUnderscores(string);
            if (matchStart > 0 && matchStart <= underscoreEnd) {
                return this.myCaseInsensitiveMatcher.matchingDegree(string.substring(matchStart)) - 1;
            }
        }
        return this.myMatcher.matchingDegree(string);
    }
}

