/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class BetterPrefixMatcher
extends PrefixMatcher {
    private final PrefixMatcher myOriginal;
    private final int myMinMatchingDegree;

    public BetterPrefixMatcher(PrefixMatcher original, int minMatchingDegree) {
        super(original.getPrefix());
        this.myOriginal = original;
        this.myMinMatchingDegree = minMatchingDegree;
    }

    public static int getBestMatchingDegree(LinkedHashSet<CompletionResult> plainResults) {
        int bestMatchingDegree = Integer.MIN_VALUE;
        for (CompletionResult cr : plainResults) {
            bestMatchingDegree = Math.max(bestMatchingDegree, RealPrefixMatchingWeigher.getBestMatchingDegree(cr.getLookupElement(), cr.getPrefixMatcher()));
        }
        return bestMatchingDegree;
    }

    public boolean prefixMatches(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher", "prefixMatches"));
        }
        if (!this.myOriginal.prefixMatches(name) || !this.myOriginal.isStartMatch(name)) {
            return false;
        }
        return this.myOriginal.matchingDegree(name) >= this.myMinMatchingDegree;
    }

    public boolean isStartMatch(String name) {
        return this.myOriginal.isStartMatch(name);
    }

    public int matchingDegree(String string) {
        return this.myOriginal.matchingDegree(string);
    }

    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher", "cloneWithPrefix"));
        }
        BetterPrefixMatcher betterPrefixMatcher = new BetterPrefixMatcher(this.myOriginal.cloneWithPrefix(prefix), this.myMinMatchingDegree);
        if (betterPrefixMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher", "cloneWithPrefix"));
        }
        return betterPrefixMatcher;
    }
}

