/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.simple.RParenthTailType;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.java.PsiEmptyExpressionImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SmartCastProvider
extends CompletionProvider<CompletionParameters> {
    static final PsiElementPattern.Capture<PsiElement> INSIDE_TYPECAST_TYPE = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("(")).withParent(PsiTypeCastExpression.class));

    SmartCastProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/SmartCastProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/completion/SmartCastProvider", "addCompletions"));
        }
        for (ExpectedTypeInfo info : JavaSmartCompletionContributor.getExpectedTypes(parameters)) {
            PsiClassType boxedType;
            PsiType castedType;
            PsiElement originalPosition = parameters.getOriginalPosition();
            boolean overwrite = INSIDE_TYPECAST_TYPE.accepts((Object)originalPosition);
            PsiType type = info.getDefaultType();
            if (type instanceof PsiWildcardType) {
                type = ((PsiWildcardType)type).getBound();
            }
            if (type == null || type == PsiType.VOID) continue;
            result.addElement(SmartCastProvider.createSmartCastElement(parameters, overwrite, type));
            if (!(type instanceof PsiPrimitiveType) || (castedType = SmartCastProvider.getCastedExpressionType(originalPosition)) == null || castedType instanceof PsiPrimitiveType || (boxedType = ((PsiPrimitiveType)type).getBoxedType(originalPosition)) == null) continue;
            result.addElement(SmartCastProvider.createSmartCastElement(parameters, overwrite, (PsiType)boxedType));
        }
    }

    @Nullable
    private static PsiType getCastedExpressionType(PsiElement originalPosition) {
        PsiTypeCastExpression cast;
        if (INSIDE_TYPECAST_TYPE.accepts((Object)originalPosition) && (cast = (PsiTypeCastExpression)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, PsiTypeCastExpression.class)) != null) {
            PsiExpression operand = cast.getOperand();
            return operand == null ? null : operand.getType();
        }
        PsiParenthesizedExpression parens = (PsiParenthesizedExpression)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, PsiParenthesizedExpression.class, (boolean)true, (Class[])new Class[]{PsiStatement.class});
        if (parens != null) {
            PsiElement next;
            PsiExpression rightSide = parens.getExpression();
            if (rightSide != null) {
                return rightSide.getType();
            }
            for (next = parens.getNextSibling(); next != null && (next instanceof PsiEmptyExpressionImpl || next instanceof PsiErrorElement || next instanceof PsiWhiteSpace); next = next.getNextSibling()) {
            }
            if (next instanceof PsiExpression) {
                return ((PsiExpression)next).getType();
            }
            return null;
        }
        return null;
    }

    private static LookupElement createSmartCastElement(CompletionParameters parameters, final boolean overwrite, PsiType type) {
        return AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE.applyPolicy((LookupElement)new LookupElementDecorator<PsiTypeLookupItem>(PsiTypeLookupItem.createLookupItem(type, parameters.getPosition())){

            public void handleInsert(InsertionContext context) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.smarttype.casting");
                Editor editor = context.getEditor();
                Document document = editor.getDocument();
                if (overwrite) {
                    document.deleteString(context.getSelectionEndOffset(), context.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET));
                }
                CommonCodeStyleSettings csSettings = context.getCodeStyleSettings();
                int oldTail = context.getTailOffset();
                context.setTailOffset(RParenthTailType.addRParenth(editor, oldTail, csSettings.SPACE_WITHIN_CAST_PARENTHESES));
                ((PsiTypeLookupItem)this.getDelegate()).handleInsert(CompletionUtil.newContext(context, this.getDelegate(), context.getStartOffset(), oldTail));
                PostprocessReformattingAspect.getInstance(context.getProject()).doPostponedFormatting();
                if (csSettings.SPACE_AFTER_TYPE_CAST) {
                    context.setTailOffset(TailType.insertChar((Editor)editor, (int)context.getTailOffset(), (char)' '));
                }
                editor.getCaretModel().moveToOffset(context.getTailOffset());
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        });
    }
}

