/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class LambdaCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        ExpectedTypeInfo[] expectedTypes;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/LambdaCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/completion/LambdaCompletionProvider", "addCompletions"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)parameters.getOriginalFile())) {
            return;
        }
        for (ExpectedTypeInfo expectedType : expectedTypes = JavaSmartCompletionContributor.getExpectedTypes(parameters)) {
            JVMElementFactory jvmElementFactory;
            PsiType functionalInterfaceType;
            PsiMethod method;
            PsiType defaultType = expectedType.getDefaultType();
            if (!LambdaUtil.isFunctionalType((PsiType)defaultType) || (method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)(functionalInterfaceType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(defaultType)))) == null) continue;
            Object[] params = method.getParameterList().getParameters();
            Project project = method.getProject();
            PsiElement originalPosition = parameters.getOriginalPosition();
            JVMElementFactory jVMElementFactory = jvmElementFactory = originalPosition != null ? JVMElementFactories.getFactory((Language)originalPosition.getLanguage(), (Project)project) : null;
            if (jvmElementFactory != null) {
                PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)method, (PsiClassType.ClassResolveResult)PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType));
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                params = GenerateMembersUtil.overriddenParameters((PsiParameter[])params, jvmElementFactory, codeStyleManager, substitutor, originalPosition);
            }
            String paramsString = params.length == 1 ? params[0].getName() : "(" + StringUtil.join((Object[])params, (Function)new Function<PsiParameter, String>(){

                public String fun(PsiParameter parameter) {
                    return parameter.getName();
                }
            }, (String)",") + ")";
            LookupElementBuilder builder = LookupElementBuilder.create((String)paramsString).withPresentableText(paramsString + " -> {}").withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                public void handleInsert(InsertionContext context, LookupElement item) {
                    Editor editor = context.getEditor();
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" -> ");
                }
            });
            result.addElement(builder.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE));
        }
    }
}

