/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.StaticMemberProcessor;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaStaticMemberProcessor
extends StaticMemberProcessor {
    private final PsiElement myOriginalPosition;

    public JavaStaticMemberProcessor(CompletionParameters parameters) {
        super(parameters.getPosition());
        PsiImportList importList;
        this.myOriginalPosition = parameters.getOriginalPosition();
        PsiFile file = parameters.getPosition().getContainingFile();
        if (file instanceof PsiJavaFile && (importList = ((PsiJavaFile)file).getImportList()) != null) {
            for (PsiImportStaticStatement statement : importList.getImportStaticStatements()) {
                this.importMembersOf(statement.resolveTargetClass());
            }
        }
    }

    @Override
    @NotNull
    protected LookupElement createLookupElement(@NotNull PsiMember member, @NotNull PsiClass containingClass, boolean shouldImport) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/JavaStaticMemberProcessor", "createLookupElement"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/completion/JavaStaticMemberProcessor", "createLookupElement"));
        }
        shouldImport |= this.myOriginalPosition != null && PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)this.myOriginalPosition, (boolean)false);
        if (member instanceof PsiMethod) {
            LookupElement lookupElement = AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy((LookupElement)new GlobalMethodCallElement((PsiMethod)member, shouldImport, false));
            if (lookupElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaStaticMemberProcessor", "createLookupElement"));
            }
            return lookupElement;
        }
        LookupElement lookupElement = AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy((LookupElement)new VariableLookupItem((PsiField)member, shouldImport){

            @Override
            public void handleInsert(InsertionContext context) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.global.member.name");
                super.handleInsert(context);
            }
        });
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaStaticMemberProcessor", "createLookupElement"));
        }
        return lookupElement;
    }

    @Override
    protected LookupElement createLookupElement(@NotNull List<PsiMethod> overloads, @NotNull PsiClass containingClass, boolean shouldImport) {
        if (overloads == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/completion/JavaStaticMemberProcessor", "createLookupElement"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/completion/JavaStaticMemberProcessor", "createLookupElement"));
        }
        GlobalMethodCallElement element = new GlobalMethodCallElement(overloads.get(0), shouldImport |= this.myOriginalPosition != null && PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)this.myOriginalPosition, (boolean)false), true);
        element.putUserData(JavaCompletionUtil.ALL_METHODS_ATTRIBUTE, overloads);
        return element;
    }

    private static class GlobalMethodCallElement
    extends JavaMethodCallElement {
        public GlobalMethodCallElement(PsiMethod member, boolean shouldImport, boolean mergedOverloads) {
            super(member, shouldImport, mergedOverloads);
        }

        @Override
        public void handleInsert(InsertionContext context) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.global.member.name");
            super.handleInsert(context);
        }
    }
}

