/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.Nullable;

public class ExcludeFromCompletionLookupActionProvider
implements LookupActionProvider {
    @Override
    public void fillActions(LookupElement element, Lookup lookup, Consumer<LookupElementAction> consumer) {
        PsiField field;
        Object o = element.getObject();
        if (o instanceof PsiClassObjectAccessExpression) {
            o = PsiUtil.resolveClassInType((PsiType)((PsiClassObjectAccessExpression)o).getOperand().getType());
        }
        if (o instanceof PsiClass) {
            PsiClass clazz = (PsiClass)o;
            ExcludeFromCompletionLookupActionProvider.addExcludes(consumer, (PsiMember)clazz, clazz.getQualifiedName());
        } else if (o instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)o;
            if (method.hasModifierProperty("static")) {
                ExcludeFromCompletionLookupActionProvider.addExcludes(consumer, (PsiMember)method, PsiUtil.getMemberQualifiedName((PsiMember)method));
            }
        } else if (o instanceof PsiField && (field = (PsiField)o).hasModifierProperty("static")) {
            ExcludeFromCompletionLookupActionProvider.addExcludes(consumer, (PsiMember)field, PsiUtil.getMemberQualifiedName((PsiMember)field));
        }
    }

    private static void addExcludes(Consumer<LookupElementAction> consumer, PsiMember element, @Nullable String qname) {
        if (qname == null) {
            return;
        }
        Project project = element.getProject();
        for (String s : AddImportAction.getAllExcludableStrings(qname)) {
            consumer.consume((Object)new ExcludeFromCompletionAction(project, s));
        }
    }

    private static class ExcludeFromCompletionAction
    extends LookupElementAction {
        private final Project myProject;
        private final String myToExclude;

        public ExcludeFromCompletionAction(Project project, String s) {
            super(null, "Exclude '" + s + "' from completion");
            this.myProject = project;
            this.myToExclude = s;
        }

        @Override
        public LookupElementAction.Result performLookupAction() {
            AddImportAction.excludeFromImport(this.myProject, this.myToExclude);
            return LookupElementAction.Result.HIDE_LOOKUP;
        }
    }
}

