/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.completion.CompletionBundle;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstructorInsertHandler
implements InsertHandler<LookupElementDecorator<LookupItem>> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.ConstructorInsertHandler");
    public static final ConstructorInsertHandler SMART_INSTANCE = new ConstructorInsertHandler(true);
    public static final ConstructorInsertHandler BASIC_INSTANCE = new ConstructorInsertHandler(false);
    static final OffsetKey PARAM_LIST_START = OffsetKey.create((String)"paramListStart");
    static final OffsetKey PARAM_LIST_END = OffsetKey.create((String)"paramListEnd");
    private final boolean mySmart;

    private ConstructorInsertHandler(boolean smart) {
        this.mySmart = smart;
    }

    public void handleInsert(InsertionContext context, LookupElementDecorator<LookupItem> item) {
        LookupItem delegate = (LookupItem)item.getDelegate();
        PsiClass psiClass = (PsiClass)item.getObject();
        boolean isAbstract = psiClass.hasModifierProperty("abstract");
        if ('\t' == context.getCompletionChar()) {
            int plStart = context.getOffset(PARAM_LIST_START);
            int plEnd = context.getOffset(PARAM_LIST_END);
            if (plStart >= 0 && plEnd >= 0) {
                context.getDocument().deleteString(plStart, plEnd);
            }
        }
        context.commitDocument();
        OffsetKey insideRef = context.trackOffset(context.getTailOffset(), false);
        PsiElement position = SmartCompletionDecorator.getPosition(context, (LookupElement)delegate);
        PsiExpression enclosing = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)position, PsiExpression.class, (boolean)true);
        PsiAnonymousClass anonymousClass = (PsiAnonymousClass)PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnonymousClass.class);
        boolean inAnonymous = anonymousClass != null && anonymousClass.getParent() == enclosing;
        boolean fillTypeArgs = false;
        if (delegate instanceof PsiTypeLookupItem) {
            PsiReferenceParameterList parameterList;
            PsiJavaCodeReferenceElement ref;
            boolean bl = fillTypeArgs = !ConstructorInsertHandler.isRawTypeExpected(context, (PsiTypeLookupItem)delegate) && psiClass.getTypeParameters().length > 0 && ((PsiTypeLookupItem)delegate).calcGenerics(position, context).isEmpty() && context.getCompletionChar() != '(';
            if (context.getDocument().getTextLength() > context.getTailOffset() && context.getDocument().getCharsSequence().charAt(context.getTailOffset()) == '<' && (ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getTailOffset(), PsiJavaCodeReferenceElement.class, (boolean)false)) != null && (parameterList = ref.getParameterList()) != null && context.getTailOffset() == parameterList.getTextRange().getStartOffset()) {
                context.getDocument().deleteString(parameterList.getTextRange().getStartOffset(), parameterList.getTextRange().getEndOffset());
                context.commitDocument();
            }
            delegate.handleInsert(context);
            PostprocessReformattingAspect.getInstance(context.getProject()).doPostponedFormatting(context.getFile().getViewProvider());
        }
        if (item.getDelegate() instanceof JavaPsiClassReferenceElement) {
            PsiTypeLookupItem.addImportForItem(context, psiClass);
        }
        ConstructorInsertHandler.insertParentheses(context, delegate, psiClass, !inAnonymous && isAbstract);
        if (inAnonymous) {
            return;
        }
        if (this.mySmart) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.smarttype.afternew");
        }
        if (isAbstract) {
            PostprocessReformattingAspect.getInstance(context.getProject()).doPostponedFormatting(context.getFile().getViewProvider());
            Editor editor = context.getEditor();
            int offset = context.getTailOffset();
            editor.getDocument().insertString(offset, (CharSequence)" {}");
            editor.getCaretModel().moveToOffset(offset + 2);
            if (fillTypeArgs && JavaCompletionUtil.promptTypeArgs(context, context.getOffset(insideRef))) {
                return;
            }
            context.setLaterRunnable(ConstructorInsertHandler.generateAnonymousBody(editor, context.getFile()));
        } else {
            PsiJavaCodeReferenceElement classReference;
            PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
            PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiNewExpression.class, (boolean)false);
            if (newExpression != null && (classReference = newExpression.getClassOrAnonymousClassReference()) != null) {
                CodeStyleManager.getInstance((Project)context.getProject()).reformat((PsiElement)classReference);
            }
            if (this.mySmart) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.smarttype.afternew");
            }
            if (fillTypeArgs && JavaCompletionUtil.promptTypeArgs(context, context.getOffset(insideRef))) {
                return;
            }
        }
    }

    static boolean isRawTypeExpected(InsertionContext context, PsiTypeLookupItem delegate) {
        PsiNewExpression newExpr = (PsiNewExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiNewExpression.class, (boolean)false);
        if (newExpr != null) {
            for (ExpectedTypeInfo info : ExpectedTypesProvider.getExpectedTypes((PsiExpression)newExpr, true)) {
                PsiType expected = info.getDefaultType();
                if (!expected.isAssignableFrom(delegate.getPsiType()) || !(expected instanceof PsiClassType) || !((PsiClassType)expected).isRaw()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean insertParentheses(InsertionContext context, LookupItem delegate, PsiClass psiClass, boolean forAnonymous) {
        if (context.getCompletionChar() == '[') {
            return false;
        }
        PsiElement place = context.getFile().findElementAt(context.getStartOffset());
        assert (place != null);
        boolean hasParams = ConstructorInsertHandler.hasConstructorParameters(psiClass, place);
        JavaCompletionUtil.insertParentheses(context, (LookupElement)delegate, false, hasParams, forAnonymous);
        return true;
    }

    static boolean hasConstructorParameters(PsiClass psiClass, @NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/completion/ConstructorInsertHandler", "hasConstructorParameters"));
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)place.getProject()).getResolveHelper();
        boolean hasParams = false;
        for (PsiMethod constructor : psiClass.getConstructors()) {
            if (!resolveHelper.isAccessible((PsiMember)constructor, place, null) || constructor.getParameterList().getParametersCount() <= 0) continue;
            hasParams = true;
            break;
        }
        return hasParams;
    }

    @Nullable
    private static Runnable generateAnonymousBody(Editor editor, PsiFile file) {
        Project project = file.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiAnonymousClass)) {
            return null;
        }
        return ConstructorInsertHandler.genAnonymousBodyFor((PsiAnonymousClass)parent, editor, file, project);
    }

    public static Runnable genAnonymousBodyFor(PsiAnonymousClass parent, final Editor editor, final PsiFile file, final Project project) {
        try {
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)parent);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        int offset = parent.getTextRange().getEndOffset() - 1;
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
        return new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                        final PsiAnonymousClass aClass = (PsiAnonymousClass)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset(), PsiAnonymousClass.class, (boolean)false);
                        if (aClass == null) {
                            return;
                        }
                        final Collection<CandidateInfo> candidatesToImplement = OverrideImplementUtil.getMethodsToOverrideImplement((PsiClass)aClass, true);
                        Iterator<CandidateInfo> iterator = candidatesToImplement.iterator();
                        while (iterator.hasNext()) {
                            CandidateInfo candidate = iterator.next();
                            PsiElement element = candidate.getElement();
                            if (!(element instanceof PsiMethod) || !((PsiMethod)element).hasModifierProperty("default")) continue;
                            iterator.remove();
                        }
                        boolean invokeOverride = candidatesToImplement.isEmpty();
                        if (invokeOverride) {
                            OverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, (PsiClass)aClass, false);
                        } else {
                            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        List<PsiMethod> methods = OverrideImplementUtil.overrideOrImplementMethodCandidates((PsiClass)aClass, candidatesToImplement, false);
                                        List<PsiGenerationInfo<PsiMethod>> prototypes = OverrideImplementUtil.convert2GenerationInfos(methods);
                                        List<PsiGenerationInfo<PsiMethod>> resultMembers = GenerateMembersUtil.insertMembersBeforeAnchor((PsiClass)aClass, null, prototypes);
                                        resultMembers.get(0).positionCaret(editor, true);
                                    }
                                    catch (IncorrectOperationException ioe) {
                                        LOG.error((Throwable)ioe);
                                    }
                                }
                            });
                        }
                    }
                }, CompletionBundle.message("completion.smart.type.generate.anonymous.body", new Object[0]), null, UndoConfirmationPolicy.DEFAULT, editor.getDocument());
            }
        };
    }
}

