/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;

public class OptimizeImportsProcessor
extends AbstractLayoutCodeProcessor {
    private static final String PROGRESS_TEXT = CodeInsightBundle.message((String)"progress.text.optimizing.imports", (Object[])new Object[0]);
    public static final String COMMAND_NAME = CodeInsightBundle.message((String)"process.optimize.imports", (Object[])new Object[0]);

    public OptimizeImportsProcessor(Project project) {
        super(project, COMMAND_NAME, PROGRESS_TEXT, false);
    }

    public OptimizeImportsProcessor(Project project, Module module) {
        super(project, module, COMMAND_NAME, PROGRESS_TEXT, false);
    }

    public OptimizeImportsProcessor(Project project, PsiDirectory directory, boolean includeSubdirs) {
        super(project, directory, includeSubdirs, PROGRESS_TEXT, COMMAND_NAME, false);
    }

    public OptimizeImportsProcessor(Project project, PsiFile file) {
        super(project, file, PROGRESS_TEXT, COMMAND_NAME, false);
    }

    public OptimizeImportsProcessor(Project project, PsiFile[] files, Runnable postRunnable) {
        this(project, files, COMMAND_NAME, postRunnable);
    }

    public OptimizeImportsProcessor(Project project, PsiFile[] files, String commandName, Runnable postRunnable) {
        super(project, files, PROGRESS_TEXT, commandName, postRunnable, false);
    }

    public OptimizeImportsProcessor(AbstractLayoutCodeProcessor processor) {
        super(processor, COMMAND_NAME, PROGRESS_TEXT);
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file, boolean processChangedTextOnly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/OptimizeImportsProcessor", "prepareTask"));
        }
        Set optimizers = LanguageImportStatements.INSTANCE.forFile(file);
        final ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        List files = file.getViewProvider().getAllFiles();
        for (ImportOptimizer optimizer : optimizers) {
            for (PsiFile psiFile : files) {
                if (!optimizer.supports(psiFile)) continue;
                runnables.add(optimizer.processFile(psiFile));
            }
        }
        Runnable runnable = runnables.isEmpty() ? EmptyRunnable.getInstance() : new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CodeStyleManagerImpl.setSequentialProcessingAllowed(false);
                try {
                    for (Runnable runnable : runnables) {
                        runnable.run();
                    }
                }
                finally {
                    CodeStyleManagerImpl.setSequentialProcessingAllowed(true);
                }
            }
        };
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(runnable, true);
        if (futureTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/OptimizeImportsProcessor", "prepareTask"));
        }
        return futureTask;
    }
}

