/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class LayoutCodeSettingsStorage {
    private LayoutCodeSettingsStorage() {
    }

    public static void saveRearrangeEntriesOptionFor(@NotNull Project project, @NotNull Language language, boolean value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/LayoutCodeSettingsStorage", "saveRearrangeEntriesOptionFor"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/actions/LayoutCodeSettingsStorage", "saveRearrangeEntriesOptionFor"));
        }
        String key = LayoutCodeSettingsStorage.getRearrangeEntriesKeyForLanguage(language);
        PropertiesComponent.getInstance((Project)project).setValue(key, Boolean.toString(value));
    }

    public static void saveRearrangeEntriesOptionFor(@NotNull Project project, boolean value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/LayoutCodeSettingsStorage", "saveRearrangeEntriesOptionFor"));
        }
        PropertiesComponent.getInstance((Project)project).setValue("LayoutCode.rearrangeEntries", Boolean.toString(value));
    }

    public static boolean getLastSavedRearrangeEntriesCbStateFor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/LayoutCodeSettingsStorage", "getLastSavedRearrangeEntriesCbStateFor"));
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean("LayoutCode.rearrangeEntries", false);
    }

    public static boolean getLastSavedRearrangeEntriesCbStateFor(@NotNull Project project, @NotNull Language language) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/LayoutCodeSettingsStorage", "getLastSavedRearrangeEntriesCbStateFor"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/actions/LayoutCodeSettingsStorage", "getLastSavedRearrangeEntriesCbStateFor"));
        }
        String key = LayoutCodeSettingsStorage.getRearrangeEntriesKeyForLanguage(language);
        return PropertiesComponent.getInstance((Project)project).getBoolean(key, false);
    }

    private static String getRearrangeEntriesKeyForLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/LayoutCodeSettingsStorage", "getRearrangeEntriesKeyForLanguage"));
        }
        return "LayoutCode.rearrangeEntries" + language.getDisplayName();
    }
}

