/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.codeInsight.actions.LayoutCodeOptions;
import com.intellij.codeInsight.actions.LayoutCodeSettingsStorage;
import com.intellij.codeInsight.actions.ReformatCodeAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutCodeDialog
extends DialogWrapper
implements LayoutCodeOptions {
    @NotNull
    private final Project myProject;
    @Nullable
    private final PsiFile myFile;
    @Nullable
    private final PsiDirectory myDirectory;
    private final Boolean myTextSelected;
    private JRadioButton myRbFile;
    private JRadioButton myRbSelectedText;
    private JRadioButton myRbDirectory;
    private JCheckBox myCbIncludeSubdirs;
    private JCheckBox myCbOptimizeImports;
    private JCheckBox myCbArrangeEntries;
    private JCheckBox myCbOnlyVcsChangedRegions;
    private JCheckBox myDoNotAskMeCheckBox;
    private final String myHelpId;
    @Nullable
    private CommonCodeStyleSettings myCommonSettings;
    private boolean myRearrangeAlwaysEnabled;

    public LayoutCodeDialog(@NotNull Project project, @NotNull String title, @Nullable PsiFile file, @Nullable PsiDirectory directory, Boolean isTextSelected, String helpId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/LayoutCodeDialog", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/actions/LayoutCodeDialog", "<init>"));
        }
        super(project, true);
        this.myFile = file;
        this.myProject = project;
        this.myDirectory = directory;
        this.myTextSelected = isTextSelected;
        if (this.myFile != null) {
            this.myCommonSettings = CodeStyleSettingsManager.getSettings((Project)this.myProject).getCommonSettings(this.myFile.getLanguage());
        }
        this.myRearrangeAlwaysEnabled = this.myCommonSettings != null && this.myCommonSettings.isForceArrangeMenuAvailable() && this.myCommonSettings.FORCE_REARRANGE_MODE == CommonCodeStyleSettings.REARRANGE_ALWAYS;
        this.setOKButtonText(CodeInsightBundle.message((String)"reformat.code.accept.button.text", (Object[])new Object[0]));
        this.setTitle(title);
        this.init();
        this.myHelpId = helpId;
    }

    protected void init() {
        super.init();
        if (this.myTextSelected == Boolean.TRUE) {
            this.myRbSelectedText.setSelected(true);
        } else if (this.myFile != null) {
            this.myRbFile.setSelected(true);
        } else {
            this.myRbDirectory.setSelected(true);
        }
        this.myCbIncludeSubdirs.setSelected(true);
        this.myCbOptimizeImports.setSelected(PropertiesComponent.getInstance().getBoolean("LayoutCode.optimizeImports", false));
        this.myCbArrangeEntries.setSelected(this.myRearrangeAlwaysEnabled || ReformatCodeAction.getLastSavedRearrangeCbState(this.myProject, this.myFile));
        this.myCbOnlyVcsChangedRegions.setSelected(PropertiesComponent.getInstance().getBoolean("LayoutCode.processChangedText", false));
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LayoutCodeDialog.this.updateState();
            }
        };
        this.myRbFile.addItemListener(listener);
        this.myRbSelectedText.addItemListener(listener);
        this.myRbDirectory.addItemListener(listener);
        this.myCbIncludeSubdirs.addItemListener(listener);
        this.updateState();
    }

    private void updateState() {
        this.myCbIncludeSubdirs.setEnabled(this.myRbDirectory.isSelected());
        this.myCbOptimizeImports.setEnabled(!this.myRbSelectedText.isSelected() && (this.myFile == null || !LanguageImportStatements.INSTANCE.forFile(this.myFile).isEmpty() || !this.myRbFile.isSelected()));
        this.myCbArrangeEntries.setEnabled(this.isProcessDirectory() || this.myFile != null && Rearranger.EXTENSION.forLanguage(this.myFile.getLanguage()) != null && !this.myRearrangeAlwaysEnabled);
        if (this.myRearrangeAlwaysEnabled && !this.myCbArrangeEntries.isEnabled()) {
            this.myCbArrangeEntries.setSelected(true);
        }
        this.myCbOnlyVcsChangedRegions.setEnabled(this.canTargetVcsRegions());
        this.myDoNotAskMeCheckBox.setEnabled(!this.myRbDirectory.isSelected());
        this.myRbDirectory.setEnabled(!this.myDoNotAskMeCheckBox.isSelected());
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(4, 8, 8, 0));
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 3;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.insets = new Insets(0, 0, 0, 0);
        this.myRbFile = new JRadioButton(CodeInsightBundle.message((String)"process.scope.file", (Object[])new Object[]{this.myFile != null ? "'" + this.myFile.getVirtualFile().getPresentableUrl() + "'" : ""}));
        panel.add((Component)this.myRbFile, gbConstraints);
        this.myRbSelectedText = new JRadioButton(CodeInsightBundle.message((String)"reformat.option.selected.text", (Object[])new Object[0]));
        if (this.myTextSelected != null) {
            ++gbConstraints.gridy;
            gbConstraints.insets = new Insets(0, 0, 0, 0);
            panel.add((Component)this.myRbSelectedText, gbConstraints);
        }
        this.myRbDirectory = new JRadioButton();
        this.myCbIncludeSubdirs = new JCheckBox(CodeInsightBundle.message((String)"reformat.option.include.subdirectories", (Object[])new Object[0]));
        if (this.myDirectory != null) {
            this.myRbDirectory.setText(CodeInsightBundle.message((String)"reformat.option.all.files.in.directory", (Object[])new Object[]{this.myDirectory.getVirtualFile().getPresentableUrl()}));
            ++gbConstraints.gridy;
            gbConstraints.insets = new Insets(0, 0, 0, 0);
            panel.add((Component)this.myRbDirectory, gbConstraints);
            if (this.myDirectory.getSubdirectories().length > 0) {
                ++gbConstraints.gridy;
                gbConstraints.insets = new Insets(0, 20, 0, 0);
                panel.add((Component)this.myCbIncludeSubdirs, gbConstraints);
            }
        }
        this.myCbOptimizeImports = new JCheckBox(CodeInsightBundle.message((String)"reformat.option.optimize.imports", (Object[])new Object[0]));
        if (this.myTextSelected != null && LanguageImportStatements.INSTANCE.hasAnyExtensions()) {
            ++gbConstraints.gridy;
            gbConstraints.insets = new Insets(0, 0, 0, 0);
            panel.add((Component)this.myCbOptimizeImports, gbConstraints);
        }
        this.myCbArrangeEntries = new JCheckBox(CodeInsightBundle.message((String)"reformat.option.rearrange.entries", (Object[])new Object[0]));
        if (this.myDirectory != null || this.myFile != null && Rearranger.EXTENSION.forLanguage(this.myFile.getLanguage()) != null) {
            ++gbConstraints.gridy;
            gbConstraints.insets = new Insets(0, 0, 0, 0);
            panel.add((Component)this.myCbArrangeEntries, gbConstraints);
        }
        this.myCbOnlyVcsChangedRegions = new JCheckBox(CodeInsightBundle.message((String)"reformat.option.vcs.changed.region", (Object[])new Object[0]));
        ++gbConstraints.gridy;
        panel.add((Component)this.myCbOnlyVcsChangedRegions, gbConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myRbFile);
        buttonGroup.add(this.myRbSelectedText);
        buttonGroup.add(this.myRbDirectory);
        this.myRbFile.setEnabled(this.myFile != null);
        this.myRbSelectedText.setEnabled(this.myTextSelected == Boolean.TRUE);
        return panel;
    }

    protected JComponent createSouthPanel() {
        JComponent southPanel = super.createSouthPanel();
        this.myDoNotAskMeCheckBox = new JCheckBox(CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]));
        this.myDoNotAskMeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutCodeDialog.this.updateState();
            }
        });
        return DialogWrapper.addDoNotShowCheckBox((JComponent)southPanel, (JCheckBox)this.myDoNotAskMeCheckBox);
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/LayoutCodeDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myHelpId);
    }

    public boolean isProcessSelectedText() {
        return this.myRbSelectedText.isSelected();
    }

    @Override
    public boolean isProcessWholeFile() {
        return this.myRbFile.isSelected();
    }

    @Override
    public boolean isProcessDirectory() {
        return this.myRbDirectory.isSelected();
    }

    @Override
    public boolean isIncludeSubdirectories() {
        return this.myCbIncludeSubdirs.isSelected();
    }

    @Override
    public boolean isOptimizeImports() {
        return this.myCbOptimizeImports.isSelected();
    }

    @Override
    public boolean isRearrangeEntries() {
        return this.myCbArrangeEntries.isSelected();
    }

    @Override
    public boolean isProcessOnlyChangedText() {
        return this.myCbOnlyVcsChangedRegions.isEnabled() && this.myCbOnlyVcsChangedRegions.isSelected();
    }

    public boolean isDoNotAskMe() {
        if (this.myDoNotAskMeCheckBox.isEnabled()) {
            return this.myDoNotAskMeCheckBox.isSelected();
        }
        return !EditorSettingsExternalizable.getInstance().getOptions().SHOW_REFORMAT_DIALOG;
    }

    protected void doOKAction() {
        super.doOKAction();
        PropertiesComponent.getInstance().setValue("LayoutCode.optimizeImports", Boolean.toString(this.myCbOptimizeImports.isSelected()));
        PropertiesComponent.getInstance().setValue("LayoutCode.processChangedText", Boolean.toString(this.myCbOnlyVcsChangedRegions.isSelected()));
        this.saveRearrangeCbState(this.myCbArrangeEntries.isSelected());
    }

    private void saveRearrangeCbState(boolean isSelected) {
        if (this.myFile != null) {
            LayoutCodeSettingsStorage.saveRearrangeEntriesOptionFor(this.myProject, this.myFile.getLanguage(), isSelected);
        } else {
            LayoutCodeSettingsStorage.saveRearrangeEntriesOptionFor(this.myProject, isSelected);
        }
    }

    private boolean canTargetVcsRegions() {
        if (this.isProcessSelectedText()) {
            return false;
        }
        if (this.isProcessWholeFile()) {
            return this.myFile != null && FormatChangedTextUtil.hasChanges(this.myFile);
        }
        if (this.isProcessDirectory()) {
            if (this.myDirectory == null) {
                return false;
            }
            return FormatChangedTextUtil.hasChanges(this.myDirectory);
        }
        return false;
    }
}

