/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLayoutCodeProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor");
    protected final Project myProject;
    private final Module myModule;
    private PsiDirectory myDirectory;
    private PsiFile myFile;
    private List<PsiFile> myFiles;
    private boolean myIncludeSubdirs;
    private final String myProgressText;
    private final String myCommandName;
    private final Runnable myPostRunnable;
    private final boolean myProcessChangedTextOnly;
    protected AbstractLayoutCodeProcessor myPreviousCodeProcessor;

    protected AbstractLayoutCodeProcessor(Project project, String commandName, String progressText, boolean processChangedTextOnly) {
        this(project, (Module)null, commandName, progressText, processChangedTextOnly);
    }

    protected AbstractLayoutCodeProcessor(@NotNull AbstractLayoutCodeProcessor previous, @NotNull String commandName, @NotNull String progressText) {
        if (previous == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "<init>"));
        }
        if (commandName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "<init>"));
        }
        if (progressText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "<init>"));
        }
        this.myProject = previous.myProject;
        this.myModule = previous.myModule;
        this.myDirectory = previous.myDirectory;
        this.myFile = previous.myFile;
        this.myFiles = previous.myFiles;
        this.myIncludeSubdirs = previous.myIncludeSubdirs;
        this.myProcessChangedTextOnly = previous.myProcessChangedTextOnly;
        this.myPostRunnable = null;
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPreviousCodeProcessor = previous;
    }

    protected AbstractLayoutCodeProcessor(Project project, @Nullable Module module, String commandName, String progressText, boolean processChangedTextOnly) {
        this.myProject = project;
        this.myModule = module;
        this.myDirectory = null;
        this.myIncludeSubdirs = true;
        this.myCommandName = commandName;
        this.myProgressText = progressText;
        this.myPostRunnable = null;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    protected AbstractLayoutCodeProcessor(Project project, PsiDirectory directory, boolean includeSubdirs, String progressText, String commandName, boolean processChangedTextOnly) {
        this.myProject = project;
        this.myModule = null;
        this.myDirectory = directory;
        this.myIncludeSubdirs = includeSubdirs;
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPostRunnable = null;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    protected AbstractLayoutCodeProcessor(Project project, PsiFile file, String progressText, String commandName, boolean processChangedTextOnly) {
        this.myProject = project;
        this.myModule = null;
        this.myFile = file;
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPostRunnable = null;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    protected AbstractLayoutCodeProcessor(Project project, PsiFile[] files, String progressText, String commandName, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        this.myProject = project;
        this.myModule = null;
        this.myFiles = AbstractLayoutCodeProcessor.filterFilesTo(files, new ArrayList<PsiFile>());
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPostRunnable = postRunnable;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    private static List<PsiFile> filterFilesTo(PsiFile[] files, List<PsiFile> list) {
        GeneratedSourcesFilter[] filters = (GeneratedSourcesFilter[])GeneratedSourcesFilter.EP_NAME.getExtensions();
        for (PsiFile file : files) {
            if (!AbstractLayoutCodeProcessor.canBeFormatted(file, filters)) continue;
            list.add(file);
        }
        return list;
    }

    @Nullable
    private FutureTask<Boolean> getPreviousProcessorTask(@NotNull PsiFile file, boolean processChangedTextOnly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "getPreviousProcessorTask"));
        }
        return this.myPreviousCodeProcessor != null ? this.myPreviousCodeProcessor.preprocessFile(file, processChangedTextOnly) : null;
    }

    @NotNull
    protected abstract FutureTask<Boolean> prepareTask(@NotNull PsiFile var1, boolean var2) throws IncorrectOperationException;

    public FutureTask<Boolean> preprocessFile(@NotNull PsiFile file, boolean processChangedTextOnly) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "preprocessFile"));
        }
        final FutureTask<Boolean> previousTask = this.getPreviousProcessorTask(file, processChangedTextOnly);
        final FutureTask<Boolean> currentTask = this.prepareTask(file, processChangedTextOnly);
        return new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (previousTask != null) {
                    previousTask.run();
                    if (!((Boolean)previousTask.get()).booleanValue() || previousTask.isCancelled()) {
                        return false;
                    }
                }
                currentTask.run();
                return (Boolean)currentTask.get() != false && !currentTask.isCancelled();
            }
        });
    }

    public void run() {
        if (this.myDirectory != null) {
            this.runProcessDirectory(this.myDirectory, this.myIncludeSubdirs);
        } else if (this.myFiles != null) {
            this.runProcessFiles(this.myFiles);
        } else if (this.myFile != null) {
            this.runProcessFile(this.myFile);
        } else if (this.myModule != null) {
            this.runProcessOnModule(this.myModule);
        } else if (this.myProject != null) {
            this.runProcessOnProject(this.myProject);
        }
    }

    private void runProcessFile(final @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "runProcessFile"));
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
        if (document == null) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(document, this.myProject)) {
            Messages.showMessageDialog((Project)this.myProject, (String)PsiBundle.message((String)"cannot.modify.a.read.only.file", (Object[])new Object[]{file.getName()}), (String)CodeInsightBundle.message((String)"error.dialog.readonly.file.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        final Runnable[] resultRunnable = new Runnable[1];
        Runnable readAction = new Runnable(){

            @Override
            public void run() {
                if (!AbstractLayoutCodeProcessor.this.checkFileWritable(file)) {
                    return;
                }
                try {
                    resultRunnable[0] = AbstractLayoutCodeProcessor.this.preprocessFile(file, AbstractLayoutCodeProcessor.this.myProcessChangedTextOnly);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        Runnable writeAction = new Runnable(){

            @Override
            public void run() {
                if (resultRunnable[0] != null) {
                    resultRunnable[0].run();
                }
            }
        };
        this.runLayoutCodeProcess(readAction, writeAction, false);
    }

    private boolean checkFileWritable(PsiFile file) {
        if (!file.isWritable()) {
            ((MessagesEx.MessageInfo)MessagesEx.fileIsReadOnly(this.myProject, file.getVirtualFile()).setTitle(CodeInsightBundle.message((String)"error.dialog.readonly.file.title", (Object[])new Object[0]))).showLater();
            return false;
        }
        return true;
    }

    @Nullable
    private Runnable preprocessFiles(List<PsiFile> files) {
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        String oldText = null;
        double oldFraction = 0.0;
        if (progress != null) {
            oldText = progress.getText();
            oldFraction = progress.getFraction();
            progress.setText(this.myProgressText);
        }
        final ArrayList<FutureTask<Boolean>> tasks = new ArrayList<FutureTask<Boolean>>(files.size());
        for (int i = 0; i < files.size(); ++i) {
            PsiFile file = files.get(i);
            if (progress != null) {
                if (progress.isCanceled()) {
                    return null;
                }
                progress.setFraction((double)i / (double)files.size());
            }
            if (file.isWritable()) {
                try {
                    tasks.add(this.preprocessFile(file, this.myProcessChangedTextOnly));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            files.set(i, null);
        }
        if (progress != null) {
            progress.setText(oldText);
            progress.setFraction(oldFraction);
        }
        return new Runnable(){

            @Override
            public void run() {
                SequentialModalProgressTask progressTask = new SequentialModalProgressTask(AbstractLayoutCodeProcessor.this.myProject, AbstractLayoutCodeProcessor.this.myCommandName);
                ReformatFilesTask reformatFilesTask = new ReformatFilesTask(tasks);
                reformatFilesTask.setCompositeTask(progressTask);
                progressTask.setTask(reformatFilesTask);
                ProgressManager.getInstance().run((Task)progressTask);
            }
        };
    }

    private void runProcessFiles(final List<PsiFile> files) {
        final Runnable[] resultRunnable = new Runnable[1];
        this.runLayoutCodeProcess(new Runnable(){

            @Override
            public void run() {
                resultRunnable[0] = AbstractLayoutCodeProcessor.this.preprocessFiles(new ArrayList(files));
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (resultRunnable[0] != null) {
                    resultRunnable[0].run();
                }
            }
        }, files.size() > 1);
    }

    private void runProcessDirectory(PsiDirectory directory, boolean recursive) {
        ArrayList<PsiFile> array = new ArrayList<PsiFile>();
        AbstractLayoutCodeProcessor.collectFilesToProcess(array, directory, recursive);
        String where = CodeInsightBundle.message((String)"process.scope.directory", (Object[])new Object[]{directory.getVirtualFile().getPresentableUrl()});
        this.runProcessOnFiles(where, array);
    }

    private void runProcessOnProject(Project project) {
        ArrayList<PsiFile> array = new ArrayList<PsiFile>();
        this.collectFilesInProject(project, array);
        String where = CodeInsightBundle.message((String)"process.scope.project", (Object[])new Object[]{project.getPresentableUrl()});
        this.runProcessOnFiles(where, array);
    }

    private void runProcessOnModule(Module module) {
        ArrayList<PsiFile> array = new ArrayList<PsiFile>();
        this.collectFilesInModule(module, array);
        String where = CodeInsightBundle.message((String)"process.scope.module", (Object[])new Object[]{module.getModuleFilePath()});
        this.runProcessOnFiles(where, array);
    }

    private void collectFilesInProject(Project project, ArrayList<PsiFile> array) {
        Module[] modules;
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            this.collectFilesInModule(module, array);
        }
    }

    private void collectFilesInModule(Module module, ArrayList<PsiFile> array) {
        VirtualFile[] contentRoots;
        for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            PsiDirectory dir = PsiManager.getInstance((Project)this.myProject).findDirectory(root);
            if (dir == null) continue;
            AbstractLayoutCodeProcessor.collectFilesToProcess(array, dir, true);
        }
    }

    private void runProcessOnFiles(String where, final List<PsiFile> array) {
        boolean success = FileModificationService.getInstance().preparePsiElementsForWrite(array);
        if (!success) {
            ArrayList<PsiFile> writeables = new ArrayList<PsiFile>();
            for (PsiFile file : array) {
                if (!file.isWritable()) continue;
                writeables.add(file);
            }
            if (writeables.isEmpty()) {
                return;
            }
            int res = Messages.showOkCancelDialog((Project)this.myProject, (String)CodeInsightBundle.message((String)"error.dialog.readonly.files.message", (Object[])new Object[]{where}), (String)CodeInsightBundle.message((String)"error.dialog.readonly.files.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (res != 0) {
                return;
            }
            array.clear();
            array.addAll(writeables);
        }
        final Runnable[] resultRunnable = new Runnable[1];
        this.runLayoutCodeProcess(new Runnable(){

            @Override
            public void run() {
                resultRunnable[0] = AbstractLayoutCodeProcessor.this.preprocessFiles(array);
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (resultRunnable[0] != null) {
                    resultRunnable[0].run();
                }
            }
        }, array.size() > 1);
    }

    private static boolean canBeFormatted(PsiFile file, GeneratedSourcesFilter[] generatedSourcesFilters) {
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file) == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        if (ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile)) {
            return false;
        }
        for (GeneratedSourcesFilter filter : generatedSourcesFilters) {
            if (!filter.isGeneratedSource(virtualFile, file.getProject())) continue;
            return false;
        }
        return true;
    }

    private static void collectFilesToProcess(List<PsiFile> result, PsiDirectory dir, boolean recursive) {
        AbstractLayoutCodeProcessor.filterFilesTo(dir.getFiles(), result);
        if (recursive) {
            for (PsiDirectory subdir : dir.getSubdirectories()) {
                AbstractLayoutCodeProcessor.collectFilesToProcess(result, subdir, recursive);
            }
        }
    }

    private void runLayoutCodeProcess(final Runnable readAction, final Runnable writeAction, final boolean globalAction) {
        final ProgressWindow progressWindow = new ProgressWindow(true, this.myProject);
        progressWindow.setTitle(this.myCommandName);
        progressWindow.setText(this.myProgressText);
        final ModalityState modalityState = ModalityState.current();
        final Runnable process = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(readAction);
            }
        };
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ProgressManager.getInstance().runProcess(process, (ProgressIndicator)progressWindow);
                }
                catch (ProcessCanceledException e) {
                    return;
                }
                catch (IndexNotReadyException e) {
                    return;
                }
                Runnable writeRunnable = new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.getInstance().executeCommand(AbstractLayoutCodeProcessor.this.myProject, new Runnable(){

                            @Override
                            public void run() {
                                if (globalAction) {
                                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(AbstractLayoutCodeProcessor.this.myProject);
                                }
                                try {
                                    ApplicationManager.getApplication().runWriteAction(writeAction);
                                    if (AbstractLayoutCodeProcessor.this.myPostRunnable != null) {
                                        ApplicationManager.getApplication().invokeLater(AbstractLayoutCodeProcessor.this.myPostRunnable);
                                    }
                                }
                                catch (IndexNotReadyException indexNotReadyException) {
                                    // empty catch block
                                }
                            }
                        }, AbstractLayoutCodeProcessor.this.myCommandName, null);
                    }
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    writeRunnable.run();
                } else {
                    ApplicationManager.getApplication().invokeLater(writeRunnable, modalityState, AbstractLayoutCodeProcessor.this.myProject.getDisposed());
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(runnable);
        }
    }

    public void runWithoutProgress() throws IncorrectOperationException {
        FutureTask<Boolean> runnable = this.preprocessFile(this.myFile, this.myProcessChangedTextOnly);
        runnable.run();
    }

    private class ReformatFilesTask
    implements SequentialTask {
        private final List<FutureTask<Boolean>> myTasks;
        private final int myTotalTasksNumber;
        private SequentialModalProgressTask myCompositeTask;

        ReformatFilesTask(List<FutureTask<Boolean>> tasks) {
            if (tasks == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor$ReformatFilesTask", "<init>"));
            }
            this.myTasks = tasks;
            this.myTotalTasksNumber = this.myTasks.size();
        }

        public void prepare() {
        }

        public boolean isDone() {
            return this.myTasks.isEmpty();
        }

        public boolean iteration() {
            ProgressIndicator indicator;
            if (this.myTasks.isEmpty()) {
                return true;
            }
            FutureTask<Boolean> task = this.myTasks.remove(this.myTasks.size() - 1);
            if (task == null) {
                return this.myTasks.isEmpty();
            }
            task.run();
            try {
                if (!task.get().booleanValue() || task.isCancelled()) {
                    this.myTasks.clear();
                    return true;
                }
            }
            catch (InterruptedException e) {
                LOG.error("Got unexpected exception during formatting", (Throwable)e);
                return true;
            }
            catch (ExecutionException e) {
                LOG.error("Got unexpected exception during formatting", (Throwable)e);
                return true;
            }
            if (this.myCompositeTask != null && (indicator = this.myCompositeTask.getIndicator()) != null) {
                indicator.setText(AbstractLayoutCodeProcessor.this.myProgressText + (this.myTotalTasksNumber - this.myTasks.size()) + "/" + this.myTotalTasksNumber);
                indicator.setFraction((double)(this.myTotalTasksNumber - this.myTasks.size()) / (double)this.myTotalTasksNumber);
            }
            return this.myTasks.isEmpty();
        }

        public void stop() {
            this.myTasks.clear();
        }

        public void setCompositeTask(@Nullable SequentialModalProgressTask compositeTask) {
            this.myCompositeTask = compositeTask;
        }
    }
}

