/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.simple.BracesTailType;
import com.intellij.codeInsight.completion.simple.ParenthesesTailType;
import com.intellij.codeInsight.completion.simple.RParenthTailType;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;

public class TailTypes {
    public static final TailType CALL_RPARENTH = new RParenthTailType(){

        @Override
        protected boolean isSpaceWithinParentheses(CommonCodeStyleSettings styleSettings, Editor editor, int tailOffset) {
            return styleSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES && editor.getDocument().getCharsSequence().charAt(tailOffset - 1) != '(';
        }
    };
    public static final TailType IF_RPARENTH = new RParenthTailType(){

        @Override
        protected boolean isSpaceWithinParentheses(CommonCodeStyleSettings styleSettings, Editor editor, int tailOffset) {
            return styleSettings.SPACE_WITHIN_IF_PARENTHESES;
        }
    };
    public static final TailType WHILE_RPARENTH = new RParenthTailType(){

        @Override
        protected boolean isSpaceWithinParentheses(CommonCodeStyleSettings styleSettings, Editor editor, int tailOffset) {
            return styleSettings.SPACE_WITHIN_WHILE_PARENTHESES;
        }
    };
    public static final TailType CALL_RPARENTH_SEMICOLON = new RParenthTailType(){

        @Override
        protected boolean isSpaceWithinParentheses(CommonCodeStyleSettings styleSettings, Editor editor, int tailOffset) {
            return styleSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES;
        }

        @Override
        public int processTail(Editor editor, int tailOffset) {
            return 4.insertChar((Editor)editor, (int)super.processTail(editor, tailOffset), (char)';');
        }
    };
    public static final TailType SYNCHRONIZED_LPARENTH = new ParenthesesTailType(){

        @Override
        protected boolean isSpaceBeforeParentheses(CommonCodeStyleSettings styleSettings, Editor editor, int tailOffset) {
            return styleSettings.SPACE_BEFORE_SYNCHRONIZED_PARENTHESES;
        }

        @Override
        protected boolean isSpaceWithinParentheses(CommonCodeStyleSettings styleSettings, Editor editor, int tailOffset) {
            return styleSettings.SPACE_WITHIN_SYNCHRONIZED_PARENTHESES;
        }
    };
    public static final TailType CATCH_LPARENTH = new ParenthesesTailType(){

        @Override
        protected boolean isSpaceBeforeParentheses(CommonCodeStyleSettings styleSettings, Editor editor, int tailOffset) {
            return styleSettings.SPACE_BEFORE_CATCH_PARENTHESES;
        }

        @Override
        protected boolean isSpaceWithinParentheses(CommonCodeStyleSettings styleSettings, Editor editor, int tailOffset) {
            return styleSettings.SPACE_WITHIN_CATCH_PARENTHESES;
        }
    };
    public static final TailType SWITCH_LPARENTH = new ParenthesesTailType(){

        @Override
        protected boolean isSpaceBeforeParentheses(CommonCodeStyleSettings styleSettings, Editor editor, int tailOffset) {
            return styleSettings.SPACE_BEFORE_SWITCH_PARENTHESES;
        }

        @Override
        protected boolean isSpaceWithinParentheses(CommonCodeStyleSettings styleSettings, Editor editor, int tailOffset) {
            return styleSettings.SPACE_WITHIN_SWITCH_PARENTHESES;
        }
    };
    public static final TailType WHILE_LPARENTH = new ParenthesesTailType(){

        @Override
        protected boolean isSpaceBeforeParentheses(CommonCodeStyleSettings styleSettings, Editor editor, int tailOffset) {
            return styleSettings.SPACE_BEFORE_WHILE_PARENTHESES;
        }

        @Override
        protected boolean isSpaceWithinParentheses(CommonCodeStyleSettings styleSettings, Editor editor, int tailOffset) {
            return styleSettings.SPACE_WITHIN_WHILE_PARENTHESES;
        }
    };
    public static final TailType FOR_LPARENTH = new ParenthesesTailType(){

        @Override
        protected boolean isSpaceBeforeParentheses(CommonCodeStyleSettings styleSettings, Editor editor, int tailOffset) {
            return styleSettings.SPACE_BEFORE_FOR_PARENTHESES;
        }

        @Override
        protected boolean isSpaceWithinParentheses(CommonCodeStyleSettings styleSettings, Editor editor, int tailOffset) {
            return styleSettings.SPACE_WITHIN_FOR_PARENTHESES;
        }
    };
    public static final TailType IF_LPARENTH = new ParenthesesTailType(){

        @Override
        protected boolean isSpaceBeforeParentheses(CommonCodeStyleSettings styleSettings, Editor editor, int tailOffset) {
            return styleSettings.SPACE_BEFORE_IF_PARENTHESES;
        }

        @Override
        protected boolean isSpaceWithinParentheses(CommonCodeStyleSettings styleSettings, Editor editor, int tailOffset) {
            return styleSettings.SPACE_WITHIN_IF_PARENTHESES;
        }
    };
    private static final TailType BRACES;
    public static final TailType FINALLY_LBRACE;
    public static final TailType TRY_LBRACE;
    public static final TailType DO_LBRACE;

    private TailTypes() {
    }

    static {
        FINALLY_LBRACE = BRACES = new BracesTailType();
        TRY_LBRACE = BRACES;
        DO_LBRACE = BRACES;
    }
}

