/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.BaseExternalAnnotationsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ReadableExternalAnnotationsManager
extends BaseExternalAnnotationsManager {
    @NotNull
    private volatile ThreeState myHasAnyAnnotationsRoots = ThreeState.UNSURE;

    public ReadableExternalAnnotationsManager(PsiManager psiManager) {
        super(psiManager);
    }

    @Override
    protected boolean hasAnyAnnotationsRoots() {
        if (this.myHasAnyAnnotationsRoots == ThreeState.UNSURE) {
            Module[] modules;
            for (Module module : modules = ModuleManager.getInstance((Project)this.myPsiManager.getProject()).getModules()) {
                for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                    String[] urls = AnnotationOrderRootType.getUrls(entry);
                    if (urls.length <= 0) continue;
                    this.myHasAnyAnnotationsRoots = ThreeState.YES;
                    return true;
                }
            }
            this.myHasAnyAnnotationsRoots = ThreeState.NO;
        }
        return this.myHasAnyAnnotationsRoots == ThreeState.YES;
    }

    @Override
    @NotNull
    protected List<VirtualFile> getExternalAnnotationsRoots(@NotNull VirtualFile libraryFile) {
        if (libraryFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ReadableExternalAnnotationsManager", "getExternalAnnotationsRoots"));
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myPsiManager.getProject()).getFileIndex();
        LinkedHashSet result = new LinkedHashSet();
        for (OrderEntry entry : fileIndex.getOrderEntriesForFile(libraryFile)) {
            if (entry instanceof ModuleOrderEntry) continue;
            Collections.addAll(result, AnnotationOrderRootType.getFiles(entry));
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(result);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ReadableExternalAnnotationsManager", "getExternalAnnotationsRoots"));
        }
        return arrayList;
    }

    @Override
    protected void dropCache() {
        this.myHasAnyAnnotationsRoots = ThreeState.UNSURE;
        super.dropCache();
    }
}

