/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.PrintManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;

public class PrintAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        PrintManager.executePrint(dataContext);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file != null && file.isDirectory()) {
            presentation.setEnabled(true);
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        presentation.setEnabled(psiFile != null || editor != null);
    }
}

