/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.application.options.OptionId;
import com.intellij.application.options.OptionsApplicabilityFilter;
import com.intellij.application.options.editor.EditorAppearanceConfigurableEP;
import com.intellij.application.options.editor.EditorOptionsPanel;
import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EditorAppearanceConfigurable
extends CompositeConfigurable<UnnamedConfigurable>
implements EditorOptionsProvider {
    private static final ExtensionPointName<EditorAppearanceConfigurableEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.editorAppearanceConfigurable");
    private JPanel myRootPanel;
    private JCheckBox myCbBlinkCaret;
    private JCheckBox myCbBlockCursor;
    private JCheckBox myCbRightMargin;
    private JCheckBox myCbShowLineNumbers;
    private JCheckBox myCbShowWhitespaces;
    private JTextField myBlinkIntervalField;
    private JPanel myAddonPanel;
    private JCheckBox myCbShowMethodSeparators;
    private JCheckBox myAntialiasingInEditorCheckBox;
    private JCheckBox myCbShowIconsInGutter;
    private JCheckBox myShowVerticalIndentGuidesCheckBox;

    public EditorAppearanceConfigurable() {
        this.$$$setupUI$$$();
        this.myCbBlinkCaret.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditorAppearanceConfigurable.this.myBlinkIntervalField.setEnabled(EditorAppearanceConfigurable.this.myCbBlinkCaret.isSelected());
            }
        });
        if (!OptionsApplicabilityFilter.isApplicable(OptionId.ICONS_IN_GUTTER)) {
            this.myCbShowIconsInGutter.setVisible(false);
        }
    }

    @Override
    public void reset() {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        this.myCbShowMethodSeparators.setSelected(DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS);
        this.myCbBlinkCaret.setSelected(editorSettings.isBlinkCaret());
        this.myBlinkIntervalField.setText(Integer.toString(editorSettings.getBlinkPeriod()));
        this.myBlinkIntervalField.setEnabled(editorSettings.isBlinkCaret());
        this.myCbRightMargin.setSelected(editorSettings.isRightMarginShown());
        this.myCbShowLineNumbers.setSelected(editorSettings.isLineNumbersShown());
        this.myCbBlockCursor.setSelected(editorSettings.isBlockCursor());
        this.myCbShowWhitespaces.setSelected(editorSettings.isWhitespacesShown());
        this.myShowVerticalIndentGuidesCheckBox.setSelected(editorSettings.isIndentGuidesShown());
        this.myAntialiasingInEditorCheckBox.setSelected(UISettings.getInstance().ANTIALIASING_IN_EDITOR);
        this.myCbShowIconsInGutter.setSelected(DaemonCodeAnalyzerSettings.getInstance().SHOW_SMALL_ICONS_IN_GUTTER);
        super.reset();
    }

    @Override
    public void apply() throws ConfigurationException {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        editorSettings.setBlinkCaret(this.myCbBlinkCaret.isSelected());
        try {
            editorSettings.setBlinkPeriod(Integer.parseInt(this.myBlinkIntervalField.getText()));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        editorSettings.setBlockCursor(this.myCbBlockCursor.isSelected());
        editorSettings.setRightMarginShown(this.myCbRightMargin.isSelected());
        editorSettings.setLineNumbersShown(this.myCbShowLineNumbers.isSelected());
        editorSettings.setWhitespacesShown(this.myCbShowWhitespaces.isSelected());
        editorSettings.setIndentGuidesShown(this.myShowVerticalIndentGuidesCheckBox.isSelected());
        EditorOptionsPanel.reinitAllEditors();
        DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS = this.myCbShowMethodSeparators.isSelected();
        DaemonCodeAnalyzerSettings.getInstance().SHOW_SMALL_ICONS_IN_GUTTER = this.myCbShowIconsInGutter.isSelected();
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.ANTIALIASING_IN_EDITOR != this.myAntialiasingInEditorCheckBox.isSelected()) {
            uiSettings.ANTIALIASING_IN_EDITOR = this.myAntialiasingInEditorCheckBox.isSelected();
            LafManager.getInstance().repaintUI();
            uiSettings.fireUISettingsChanged();
        }
        EditorOptionsPanel.restartDaemons();
        super.apply();
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        boolean isModified = EditorAppearanceConfigurable.isModified(this.myCbBlinkCaret, editorSettings.isBlinkCaret());
        isModified |= EditorAppearanceConfigurable.isModified(this.myBlinkIntervalField, editorSettings.getBlinkPeriod());
        isModified |= EditorAppearanceConfigurable.isModified(this.myCbBlockCursor, editorSettings.isBlockCursor());
        isModified |= EditorAppearanceConfigurable.isModified(this.myCbRightMargin, editorSettings.isRightMarginShown());
        isModified |= EditorAppearanceConfigurable.isModified(this.myCbShowLineNumbers, editorSettings.isLineNumbersShown());
        isModified |= EditorAppearanceConfigurable.isModified(this.myCbShowWhitespaces, editorSettings.isWhitespacesShown());
        isModified |= EditorAppearanceConfigurable.isModified(this.myShowVerticalIndentGuidesCheckBox, editorSettings.isIndentGuidesShown());
        isModified |= EditorAppearanceConfigurable.isModified(this.myCbShowMethodSeparators, DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS);
        isModified |= EditorAppearanceConfigurable.isModified(this.myCbShowIconsInGutter, DaemonCodeAnalyzerSettings.getInstance().SHOW_SMALL_ICONS_IN_GUTTER);
        return isModified |= this.myAntialiasingInEditorCheckBox.isSelected() != UISettings.getInstance().ANTIALIASING_IN_EDITOR;
    }

    private static boolean isModified(JToggleButton checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    private static boolean isModified(JTextField textField, int value) {
        try {
            int fieldValue = Integer.parseInt(textField.getText().trim());
            return fieldValue != value;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Nls
    public String getDisplayName() {
        return ApplicationBundle.message((String)"tab.editor.settings.appearance", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.editor.appearance";
    }

    public JComponent createComponent() {
        for (UnnamedConfigurable provider : this.getConfigurables()) {
            this.myAddonPanel.add((Component)provider.createComponent(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 15, 0), 0, 0));
        }
        return this.myRootPanel;
    }

    @Override
    public void disposeUIResources() {
        this.myAddonPanel.removeAll();
        super.disposeUIResources();
    }

    @Override
    protected List<UnnamedConfigurable> createConfigurables() {
        return ConfigurableWrapper.createConfigurables(EP_NAME);
    }

    @NotNull
    public String getId() {
        if ("editor.preferences.appearance" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/editor/EditorAppearanceConfigurable", "getId"));
        }
        return "editor.preferences.appearance";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(11, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(10, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCbBlockCursor = jCheckBox9 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.use.block.caret"));
        jPanel2.add((Component)jCheckBox9, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbRightMargin = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.right.margin"));
        jCheckBox8.setSelected(false);
        jPanel2.add((Component)jCheckBox8, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbShowLineNumbers = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.line.numbers"));
        jPanel2.add((Component)jCheckBox7, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbShowWhitespaces = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.whitespaces"));
        jPanel2.add((Component)jCheckBox6, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowVerticalIndentGuidesCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Show vertical indent guides");
        jPanel2.add((Component)jCheckBox5, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAddonPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridConstraints(9, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myCbShowMethodSeparators = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.method.separators"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAntialiasingInEditorCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.use.antialiased.font.in.editor"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbShowIconsInGutter = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.small.icons.in.gutter"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(8, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCbBlinkCaret = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.caret.blinking.ms"));
        jCheckBox.setSelected(true);
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBlinkIntervalField = jTextField = new JTextField();
        jTextField.setText("500");
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(50, -1), new Dimension(50, -1)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

