/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.TailPanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.ListCellRendererWrapper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class ColorAndFontDescriptionPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.colors.ColorAndFontDescriptionPanel");
    private final ColorPanel myBackgroundChooser = new ColorPanel();
    private final ColorPanel myForegroundChooser = new ColorPanel();
    private final ColorPanel myEffectsColorChooser = new ColorPanel();
    private final ColorPanel myErrorStripeColorChooser = new ColorPanel();
    private final JCheckBox myCbBackground = new JCheckBox(ApplicationBundle.message((String)"checkbox.color.background", (Object[])new Object[0]));
    private final JCheckBox myCbForeground = new JCheckBox(ApplicationBundle.message((String)"checkbox.color.foreground", (Object[])new Object[0]));
    private final JCheckBox myCbEffects = new JCheckBox(ApplicationBundle.message((String)"checkbox.color.effects", (Object[])new Object[0]));
    private final JCheckBox myCbErrorStripe = new JCheckBox(ApplicationBundle.message((String)"checkbox.color.error.stripe.mark", (Object[])new Object[0]));
    private static final String BORDERED_EFFECT = ApplicationBundle.message((String)"combobox.effect.bordered", (Object[])new Object[0]);
    private static final String UNDERSCORED_EFFECT = ApplicationBundle.message((String)"combobox.effect.underscored", (Object[])new Object[0]);
    private static final String BOLD_UNDERSCORED_EFFECT = ApplicationBundle.message((String)"combobox.effect.boldunderscored", (Object[])new Object[0]);
    private static final String UNDERWAVED_EFFECT = ApplicationBundle.message((String)"combobox.effect.underwaved", (Object[])new Object[0]);
    private static final String STRIKEOUT_EFFECT = ApplicationBundle.message((String)"combobox.effect.strikeout", (Object[])new Object[0]);
    private static final String BOLD_DOTTED_LINE_EFFECT = ApplicationBundle.message((String)"combobox.effect.bold.dottedline", (Object[])new Object[0]);
    private final JComboBox myEffectsCombo = new JComboBox<String>(new String[]{UNDERSCORED_EFFECT, BOLD_UNDERSCORED_EFFECT, UNDERWAVED_EFFECT, BORDERED_EFFECT, STRIKEOUT_EFFECT, BOLD_DOTTED_LINE_EFFECT});
    private final JCheckBox myCbBold = new JCheckBox(ApplicationBundle.message((String)"checkbox.font.bold", (Object[])new Object[0]));
    private final JCheckBox myCbItalic = new JCheckBox(ApplicationBundle.message((String)"checkbox.font.italic", (Object[])new Object[0]));
    private boolean updatingEffects;
    private ActionListener myActionListener;
    private JLabel myLabelFont;
    private final JLabel myInheritanceLabel = new JLabel("X");
    private final JCheckBox myInheritAttributesBox = new JCheckBox(ApplicationBundle.message((String)"label.inherit.attributes", (Object[])new Object[0]));

    public ColorAndFontDescriptionPanel() {
        super(new BorderLayout());
        JPanel settingsPanel = this.createSettingsPanel();
        this.add((Component)settingsPanel, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 4));
        this.myEffectsCombo.setRenderer(new ListCellRendererWrapper<String>(){

            public void customize(JList list, String value, int index, boolean selected, boolean hasFocus) {
                this.setText(value != null ? value : "Invalid");
            }
        });
    }

    private JPanel createSettingsPanel() {
        JPanel settingsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 2;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.gridwidth = 0;
        gbConstraints.insets = new Insets(4, 4, 4, 4);
        settingsPanel.add((Component)this.createFontSettingsPanel(), gbConstraints);
        settingsPanel.add((Component)this.createColorSettingsPanel(), gbConstraints);
        gbConstraints.weighty = 1.0;
        settingsPanel.add((Component)new TailPanel(), gbConstraints);
        settingsPanel.add((Component)this.createInheritancePanel(), gbConstraints);
        return settingsPanel;
    }

    private JPanel createInheritancePanel() {
        JPanel inheritancePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 2;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 2;
        inheritancePanel.add((Component)this.myInheritAttributesBox, gbConstraints);
        gbConstraints.gridy = 1;
        gbConstraints.insets = new Insets(0, 20, 0, 0);
        inheritancePanel.add((Component)this.myInheritanceLabel, gbConstraints);
        this.myInheritAttributesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ColorAndFontDescriptionPanel.this.myActionListener != null) {
                    ColorAndFontDescriptionPanel.this.myActionListener.actionPerformed(e);
                }
            }
        });
        return inheritancePanel;
    }

    private JPanel createFontSettingsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 2;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridy = 1;
        gbConstraints.gridx = 1;
        this.myLabelFont = new JLabel(ApplicationBundle.message((String)"label.font.type", (Object[])new Object[0]));
        panel.add((Component)this.myLabelFont, gbConstraints);
        gbConstraints.gridx = 2;
        panel.add((Component)this.myCbBold, gbConstraints);
        gbConstraints.gridx = 3;
        panel.add((Component)this.myCbItalic, gbConstraints);
        gbConstraints.gridx = 4;
        gbConstraints.weightx = 1.0;
        panel.add((Component)new TailPanel(), gbConstraints);
        this.myCbBold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ColorAndFontDescriptionPanel.this.myActionListener != null) {
                    ColorAndFontDescriptionPanel.this.myActionListener.actionPerformed(e);
                }
            }
        });
        this.myCbItalic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ColorAndFontDescriptionPanel.this.myActionListener != null) {
                    ColorAndFontDescriptionPanel.this.myActionListener.actionPerformed(e);
                }
            }
        });
        return panel;
    }

    private JPanel createColorSettingsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.gridy = 0;
        panel.add((Component)this.myCbForeground, gc);
        ++gc.gridy;
        panel.add((Component)this.myCbBackground, gc);
        ++gc.gridy;
        panel.add((Component)this.myCbErrorStripe, gc);
        ++gc.gridy;
        panel.add((Component)this.myCbEffects, gc);
        ++gc.gridy;
        gc.insets = new Insets(0, 10, 0, 0);
        gc.weighty = 0.0;
        panel.add((Component)this.myEffectsCombo, gc);
        gc.gridx = 1;
        gc.gridy = 0;
        panel.add((Component)this.myForegroundChooser, gc);
        ++gc.gridy;
        panel.add((Component)this.myBackgroundChooser, gc);
        ++gc.gridy;
        panel.add((Component)this.myErrorStripeColorChooser, gc);
        gc.gridy += 2;
        panel.add((Component)this.myEffectsColorChooser, gc);
        gc.gridx = 2;
        gc.gridy = 0;
        gc.weightx = 1.0;
        panel.add((Component)new TailPanel(), gc);
        ++gc.gridy;
        panel.add((Component)new TailPanel(), gc);
        ++gc.gridy;
        panel.add((Component)new TailPanel(), gc);
        ++gc.gridy;
        panel.add((Component)new TailPanel(), gc);
        this.myEffectsColorChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ColorAndFontDescriptionPanel.this.myActionListener != null) {
                    ColorAndFontDescriptionPanel.this.myActionListener.actionPerformed(e);
                }
            }
        });
        this.myForegroundChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ColorAndFontDescriptionPanel.this.myActionListener != null) {
                    ColorAndFontDescriptionPanel.this.myActionListener.actionPerformed(e);
                }
            }
        });
        this.myCbForeground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorAndFontDescriptionPanel.this.myForegroundChooser.setEnabled(ColorAndFontDescriptionPanel.this.myCbForeground.isSelected());
                if (ColorAndFontDescriptionPanel.this.myActionListener != null) {
                    ColorAndFontDescriptionPanel.this.myActionListener.actionPerformed(e);
                }
            }
        });
        this.myBackgroundChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ColorAndFontDescriptionPanel.this.myActionListener != null) {
                    ColorAndFontDescriptionPanel.this.myActionListener.actionPerformed(e);
                }
            }
        });
        this.myErrorStripeColorChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ColorAndFontDescriptionPanel.this.myActionListener != null) {
                    ColorAndFontDescriptionPanel.this.myActionListener.actionPerformed(e);
                }
            }
        });
        this.myCbBackground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorAndFontDescriptionPanel.this.myBackgroundChooser.setEnabled(ColorAndFontDescriptionPanel.this.myCbBackground.isSelected());
                if (ColorAndFontDescriptionPanel.this.myActionListener != null) {
                    ColorAndFontDescriptionPanel.this.myActionListener.actionPerformed(e);
                }
            }
        });
        this.myCbErrorStripe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorAndFontDescriptionPanel.this.myErrorStripeColorChooser.setEnabled(ColorAndFontDescriptionPanel.this.myCbErrorStripe.isSelected());
                if (ColorAndFontDescriptionPanel.this.myActionListener != null) {
                    ColorAndFontDescriptionPanel.this.myActionListener.actionPerformed(e);
                }
            }
        });
        this.myCbEffects.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean checked = ColorAndFontDescriptionPanel.this.myCbEffects.isSelected();
                ColorAndFontDescriptionPanel.this.myEffectsColorChooser.setEnabled(checked);
                ColorAndFontDescriptionPanel.this.myEffectsCombo.setEnabled(checked);
                if (ColorAndFontDescriptionPanel.this.myActionListener != null) {
                    ColorAndFontDescriptionPanel.this.myActionListener.actionPerformed(e);
                }
            }
        });
        this.myEffectsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ColorAndFontDescriptionPanel.this.updatingEffects && ColorAndFontDescriptionPanel.this.myActionListener != null) {
                    ColorAndFontDescriptionPanel.this.myActionListener.actionPerformed(e);
                }
            }
        });
        return panel;
    }

    public void setActionListener(ActionListener actionListener) {
        this.myActionListener = actionListener;
    }

    public void resetDefault() {
        this.myLabelFont.setEnabled(false);
        this.myCbBold.setSelected(false);
        this.myCbBold.setEnabled(false);
        this.myCbItalic.setSelected(false);
        this.myCbItalic.setEnabled(false);
        ColorAndFontDescriptionPanel.updateColorChooser(this.myCbForeground, this.myForegroundChooser, false, false, null);
        ColorAndFontDescriptionPanel.updateColorChooser(this.myCbBackground, this.myBackgroundChooser, false, false, null);
        ColorAndFontDescriptionPanel.updateColorChooser(this.myCbErrorStripe, this.myErrorStripeColorChooser, false, false, null);
        ColorAndFontDescriptionPanel.updateColorChooser(this.myCbEffects, this.myEffectsColorChooser, false, false, null);
        this.myEffectsCombo.setEnabled(false);
    }

    private static void updateColorChooser(JCheckBox checkBox, ColorPanel colorPanel, boolean isEnabled, boolean isChecked, @Nullable Color color) {
        checkBox.setEnabled(isEnabled);
        checkBox.setSelected(isChecked);
        if (color != null) {
            colorPanel.setSelectedColor(color);
        } else {
            colorPanel.setSelectedColor(Color.white);
        }
        colorPanel.setEnabled(isChecked);
    }

    public void reset(ColorAndFontDescription description) {
        if (description.isFontEnabled()) {
            this.myLabelFont.setEnabled(true);
            this.myCbBold.setEnabled(true);
            this.myCbItalic.setEnabled(true);
            int fontType = description.getFontType();
            this.myCbBold.setSelected((fontType & 1) != 0);
            this.myCbItalic.setSelected((fontType & 2) != 0);
        } else {
            this.myLabelFont.setEnabled(false);
            this.myCbBold.setSelected(false);
            this.myCbBold.setEnabled(false);
            this.myCbItalic.setSelected(false);
            this.myCbItalic.setEnabled(false);
        }
        ColorAndFontDescriptionPanel.updateColorChooser(this.myCbForeground, this.myForegroundChooser, description.isForegroundEnabled(), description.isForegroundChecked(), description.getForegroundColor());
        ColorAndFontDescriptionPanel.updateColorChooser(this.myCbBackground, this.myBackgroundChooser, description.isBackgroundEnabled(), description.isBackgroundChecked(), description.getBackgroundColor());
        ColorAndFontDescriptionPanel.updateColorChooser(this.myCbErrorStripe, this.myErrorStripeColorChooser, description.isErrorStripeEnabled(), description.isErrorStripeChecked(), description.getErrorStripeColor());
        EffectType effectType = description.getEffectType();
        ColorAndFontDescriptionPanel.updateColorChooser(this.myCbEffects, this.myEffectsColorChooser, description.isEffectsColorEnabled(), description.isEffectsColorChecked(), description.getEffectColor());
        if (description.isEffectsColorEnabled() && description.isEffectsColorChecked()) {
            this.myEffectsCombo.setEnabled(true);
            this.updatingEffects = true;
            if (effectType == EffectType.BOXED) {
                this.myEffectsCombo.setSelectedItem(BORDERED_EFFECT);
            } else if (effectType == EffectType.LINE_UNDERSCORE) {
                this.myEffectsCombo.setSelectedItem(UNDERSCORED_EFFECT);
            } else if (effectType == EffectType.WAVE_UNDERSCORE) {
                this.myEffectsCombo.setSelectedItem(UNDERWAVED_EFFECT);
            } else if (effectType == EffectType.BOLD_LINE_UNDERSCORE) {
                this.myEffectsCombo.setSelectedItem(BOLD_UNDERSCORED_EFFECT);
            } else if (effectType == EffectType.STRIKEOUT) {
                this.myEffectsCombo.setSelectedItem(STRIKEOUT_EFFECT);
            } else if (effectType == EffectType.BOLD_DOTTED_LINE) {
                this.myEffectsCombo.setSelectedItem(BOLD_DOTTED_LINE_EFFECT);
            } else {
                this.myEffectsCombo.setSelectedItem(null);
            }
            this.updatingEffects = false;
        } else {
            this.myEffectsCombo.setEnabled(false);
        }
        this.setInheritanceInfo(description);
    }

    private void setInheritanceInfo(ColorAndFontDescription description) {
        Pair<ColorSettingsPage, AttributesDescriptor> baseDescriptor = description.getBaseAttributeDescriptor();
        if (baseDescriptor != null && ((AttributesDescriptor)baseDescriptor.second).getDisplayName() != null) {
            String tooltipText;
            String labelText;
            String attrName = ((AttributesDescriptor)baseDescriptor.second).getDisplayName();
            ColorSettingsPage settingsPage = (ColorSettingsPage)baseDescriptor.first;
            String pageName = "?";
            if (settingsPage != null) {
                pageName = settingsPage.getDisplayName();
            }
            if ((labelText = (tooltipText = attrName + " (" + pageName + ")")).length() > 30 && pageName.length() >= 4) {
                labelText = attrName + " (" + pageName.substring(0, 4) + "...)";
            }
            this.myInheritanceLabel.setText(labelText);
            this.myInheritanceLabel.setToolTipText(tooltipText);
            this.myInheritanceLabel.setForeground(this.myLabelFont.getForeground());
            this.myInheritanceLabel.setEnabled(description.isInherited());
            this.myInheritAttributesBox.setEnabled(true);
            this.myInheritAttributesBox.setSelected(description.isInherited());
            this.setEditEnabled(!description.isInherited(), description);
        } else {
            this.myInheritanceLabel.setText("X");
            this.myInheritanceLabel.setIcon(null);
            this.myInheritanceLabel.setDisabledIcon(null);
            this.myInheritanceLabel.setEnabled(true);
            this.myInheritanceLabel.setForeground(this.myLabelFont.getBackground());
            this.myInheritAttributesBox.setEnabled(false);
            this.myInheritAttributesBox.setSelected(false);
            this.setEditEnabled(true, description);
        }
    }

    private void setEditEnabled(boolean isEditEnabled, ColorAndFontDescription description) {
        this.myCbBackground.setEnabled(isEditEnabled && description.isBackgroundEnabled());
        this.myCbForeground.setEnabled(isEditEnabled && description.isForegroundEnabled());
        this.myCbBold.setEnabled(isEditEnabled && description.isFontEnabled());
        this.myCbItalic.setEnabled(isEditEnabled && description.isFontEnabled());
        this.myCbEffects.setEnabled(isEditEnabled && description.isEffectsColorEnabled());
        this.myCbErrorStripe.setEnabled(isEditEnabled && description.isErrorStripeEnabled());
        this.myErrorStripeColorChooser.setEditable(isEditEnabled);
        this.myEffectsColorChooser.setEditable(isEditEnabled);
        this.myForegroundChooser.setEditable(isEditEnabled);
        this.myBackgroundChooser.setEditable(isEditEnabled);
    }

    public void apply(ColorAndFontDescription description, EditorColorsScheme scheme) {
        if (description != null) {
            description.setInherited(this.myInheritAttributesBox.isSelected());
            if (description.isInherited()) {
                TextAttributes baseAttributes = description.getBaseAttributes();
                if (baseAttributes != null) {
                    description.setFontType(baseAttributes.getFontType());
                    description.setForegroundChecked(baseAttributes.getForegroundColor() != null);
                    description.setForegroundColor(baseAttributes.getForegroundColor());
                    description.setBackgroundChecked(baseAttributes.getBackgroundColor() != null);
                    description.setBackgroundColor(baseAttributes.getBackgroundColor());
                    description.setErrorStripeChecked(baseAttributes.getErrorStripeColor() != null);
                    description.setErrorStripeColor(baseAttributes.getErrorStripeColor());
                    description.setEffectColor(baseAttributes.getEffectColor());
                    description.setEffectType(baseAttributes.getEffectType());
                    description.setEffectsColorChecked(baseAttributes.getEffectColor() != null);
                } else {
                    description.setInherited(false);
                }
                this.reset(description);
            } else {
                this.setInheritanceInfo(description);
                int fontType = 0;
                if (this.myCbBold.isSelected()) {
                    fontType |= 1;
                }
                if (this.myCbItalic.isSelected()) {
                    fontType |= 2;
                }
                description.setFontType(fontType);
                description.setForegroundChecked(this.myCbForeground.isSelected());
                description.setForegroundColor(this.myForegroundChooser.getSelectedColor());
                description.setBackgroundChecked(this.myCbBackground.isSelected());
                description.setBackgroundColor(this.myBackgroundChooser.getSelectedColor());
                description.setErrorStripeChecked(this.myCbErrorStripe.isSelected());
                description.setErrorStripeColor(this.myErrorStripeColorChooser.getSelectedColor());
                description.setEffectsColorChecked(this.myCbEffects.isSelected());
                description.setEffectColor(this.myEffectsColorChooser.getSelectedColor());
                if (this.myEffectsCombo.isEnabled()) {
                    Object effectType = this.myEffectsCombo.getModel().getSelectedItem();
                    if (BORDERED_EFFECT.equals(effectType)) {
                        description.setEffectType(EffectType.BOXED);
                    } else if (UNDERWAVED_EFFECT.equals(effectType)) {
                        description.setEffectType(EffectType.WAVE_UNDERSCORE);
                    } else if (UNDERSCORED_EFFECT.equals(effectType)) {
                        description.setEffectType(EffectType.LINE_UNDERSCORE);
                    } else if (BOLD_UNDERSCORED_EFFECT.equals(effectType)) {
                        description.setEffectType(EffectType.BOLD_LINE_UNDERSCORE);
                    } else if (STRIKEOUT_EFFECT.equals(effectType)) {
                        description.setEffectType(EffectType.STRIKEOUT);
                    } else if (BOLD_DOTTED_LINE_EFFECT.equals(effectType)) {
                        description.setEffectType(EffectType.BOLD_DOTTED_LINE);
                    } else {
                        LOG.assertTrue(false);
                    }
                }
            }
            description.apply(scheme);
        }
    }
}

