/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.ArrangementConstants;
import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementEditorComponent;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchNodeComponentFactory;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRuleEditor;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesModel;
import com.intellij.application.options.codeStyle.arrangement.match.EmptyArrangementRuleComponent;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementEditorAware;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementRepresentationAware;
import com.intellij.application.options.codeStyle.arrangement.util.ArrangementListRowDecorator;
import com.intellij.application.options.codeStyle.arrangement.util.IntObjectMap;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementUiComponent;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.AbstractTableCellEditor;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementMatchingRulesControl
extends JBTable {
    @NotNull
    public static final DataKey<ArrangementMatchingRulesControl> KEY = DataKey.create((String)"Arrangement.Rule.Match.Control");
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)("#" + ArrangementMatchingRulesControl.class.getName()));
    @NotNull
    private static final JLabel EMPTY_RENDERER = new JLabel(ApplicationBundle.message((String)"arrangement.text.empty.rule", (Object[])new Object[0]));
    @NotNull
    private final IntObjectMap<ArrangementListRowDecorator> myComponents;
    @NotNull
    private final TIntArrayList mySelectedRows;
    @NotNull
    private final ArrangementMatchNodeComponentFactory myFactory;
    @NotNull
    private final ArrangementMatchingRuleEditor myEditor;
    @NotNull
    private final RepresentationCallback myRepresentationCallback;
    @NotNull
    private final MyRenderer myRenderer;
    private final int myMinRowHeight;
    private int myRowUnderMouse;
    private int myEditorRow;
    private boolean mySkipSelectionChange;

    public ArrangementMatchingRulesControl(@NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull RepresentationCallback callback) {
        if (settingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "<init>"));
        }
        if (colorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "<init>"));
        }
        super((TableModel)new ArrangementMatchingRulesModel());
        this.myComponents = new IntObjectMap();
        this.mySelectedRows = new TIntArrayList();
        this.myRowUnderMouse = -1;
        this.myEditorRow = -1;
        this.myRepresentationCallback = callback;
        this.myFactory = new ArrangementMatchNodeComponentFactory(settingsManager, colorsProvider, this);
        this.myRenderer = new MyRenderer();
        this.setDefaultRenderer(Object.class, this.myRenderer);
        this.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)((Object)new MyEditor()));
        this.setSelectionMode(2);
        this.setShowColumns(false);
        this.setShowGrid(false);
        this.setSurrendersFocusOnKeystroke(true);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ArrangementAtomMatchCondition condition = new ArrangementAtomMatchCondition(StdArrangementTokens.EntryType.CLASS);
        StdArrangementMatchRule rule = new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)condition));
        ArrangementUiComponent component = this.myFactory.getComponent((ArrangementMatchCondition)condition, rule, true);
        this.myMinRowHeight = new ArrangementListRowDecorator((ArrangementUiComponent)component, (ArrangementMatchingRulesControl)this).getPreferredSize().height;
        this.myEditor = new ArrangementMatchingRuleEditor(settingsManager, colorsProvider, this);
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ArrangementMatchingRulesControl.this.onMouseMoved(e);
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ArrangementMatchingRulesControl.this.onSelectionChange(e);
            }
        });
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ArrangementMatchingRulesControl.this.onTableChange(e);
            }
        });
    }

    @NotNull
    public ArrangementMatchingRulesModel getModel() {
        ArrangementMatchingRulesModel arrangementMatchingRulesModel = (ArrangementMatchingRulesModel)super.getModel();
        if (arrangementMatchingRulesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "getModel"));
        }
        return arrangementMatchingRulesModel;
    }

    public void setRules(@Nullable List<StdArrangementMatchRule> rules) {
        this.myComponents.clear();
        this.getModel().clear();
        if (rules == null) {
            return;
        }
        for (StdArrangementMatchRule rule : rules) {
            this.getModel().add(rule);
        }
        if (ArrangementConstants.LOG_RULE_MODIFICATION) {
            LOG.info("Arrangement matching rules list is refreshed. Given rules:");
            for (StdArrangementMatchRule rule : rules) {
                LOG.info("  " + rule.toString());
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        int id = e.getID();
        switch (id) {
            case 504: {
                this.onMouseEntered(e);
                break;
            }
            case 505: {
                this.onMouseExited();
                break;
            }
            case 502: {
                this.onMouseReleased(e);
            }
        }
        if (!e.isConsumed()) {
            super.processMouseEvent(e);
        }
    }

    private void onMouseMoved(@NotNull MouseEvent e) {
        ArrangementListRowDecorator decorator;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "onMouseMoved"));
        }
        int i = this.rowAtPoint(e.getPoint());
        if (i != this.myRowUnderMouse) {
            this.onMouseExited();
        }
        if (i < 0) {
            return;
        }
        if (i != this.myRowUnderMouse) {
            this.onMouseEntered(e);
        }
        if ((decorator = this.myComponents.get(i)) == null) {
            return;
        }
        Rectangle rectangle = decorator.onMouseMove(e);
        if (rectangle != null) {
            this.repaintScreenBounds(rectangle);
        }
    }

    private void repaintScreenBounds(@NotNull Rectangle bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "repaintScreenBounds"));
        }
        Point location = bounds.getLocation();
        SwingUtilities.convertPointFromScreen(location, (Component)((Object)this));
        int x = location.x;
        int width = bounds.width;
        this.repaint(x, location.y, width, bounds.height);
    }

    private void onMouseReleased(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "onMouseReleased"));
        }
        int i = this.rowAtPoint(e.getPoint());
        if (i < 0) {
            return;
        }
        ArrangementListRowDecorator decorator = this.myComponents.get(i);
        if (decorator != null) {
            decorator.onMouseRelease(e);
        }
        if (!e.isConsumed() && this.myEditorRow > 0 && this.myEditorRow == i + 1) {
            this.hideEditor();
        }
    }

    private void onMouseExited() {
        if (this.myRowUnderMouse < 0) {
            return;
        }
        ArrangementListRowDecorator decorator = this.myComponents.get(this.myRowUnderMouse);
        if (decorator != null) {
            decorator.onMouseExited();
            this.repaintRows(this.myRowUnderMouse, this.myRowUnderMouse, false);
        }
        this.myRowUnderMouse = -1;
    }

    private void onMouseEntered(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "onMouseEntered"));
        }
        this.myRowUnderMouse = this.rowAtPoint(e.getPoint());
        ArrangementListRowDecorator decorator = this.myComponents.get(this.myRowUnderMouse);
        if (decorator != null) {
            decorator.onMouseEntered(e);
            this.repaintRows(this.myRowUnderMouse, this.myRowUnderMouse, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOperationIgnoreSelectionChange(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "runOperationIgnoreSelectionChange"));
        }
        this.mySkipSelectionChange = true;
        try {
            if (this.isEditing()) {
                this.getCellEditor().stopCellEditing();
            }
            task.run();
        }
        finally {
            this.mySkipSelectionChange = false;
            this.refreshEditor();
        }
    }

    private void onSelectionChange(@NotNull ListSelectionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "onSelectionChange"));
        }
        if (this.mySkipSelectionChange || e.getValueIsAdjusting()) {
            return;
        }
        this.refreshEditor();
    }

    public void removeRow(int rowIndex) {
        if (rowIndex < this.myEditorRow) {
            this.hideEditor();
        }
        this.getModel().removeRow(rowIndex);
    }

    public void refreshEditor() {
        ArrangementMatchingRulesModel model = this.getModel();
        if (this.myEditorRow >= model.getSize()) {
            this.myEditorRow = -1;
            int max = model.getSize();
            for (int i = 0; i < max; ++i) {
                if (!(model.getElementAt(i) instanceof ArrangementEditorComponent)) continue;
                this.myEditorRow = i;
                break;
            }
        }
        if (this.myEditorRow < 0) {
            return;
        }
        ListSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            this.hideEditor();
            return;
        }
        int selectedRow = selectionModel.getMinSelectionIndex();
        if (selectedRow != selectionModel.getMaxSelectionIndex()) {
            this.hideEditor();
            return;
        }
        if (selectedRow != this.myEditorRow && selectedRow != this.myEditorRow - 1) {
            this.hideEditor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideEditor() {
        TableCellEditor editor;
        if (this.myEditorRow < 0) {
            return;
        }
        if (this.isEditing() && (editor = this.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
        this.mySkipSelectionChange = true;
        try {
            ArrangementMatchingRulesModel model = this.getModel();
            model.removeRow(this.myEditorRow);
            if (this.myEditorRow > 0 && model.getElementAt(this.myEditorRow - 1) instanceof EmptyArrangementRuleComponent) {
                model.removeRow(this.myEditorRow - 1);
            }
        }
        finally {
            this.mySkipSelectionChange = false;
        }
        this.myEditorRow = -1;
    }

    private void onTableChange(@NotNull TableModelEvent e) {
        int signum;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "onTableChange"));
        }
        switch (e.getType()) {
            case 1: {
                signum = 1;
                break;
            }
            case -1: {
                signum = -1;
                for (int i = e.getLastRow(); i >= e.getFirstRow(); --i) {
                    this.myComponents.remove(i);
                }
                break;
            }
            default: {
                return;
            }
        }
        int shift = Math.abs(e.getFirstRow() - e.getLastRow() + 1) * signum;
        this.myComponents.shiftKeys(e.getFirstRow(), shift);
        if (this.myRowUnderMouse >= e.getFirstRow()) {
            this.myRowUnderMouse = -1;
        }
        if (this.getModel().getSize() > 0) {
            this.repaintRows(0, this.getModel().getSize() - 1, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showEditor(int rowToEdit) {
        if (this.myEditorRow == rowToEdit + 1) {
            return;
        }
        if (this.myEditorRow >= 0) {
            if (this.myEditorRow < rowToEdit) {
                --rowToEdit;
            }
            this.hideEditor();
        }
        this.myEditorRow = rowToEdit + 1;
        ArrangementEditorComponent editor = new ArrangementEditorComponent(this, this.myEditorRow, this.myEditor);
        Container parent = this.getParent();
        int width = this.getBounds().width;
        if (parent instanceof JViewport) {
            width -= ((JScrollPane)parent.getParent()).getVerticalScrollBar().getWidth();
        }
        editor.applyAvailableWidth(width);
        this.myEditor.reset(rowToEdit);
        this.mySkipSelectionChange = true;
        try {
            this.getModel().insertRow(this.myEditorRow, new Object[]{editor});
        }
        finally {
            this.mySkipSelectionChange = false;
        }
        Rectangle bounds = this.getRowsBounds(rowToEdit, this.myEditorRow);
        if (bounds != null) {
            this.myRepresentationCallback.ensureVisible(bounds);
        }
        editor.expand();
        this.repaintRows(rowToEdit, this.getModel().getRowCount() - 1, false);
        this.editCellAt(this.myEditorRow, 0);
    }

    @NotNull
    public List<StdArrangementMatchRule> getRules() {
        if (this.getModel().getSize() <= 0) {
            List<StdArrangementMatchRule> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "getRules"));
            }
            return list;
        }
        ArrayList<StdArrangementMatchRule> result = new ArrayList<StdArrangementMatchRule>();
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            Object element = this.getModel().getElementAt(i);
            if (!(element instanceof StdArrangementMatchRule)) continue;
            result.add((StdArrangementMatchRule)element);
        }
        ArrayList<StdArrangementMatchRule> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "getRules"));
        }
        return arrayList;
    }

    public void repaintRows(int first, int last, boolean rowStructureChanged) {
        for (int i = first; i <= last; ++i) {
            if (rowStructureChanged) {
                this.myComponents.remove(i);
                continue;
            }
            this.setRowHeight(i, this.myRenderer.getRendererComponent((int)i).getPreferredSize().height);
        }
        this.getModel().fireTableRowsUpdated(first, last);
    }

    private Rectangle getRowsBounds(int first, int last) {
        Rectangle firstRect = this.getCellRect(first, 0, true);
        Rectangle lastRect = this.getCellRect(last, 0, true);
        return new Rectangle(firstRect.x, firstRect.y, lastRect.width, lastRect.y + lastRect.height - firstRect.y);
    }

    @NotNull
    public TIntArrayList getSelectedModelRows() {
        this.mySelectedRows.clear();
        int min = this.selectionModel.getMinSelectionIndex();
        if (min >= 0) {
            for (int i = this.selectionModel.getMaxSelectionIndex(); i >= min; --i) {
                if ((this.myEditorRow < 0 || i != this.myEditorRow - 1) && (i == this.myEditorRow || !this.selectionModel.isSelectedIndex(i))) continue;
                this.mySelectedRows.add(i);
            }
        } else if (this.myEditorRow > 0) {
            this.mySelectedRows.add(this.myEditorRow - 1);
        }
        TIntArrayList tIntArrayList = this.mySelectedRows;
        if (tIntArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "getSelectedModelRows"));
        }
        return tIntArrayList;
    }

    public int getRowByRenderer(@NotNull ArrangementListRowDecorator renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "getRowByRenderer"));
        }
        int max = this.getModel().getSize();
        for (int i = 0; i < max; ++i) {
            if (this.myComponents.get(i) != renderer) continue;
            return i;
        }
        return -1;
    }

    public int getEmptyRowHeight() {
        return this.myMinRowHeight;
    }

    @NotNull
    private JComponent adjustHeight(@NotNull JComponent component, int row) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "adjustHeight"));
        }
        int height = component.getPreferredSize().height;
        if (height < this.myMinRowHeight) {
            height = this.myMinRowHeight;
        }
        this.setRowHeight(row, height);
        JComponent jComponent = component;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "adjustHeight"));
        }
        return jComponent;
    }

    public static interface RepresentationCallback {
        public void ensureVisible(@NotNull Rectangle var1);
    }

    private class MyEditor
    extends AbstractTableCellEditor {
        private int myRow;

        private MyEditor() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof ArrangementEditorAware) {
                this.myRow = row;
                return ((ArrangementEditorAware)value).getComponent();
            }
            return null;
        }

        public Object getCellEditorValue() {
            return this.myRow < ArrangementMatchingRulesControl.this.getModel().getSize() ? ArrangementMatchingRulesControl.this.getModel().getElementAt(this.myRow) : null;
        }
    }

    private class MyRenderer
    implements TableCellRenderer {
        private MyRenderer() {
        }

        public Component getRendererComponent(int row) {
            return this.getTableCellRendererComponent((JTable)((Object)ArrangementMatchingRulesControl.this), ArrangementMatchingRulesControl.this.getModel().getElementAt(row), false, false, row, 0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (ArrangementMatchingRulesControl.this.isEditing() && ArrangementMatchingRulesControl.this.getEditingRow() == row) {
                return EMPTY_RENDERER;
            }
            if (value instanceof ArrangementRepresentationAware) {
                return ArrangementMatchingRulesControl.this.adjustHeight(((ArrangementRepresentationAware)value).getComponent(), row);
            }
            ArrangementListRowDecorator component = (ArrangementListRowDecorator)ArrangementMatchingRulesControl.this.myComponents.get(row);
            if (component == null) {
                if (!(value instanceof StdArrangementMatchRule)) {
                    return EMPTY_RENDERER;
                }
                StdArrangementMatchRule rule = (StdArrangementMatchRule)value;
                ArrangementUiComponent ruleComponent = ArrangementMatchingRulesControl.this.myFactory.getComponent(rule.getMatcher().getCondition(), rule, true);
                component = new ArrangementListRowDecorator(ruleComponent, ArrangementMatchingRulesControl.this);
                ArrangementMatchingRulesControl.this.myComponents.set(row, component);
            }
            component.setUnderMouse(ArrangementMatchingRulesControl.this.myRowUnderMouse == row);
            component.setRowIndex(ArrangementMatchingRulesControl.this.myEditorRow >= 0 && row > ArrangementMatchingRulesControl.this.myEditorRow ? row : row + 1);
            component.setSelected(ArrangementMatchingRulesControl.this.getSelectionModel().isSelectedIndex(row) || ArrangementMatchingRulesControl.this.myEditorRow >= 0 && row == ArrangementMatchingRulesControl.this.myEditorRow - 1);
            component.setBeingEdited(ArrangementMatchingRulesControl.this.myEditorRow >= 0 && ArrangementMatchingRulesControl.this.myEditorRow == row + 1);
            boolean showSortIcon = value instanceof StdArrangementMatchRule && StdArrangementTokens.Order.BY_NAME.equals((Object)((StdArrangementMatchRule)value).getOrderType());
            component.setShowSortIcon(showSortIcon);
            return component.getUiComponent();
        }
    }
}

