/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.animation;

import com.intellij.application.options.codeStyle.arrangement.animation.ArrangementAnimationPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class ArrangementAnimationManager
implements ArrangementAnimationPanel.Listener,
ActionListener {
    @NotNull
    private final Timer myTimer;
    @NotNull
    private final ArrangementAnimationPanel myAnimationPanel;
    @NotNull
    private final Callback myCallback;
    private boolean myFinished;

    public ArrangementAnimationManager(@NotNull ArrangementAnimationPanel panel, @NotNull Callback callback) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/arrangement/animation/ArrangementAnimationManager", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/application/options/codeStyle/arrangement/animation/ArrangementAnimationManager", "<init>"));
        }
        this.myTimer = new Timer(40, this);
        this.myAnimationPanel = panel;
        this.myCallback = callback;
        this.myAnimationPanel.setListener(this);
    }

    public void startAnimation() {
        this.myAnimationPanel.startAnimation();
        this.myCallback.onAnimationIteration(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.myTimer.stop();
        this.myFinished = !this.myAnimationPanel.nextIteration();
        this.myCallback.onAnimationIteration(this.myFinished);
    }

    @Override
    public void onPaint() {
        if (!this.myFinished && !this.myTimer.isRunning()) {
            this.myTimer.start();
        }
    }

    public static interface Callback {
        public void onAnimationIteration(boolean var1);
    }
}

