/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import java.util.ArrayList;

public class RearrangeCodeAction
extends AnAction {
    public void update(AnActionEvent e) {
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        boolean enabled = file != null && Rearranger.EXTENSION.forLanguage(file.getLanguage()) != null;
        e.getPresentation().setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return;
        }
        final Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor == null) {
            return;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = editor.getDocument();
        documentManager.commitDocument(document);
        final PsiFile file = documentManager.getPsiFile(document);
        if (file == null) {
            return;
        }
        final ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            ranges.add(TextRange.create((int)selectionModel.getSelectionStart(), (int)selectionModel.getSelectionEnd()));
        } else if (selectionModel.hasBlockSelection()) {
            int[] starts = selectionModel.getBlockSelectionStarts();
            int[] ends = selectionModel.getBlockSelectionEnds();
            for (int i = 0; i < starts.length; ++i) {
                ranges.add(TextRange.create((int)starts[i], (int)ends[i]));
            }
        } else {
            ranges.add(TextRange.create((int)0, (int)document.getTextLength()));
        }
        final ArrangementEngine engine = (ArrangementEngine)ServiceManager.getService((Project)project, ArrangementEngine.class);
        try {
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    engine.arrange(editor, file, ranges);
                }
            }, this.getTemplatePresentation().getText(), null);
        }
        finally {
            documentManager.commitDocument(document);
        }
    }
}

