/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.MultilanguageCodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.ui.ClickListener;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionTreeWithPreviewPanel
extends MultilanguageCodeStyleAbstractPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.CodeStyleSpacesPanel");
    private JTree myOptionsTree;
    private final ArrayList<BooleanOptionKey> myKeys = new ArrayList();
    protected final JPanel myPanel = new JPanel(new GridBagLayout());
    private boolean myShowAllStandardOptions = false;
    private Set<String> myAllowedOptions = new HashSet<String>();
    private MultiMap<String, CustomBooleanOptionInfo> myCustomOptions = new MultiMap();
    private boolean isFirstUpdate = true;
    private final Map<String, String> myRenamedFields = new THashMap();
    private final Map<String, String> myRemappedGroups = new THashMap();

    public OptionTreeWithPreviewPanel(CodeStyleSettings settings) {
        super(settings);
    }

    @Override
    protected void init() {
        super.init();
        this.initTables();
        this.myOptionsTree = this.createOptionsTree();
        this.myOptionsTree.setCellRenderer(new MyTreeCellRenderer());
        JBScrollPane scrollPane = new JBScrollPane(this.myOptionsTree){

            public Dimension getMinimumSize() {
                return super.getPreferredSize();
            }
        };
        this.myPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 8), 0, 0));
        JPanel previewPanel = OptionTreeWithPreviewPanel.createPreviewPanel();
        this.myPanel.add((Component)previewPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.installPreviewPanel(previewPanel);
        this.addPanelToWatch(this.myPanel);
        this.isFirstUpdate = false;
    }

    @Override
    protected void onLanguageChange(Language language) {
        this.updateOptionsTree();
    }

    public void showAllStandardOptions() {
        this.myShowAllStandardOptions = true;
        this.updateOptions(true, new String[0]);
    }

    public void showStandardOptions(String ... optionNames) {
        if (this.isFirstUpdate) {
            Collections.addAll(this.myAllowedOptions, optionNames);
        }
        this.updateOptions(false, optionNames);
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, String groupName, Object ... options) {
        this.showCustomOption(settingsClass, fieldName, title, groupName, null, null, options);
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, @Nullable String anchorFieldName, Object ... options) {
        if (this.isFirstUpdate) {
            this.myCustomOptions.putValue((Object)groupName, (Object)new CustomBooleanOptionInfo(settingsClass, fieldName, title, groupName, anchor, anchorFieldName));
        }
        this.enableOption(fieldName);
    }

    public void renameStandardOption(String fieldName, String newTitle) {
        if (this.isFirstUpdate) {
            this.myRenamedFields.put(fieldName, newTitle);
        }
    }

    protected void updateOptions(boolean showAllStandardOptions, String ... allowedOptions) {
        block0: for (BooleanOptionKey key : this.myKeys) {
            String fieldName = key.field.getName();
            if (key instanceof CustomBooleanOptionKey) {
                key.setEnabled(false);
                continue;
            }
            if (showAllStandardOptions) {
                key.setEnabled(true);
                continue;
            }
            key.setEnabled(false);
            for (String optionName : allowedOptions) {
                if (!fieldName.equals(optionName)) continue;
                key.setEnabled(true);
                continue block0;
            }
        }
    }

    protected void enableOption(String optionName) {
        for (BooleanOptionKey key : this.myKeys) {
            if (!key.field.getName().equals(optionName)) continue;
            key.setEnabled(true);
        }
    }

    protected void updateOptionsTree() {
        this.resetImpl(this.getSettings());
        this.myOptionsTree.repaint();
    }

    protected JTree createOptionsTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        String groupName = "";
        DefaultMutableTreeNode groupNode = null;
        List<BooleanOptionKey> result = this.sortOptions(this.orderByGroup(this.myKeys));
        for (BooleanOptionKey key : result) {
            String newGroupName = key.groupName;
            if (!newGroupName.equals(groupName) || groupNode == null) {
                groupName = newGroupName;
                groupNode = new DefaultMutableTreeNode(newGroupName);
                rootNode.add(groupNode);
            }
            if (!this.isOptionVisible(key)) continue;
            groupNode.add(new MyToggleTreeNode((Object)key, key.title));
        }
        DefaultTreeModel model = new DefaultTreeModel(rootNode);
        final Tree optionsTree = new Tree((TreeModel)model);
        new TreeSpeedSearch((JTree)optionsTree).setComparator(new SpeedSearchComparator(false));
        TreeUtil.installActions((JTree)optionsTree);
        optionsTree.setRootVisible(false);
        UIUtil.setLineStyleAngled((JTree)optionsTree);
        optionsTree.setShowsRootHandles(true);
        optionsTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!optionsTree.isEnabled()) {
                    return;
                }
                if (e.getKeyCode() == 32) {
                    TreePath treePath = optionsTree.getLeadSelectionPath();
                    OptionTreeWithPreviewPanel.this.selectCheckbox(treePath);
                    e.consume();
                }
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/OptionTreeWithPreviewPanel$3", "onClick"));
                }
                if (!optionsTree.isEnabled()) {
                    return false;
                }
                TreePath treePath = optionsTree.getPathForLocation(e.getX(), e.getY());
                OptionTreeWithPreviewPanel.this.selectCheckbox(treePath);
                return true;
            }
        }.installOn((Component)optionsTree);
        for (int row = 0; row < optionsTree.getRowCount(); ++row) {
            optionsTree.expandRow(row);
        }
        return optionsTree;
    }

    private List<BooleanOptionKey> orderByGroup(List<BooleanOptionKey> options) {
        final List<String> groupOrder = this.getGroupOrder(options);
        ArrayList<BooleanOptionKey> result = new ArrayList<BooleanOptionKey>(options.size());
        result.addAll(options);
        Collections.sort(result, new Comparator<BooleanOptionKey>(){

            @Override
            public int compare(BooleanOptionKey key1, BooleanOptionKey key2) {
                String group1 = key1.groupName;
                String group2 = key2.groupName;
                if (group1 == null) {
                    return group2 == null ? 0 : 1;
                }
                if (group2 == null) {
                    return -1;
                }
                Integer index1 = groupOrder.indexOf(group1);
                Integer index2 = groupOrder.indexOf(group2);
                if (index1 == -1 || index2 == -1) {
                    return group1.compareToIgnoreCase(group2);
                }
                return index1.compareTo(index2);
            }
        });
        return result;
    }

    protected List<String> getGroupOrder(List<BooleanOptionKey> options) {
        ArrayList<String> groupOrder = new ArrayList<String>();
        for (BooleanOptionKey each : options) {
            if (each.groupName == null || groupOrder.contains(each.groupName)) continue;
            groupOrder.add(each.groupName);
        }
        return groupOrder;
    }

    private void selectCheckbox(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        Object o = treePath.getLastPathComponent();
        if (o instanceof MyToggleTreeNode) {
            MyToggleTreeNode node = (MyToggleTreeNode)o;
            if (!node.isEnabled()) {
                return;
            }
            node.setSelected(!node.isSelected());
            int row = this.myOptionsTree.getRowForPath(treePath);
            this.myOptionsTree.repaint(this.myOptionsTree.getRowBounds(row));
            this.somethingChanged();
        }
    }

    protected abstract void initTables();

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        TreeModel treeModel = this.myOptionsTree.getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        this.resetNode(root, settings);
    }

    private void resetNode(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyToggleTreeNode) {
            this.resetMyTreeNode((MyToggleTreeNode)node, settings);
            return;
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child = node.getChildAt(j);
            this.resetNode(child, settings);
        }
    }

    private void resetMyTreeNode(MyToggleTreeNode childNode, CodeStyleSettings settings) {
        try {
            BooleanOptionKey key = (BooleanOptionKey)childNode.getKey();
            childNode.setSelected(key.getValue(settings));
            childNode.setEnabled(key.isEnabled());
        }
        catch (IllegalArgumentException e) {
            LOG.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        TreeModel treeModel = this.myOptionsTree.getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        OptionTreeWithPreviewPanel.applyNode(root, settings);
    }

    private static void applyNode(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyToggleTreeNode) {
            OptionTreeWithPreviewPanel.applyToggleNode((MyToggleTreeNode)node, settings);
            return;
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child = node.getChildAt(j);
            OptionTreeWithPreviewPanel.applyNode(child, settings);
        }
    }

    private static void applyToggleNode(MyToggleTreeNode childNode, CodeStyleSettings settings) {
        BooleanOptionKey key = (BooleanOptionKey)childNode.getKey();
        key.setValue(settings, childNode.isSelected() ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        TreeModel treeModel = this.myOptionsTree.getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        return OptionTreeWithPreviewPanel.isModified(root, settings);
    }

    private static boolean isModified(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyToggleTreeNode && OptionTreeWithPreviewPanel.isToggleNodeModified((MyToggleTreeNode)node, settings)) {
            return true;
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child = node.getChildAt(j);
            if (!OptionTreeWithPreviewPanel.isModified(child, settings)) continue;
            return true;
        }
        return false;
    }

    private static boolean isToggleNodeModified(MyToggleTreeNode childNode, CodeStyleSettings settings) {
        try {
            BooleanOptionKey key = (BooleanOptionKey)childNode.getKey();
            return childNode.isSelected() != key.getValue(settings);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    protected void initBooleanField(@NonNls String fieldName, String title, String groupName) {
        if (this.myShowAllStandardOptions || this.myAllowedOptions.contains(fieldName)) {
            this.doInitBooleanField(fieldName, title, groupName);
        }
    }

    private void doInitBooleanField(@NonNls String fieldName, String title, String groupName) {
        try {
            Class<CodeStyleSettings> styleSettingsClass = CodeStyleSettings.class;
            Field field = styleSettingsClass.getField(fieldName);
            String actualGroupName = this.getRemappedGroup(fieldName, groupName);
            BooleanOptionKey key = new BooleanOptionKey(fieldName, this.getRenamedTitle(actualGroupName, actualGroupName), this.getRenamedTitle(fieldName, title), field);
            this.myKeys.add(key);
        }
        catch (NoSuchFieldException e) {
            LOG.error((Throwable)e);
        }
        catch (SecurityException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void initCustomOptions(String groupName) {
        for (CustomBooleanOptionInfo option : this.myCustomOptions.get((Object)groupName)) {
            try {
                Field field = option.settingClass.getField(option.fieldName);
                this.myKeys.add(new CustomBooleanOptionKey<CustomCodeStyleSettings>(option.fieldName, this.getRenamedTitle(groupName, groupName), this.getRenamedTitle(option.fieldName, option.title), option.anchor, option.anchorFieldName, option.settingClass, field));
            }
            catch (NoSuchFieldException e) {
                LOG.error((Throwable)e);
            }
            catch (SecurityException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private String getRenamedTitle(String fieldName, String defaultTitle) {
        String renamed = this.myRenamedFields.get(fieldName);
        return renamed == null ? defaultTitle : renamed;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    public Set<String> processListOptions() {
        HashSet<String> result = new HashSet<String>();
        for (BooleanOptionKey key : this.myKeys) {
            result.add(key.title);
            if (key.groupName == null) continue;
            result.add(key.groupName);
        }
        result.addAll(this.myRenamedFields.values());
        for (String groupName : this.myCustomOptions.keySet()) {
            result.add(groupName);
            for (CustomBooleanOptionInfo trinity : this.myCustomOptions.get((Object)groupName)) {
                result.add(trinity.title);
            }
        }
        return result;
    }

    protected boolean shouldHideOptions() {
        return false;
    }

    private boolean isOptionVisible(BooleanOptionKey key) {
        if (!this.shouldHideOptions()) {
            return true;
        }
        if (this.myShowAllStandardOptions || this.myAllowedOptions.contains(key.getOptionName())) {
            return true;
        }
        for (CustomBooleanOptionInfo customOption : this.myCustomOptions.get((Object)key.groupName)) {
            if (!customOption.fieldName.equals(key.getOptionName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void moveStandardOption(String fieldName, String newGroup) {
        this.myRemappedGroups.put(fieldName, newGroup);
    }

    private String getRemappedGroup(String fieldName, String defaultName) {
        return this.myRemappedGroups.containsKey(fieldName) ? this.myRemappedGroups.get(fieldName) : defaultName;
    }

    private static class MyToggleTreeNode
    extends DefaultMutableTreeNode {
        private final Object myKey;
        private final String myText;
        private boolean isSelected;
        private boolean isEnabled = true;

        public MyToggleTreeNode(Object key, String text) {
            this.myKey = key;
            this.myText = text;
        }

        public Object getKey() {
            return this.myKey;
        }

        public String getText() {
            return this.myText;
        }

        public void setSelected(boolean val) {
            this.isSelected = val;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setEnabled(boolean val) {
            this.isEnabled = val;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }
    }

    private class CustomBooleanOptionKey<T extends CustomCodeStyleSettings>
    extends BooleanOptionKey {
        private final Class<T> mySettingsClass;

        public CustomBooleanOptionKey(String fieldName, String groupName, String title, CodeStyleSettingsCustomizable.OptionAnchor anchor, String anchorFieldName, Class<T> settingsClass, Field field) {
            super(fieldName, groupName, title, anchor, anchorFieldName, field);
            this.mySettingsClass = settingsClass;
        }

        @Override
        public void setValue(CodeStyleSettings settings, Boolean aBoolean) {
            CustomCodeStyleSettings customSettings = settings.getCustomSettings(this.mySettingsClass);
            try {
                this.field.set(customSettings, aBoolean);
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        public boolean getValue(CodeStyleSettings settings) throws IllegalAccessException {
            CustomCodeStyleSettings customSettings = settings.getCustomSettings(this.mySettingsClass);
            return this.field.getBoolean(customSettings);
        }
    }

    private static class CustomBooleanOptionInfo {
        @NotNull
        final Class<? extends CustomCodeStyleSettings> settingClass;
        @NotNull
        final String fieldName;
        @NotNull
        final String title;
        @Nullable
        final String groupName;
        @Nullable
        final CodeStyleSettingsCustomizable.OptionAnchor anchor;
        @Nullable
        final String anchorFieldName;

        private CustomBooleanOptionInfo(@NotNull Class<? extends CustomCodeStyleSettings> settingClass, @NotNull String fieldName, @NotNull String title, String groupName, CodeStyleSettingsCustomizable.OptionAnchor anchor, String anchorFieldName) {
            if (settingClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/codeStyle/OptionTreeWithPreviewPanel$CustomBooleanOptionInfo", "<init>"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/application/options/codeStyle/OptionTreeWithPreviewPanel$CustomBooleanOptionInfo", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/application/options/codeStyle/OptionTreeWithPreviewPanel$CustomBooleanOptionInfo", "<init>"));
            }
            this.settingClass = settingClass;
            this.fieldName = fieldName;
            this.title = title;
            this.groupName = groupName;
            this.anchor = anchor;
            this.anchorFieldName = anchorFieldName;
        }
    }

    private class BooleanOptionKey
    extends MultilanguageCodeStyleAbstractPanel.OrderedOption {
        final String groupName;
        String title;
        final Field field;
        private boolean enabled;

        public BooleanOptionKey(String fieldName, String groupName, String title, Field field) {
            this(fieldName, groupName, title, null, null, field);
        }

        public BooleanOptionKey(String fieldName, String groupName, @Nullable String title, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, String anchorFiledName, Field field) {
            super(fieldName, anchor, anchorFiledName);
            this.enabled = true;
            this.groupName = groupName;
            this.title = title;
            this.field = field;
        }

        public void setValue(CodeStyleSettings settings, Boolean aBoolean) {
            try {
                CommonCodeStyleSettings commonSettings = settings.getCommonSettings(OptionTreeWithPreviewPanel.this.getSelectedLanguage());
                this.field.set(commonSettings, aBoolean);
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
        }

        public boolean getValue(CodeStyleSettings settings) throws IllegalAccessException {
            CommonCodeStyleSettings commonSettings = settings.getCommonSettings(OptionTreeWithPreviewPanel.this.getSelectedLanguage());
            return this.field.getBoolean(commonSettings);
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    private static class MyTreeCellRenderer
    implements TreeCellRenderer {
        private final JLabel myLabel = new JLabel();
        private final JCheckBox myCheckBox = new JCheckBox();

        public MyTreeCellRenderer() {
            this.myCheckBox.setMargin(new Insets(0, 0, 0, 0));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof MyToggleTreeNode) {
                MyToggleTreeNode treeNode = (MyToggleTreeNode)value;
                JCheckBox button = this.myCheckBox;
                button.setText(treeNode.getText());
                button.setSelected(treeNode.isSelected);
                if (isSelected) {
                    button.setForeground(UIUtil.getTreeSelectionForeground());
                    button.setBackground(UIUtil.getTreeSelectionBackground());
                } else {
                    button.setForeground(UIUtil.getTreeTextForeground());
                    button.setBackground(UIUtil.getTreeTextBackground());
                }
                button.setEnabled(tree.isEnabled() && treeNode.isEnabled());
                return button;
            }
            this.myLabel.setText(value.toString());
            this.myLabel.setFont(this.myLabel.getFont().deriveFont(1));
            this.myLabel.setOpaque(true);
            if (isSelected) {
                this.myLabel.setForeground(UIUtil.getTreeSelectionForeground());
                this.myLabel.setBackground(UIUtil.getTreeSelectionBackground());
            } else {
                this.myLabel.setForeground(UIUtil.getTreeTextForeground());
                this.myLabel.setBackground(UIUtil.getTreeTextBackground());
            }
            this.myLabel.setEnabled(tree.isEnabled());
            return this.myLabel;
        }
    }
}

