/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.LanguageSelectorListener;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import org.jetbrains.annotations.Nullable;

public class LanguageSelector {
    private Language myLanguage;
    private final EventDispatcher<LanguageSelectorListener> myDispatcher = EventDispatcher.create(LanguageSelectorListener.class);
    private final Language[] myLanguages = LanguageCodeStyleSettingsProvider.getLanguagesWithCodeStyleSettings();

    @Nullable
    public Language getLanguage() {
        if (this.myLanguage == null && this.myLanguages.length > 0) {
            this.myLanguage = this.myLanguages[0];
        }
        return this.myLanguage;
    }

    public void setLanguage(Language language) {
        this.myLanguage = language;
        this.notifyListeners(language);
    }

    public void addListener(LanguageSelectorListener l) {
        this.myDispatcher.addListener((EventListener)l);
    }

    public void removeListener(LanguageSelectorListener l) {
        this.myDispatcher.removeListener((EventListener)l);
    }

    private void notifyListeners(Language lang) {
        ((LanguageSelectorListener)this.myDispatcher.getMulticaster()).languageChanged(lang);
    }
}

