/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.application.options.codeStyle.CodeStyleBlankLinesPanel;
import com.intellij.application.options.codeStyle.CodeStyleSpacesPanel;
import com.intellij.application.options.codeStyle.LanguageSelector;
import com.intellij.application.options.codeStyle.WrappingAndBracesPanel;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class CommonCodeStyleSettingsConfigurable
extends CodeStyleAbstractConfigurable {
    public CommonCodeStyleSettingsConfigurable(@NotNull CodeStyleSettings settings, CodeStyleSettings cloneSettings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/application/options/CommonCodeStyleSettingsConfigurable", "<init>"));
        }
        super(settings, cloneSettings, "A");
    }

    @Override
    protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings) {
        return new MyCodeStylePanel(this.getCurrentSettings(), settings);
    }

    public String getHelpTopic() {
        return null;
    }

    private static class MyCodeStylePanel
    extends TabbedLanguageCodeStylePanel {
        private CodeStyleSpacesPanel mySpacesPanel;
        private WrappingAndBracesPanel myWrappingAndBracesPanel;
        private CodeStyleBlankLinesPanel myBlankLinesPanel;

        protected MyCodeStylePanel(CodeStyleSettings currentSettings, CodeStyleSettings settings) {
            super(null, currentSettings, settings);
        }

        @Override
        protected void initTabs(CodeStyleSettings settings) {
            this.mySpacesPanel = new CodeStyleSpacesPanel(settings);
            this.myWrappingAndBracesPanel = new WrappingAndBracesPanel(settings);
            this.myBlankLinesPanel = new CodeStyleBlankLinesPanel(settings);
            this.addTab(this.mySpacesPanel);
            this.addTab(this.myWrappingAndBracesPanel);
            this.addTab(this.myBlankLinesPanel);
        }

        @Override
        public void setLanguageSelector(LanguageSelector langSelector) {
            this.mySpacesPanel.setLanguageSelector(langSelector);
            this.myWrappingAndBracesPanel.setLanguageSelector(langSelector);
            this.myBlankLinesPanel.setLanguageSelector(langSelector);
        }

        @Override
        public boolean setPanelLanguage(Language language) {
            this.mySpacesPanel.setPanelLanguage(language);
            this.myWrappingAndBracesPanel.setPanelLanguage(language);
            this.myBlankLinesPanel.setPanelLanguage(language);
            return true;
        }
    }
}

