/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.GroupBasedTestClassFilter;
import com.intellij.PatternListTestClassFilter;
import com.intellij.TestClassesFilter;
import com.intellij.idea.Bombed;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TestRunnerUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCaseLoader {
    private static final String TARGET_TEST_GROUP = "idea.test.group";
    private static final String TARGET_TEST_PATTERNS = "idea.test.patterns";
    public static final String PERFORMANCE_TESTS_ONLY_FLAG = "idea.performance.tests";
    public static final String SKIP_COMMUNITY_TESTS = "idea.skip.community.tests";
    private final List<Class> myClassList = new ArrayList<Class>();
    private Class myFirstTestClass;
    private Class myLastTestClass;
    private final TestClassesFilter myTestClassesFilter;
    private final boolean myIsPerformanceTestsRun;
    private static final List<String> ourRankList = TestCaseLoader.getTeamCityRankList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestCaseLoader(String classFilterName, boolean isPerformanceTestsRun) {
        this.myIsPerformanceTestsRun = isPerformanceTestsRun;
        String patterns = System.getProperty(TARGET_TEST_PATTERNS);
        if (patterns != null) {
            this.myTestClassesFilter = new PatternListTestClassFilter(StringUtil.split((String)patterns, (String)";"));
            System.out.println("Using patterns: [" + patterns + "]");
        } else {
            URL excludedStream;
            URL uRL = excludedStream = StringUtil.isEmpty((String)classFilterName) ? null : this.getClass().getClassLoader().getResource(classFilterName);
            if (excludedStream != null) {
                TestClassesFilter filter;
                try {
                    String testGroupName = System.getProperty(TARGET_TEST_GROUP, "").trim();
                    InputStreamReader reader = new InputStreamReader(excludedStream.openStream());
                    try {
                        filter = GroupBasedTestClassFilter.createOn(reader, testGroupName);
                        System.out.println("Using test group: [" + testGroupName + "]");
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    filter = TestClassesFilter.ALL_CLASSES;
                    System.out.println("Using all classes");
                }
                this.myTestClassesFilter = filter;
            } else {
                this.myTestClassesFilter = TestClassesFilter.ALL_CLASSES;
                System.out.println("Using all classes");
            }
        }
    }

    void addClassIfTestCase(Class testCaseClass) {
        if (this.shouldAddTestCase(testCaseClass, true) && testCaseClass != this.myFirstTestClass && testCaseClass != this.myLastTestClass && PlatformTestUtil.canRunTest(testCaseClass)) {
            this.myClassList.add(testCaseClass);
        }
    }

    void addFirstTest(Class aClass) {
        assert (this.myFirstTestClass == null) : "already added: " + aClass;
        assert (this.shouldAddTestCase(aClass, false)) : "not a test: " + aClass;
        this.myFirstTestClass = aClass;
    }

    void addLastTest(Class aClass) {
        assert (this.myLastTestClass == null) : "already added: " + aClass;
        assert (this.shouldAddTestCase(aClass, false)) : "not a test: " + aClass;
        this.myLastTestClass = aClass;
    }

    private boolean shouldAddTestCase(Class<?> testCaseClass, boolean testForExcluded) {
        if ((testCaseClass.getModifiers() & 0x400) != 0) {
            return false;
        }
        if (testForExcluded && this.shouldExcludeTestClass(testCaseClass)) {
            return false;
        }
        if (TestCase.class.isAssignableFrom(testCaseClass) || TestSuite.class.isAssignableFrom(testCaseClass)) {
            return true;
        }
        try {
            Method suiteMethod = testCaseClass.getMethod("suite", new Class[0]);
            if (Test.class.isAssignableFrom(suiteMethod.getReturnType()) && (suiteMethod.getModifiers() & 8) != 0) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return TestRunnerUtil.isJUnit4TestClass(testCaseClass);
    }

    private boolean shouldExcludeTestClass(Class testCaseClass) {
        String className = testCaseClass.getName();
        if (className.toLowerCase().contains("performance") && !this.myIsPerformanceTestsRun) {
            return true;
        }
        return !this.myTestClassesFilter.matches(className) || TestCaseLoader.isBombed(testCaseClass);
    }

    public static boolean isBombed(Method method) {
        Bombed bombedAnnotation = method.getAnnotation(Bombed.class);
        if (bombedAnnotation == null) {
            return false;
        }
        if (PlatformTestUtil.isRotten(bombedAnnotation)) {
            String message = "Disarm the stale bomb for '" + method + "' in class '" + method.getDeclaringClass() + "'";
            System.err.println(message);
        }
        return !PlatformTestUtil.bombExplodes(bombedAnnotation);
    }

    public static boolean isBombed(Class<?> testCaseClass) {
        Bombed bombedAnnotation = testCaseClass.getAnnotation(Bombed.class);
        if (bombedAnnotation == null) {
            return false;
        }
        if (PlatformTestUtil.isRotten(bombedAnnotation)) {
            String message = "Disarm the stale bomb for '" + testCaseClass + "'";
            System.err.println(message);
        }
        return !PlatformTestUtil.bombExplodes(bombedAnnotation);
    }

    public void loadTestCases(Collection<String> classNamesIterator) {
        for (String className : classNamesIterator) {
            try {
                Class<?> candidateClass = Class.forName(className);
                this.addClassIfTestCase(candidateClass);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Cannot load class " + className + ": " + e.getMessage());
                e.printStackTrace();
            }
            catch (ExceptionInInitializerError e) {
                System.err.println("Cannot initialize class " + className + ": " + e.getException().getMessage());
                e.printStackTrace();
                System.err.println("Root cause:");
                e.getException().printStackTrace();
            }
            catch (LinkageError e) {
                System.err.println("Cannot load class " + className + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getTeamCityRankList() {
        ArrayList<String> arrayList;
        String filePath = System.getProperty("teamcity.tests.recentlyFailedTests.file", null);
        if (filePath == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        try {
            String className;
            while ((className = reader.readLine()) != null) {
                result.add(className);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                return Collections.emptyList();
            }
        }
        reader.close();
        return arrayList;
    }

    private int getRank(Class aClass) {
        String name = aClass.getName();
        if (aClass == this.myFirstTestClass) {
            return -1;
        }
        if (aClass == this.myLastTestClass) {
            return this.myClassList.size() + ourRankList.size();
        }
        int i = ourRankList.indexOf(name);
        if (i != -1) {
            return i;
        }
        return ourRankList.size();
    }

    public List<Class> getClasses() {
        ArrayList<Class> result = new ArrayList<Class>(this.myClassList.size());
        if (this.myFirstTestClass != null) {
            result.add(this.myFirstTestClass);
        }
        result.addAll(this.myClassList);
        if (this.myLastTestClass != null) {
            result.add(this.myLastTestClass);
        }
        if (!ourRankList.isEmpty()) {
            Collections.sort(result, new Comparator<Class>(){

                @Override
                public int compare(Class o1, Class o2) {
                    return TestCaseLoader.this.getRank(o1) - TestCaseLoader.this.getRank(o2);
                }
            });
        }
        return result;
    }

    public void clearClasses() {
        this.myClassList.clear();
    }
}

