/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.ClassFinder;
import com.intellij.TestCaseLoader;
import com.intellij.TestRecorder;
import com.intellij.idea.RecordExecution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.tests.ExternalClasspathClassLoader;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;

public class TestAll
implements Test {
    private final TestCaseLoader myTestCaseLoader;
    private long myStartTime = 0L;
    private boolean myInterruptedByOutOfTime = false;
    private long myLastTestStartTime = 0L;
    private String myLastTestClass;
    private int myRunTests = -1;
    private boolean mySavingMemorySnapshot;
    private static final int SAVE_MEMORY_SNAPSHOT = 1;
    private static final int START_GUARD = 2;
    private static final int RUN_GC = 4;
    private static final int CHECK_MEMORY = 8;
    private static final int FILTER_CLASSES = 16;
    public static int ourMode;
    private static final boolean PERFORMANCE_TESTS_ONLY;
    private int myLastTestTestMethodCount = 0;
    public static final int MAX_FAILURE_TEST_COUNT = 150;
    private TestRecorder myTestRecorder;
    private static final Filter PERFORMANCE_ONLY;
    private static final Filter NO_PERFORMANCE;

    public int countTestCases() {
        List<Class> classes = this.myTestCaseLoader.getClasses();
        int count = 0;
        for (Class aClass : classes) {
            Class testCaseClass = aClass;
            Test test = TestAll.getTest(testCaseClass);
            if (test == null) continue;
            count += test.countTestCases();
        }
        return count;
    }

    private void beforeFirstTest() {
        if ((ourMode & 2) != 0) {
            Thread timeAndMemoryGuard = new Thread(){

                @Override
                public void run() {
                    TestAll.log("Starting Time and Memory Guard");
                    while (true) {
                        try {
                            Thread currentThread;
                            while (true) {
                                try {
                                    Thread.sleep(10000L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                if (TestAll.this.myLastTestStartTime == 0L) continue;
                                long currTime = System.currentTimeMillis();
                                long secondsSpent = (currTime - TestAll.this.myLastTestStartTime) / 1000L;
                                currentThread = TestAll.getCurrentThread();
                                if (TestAll.this.mySavingMemorySnapshot || secondsSpent <= PlatformTestCase.ourTestTime * (long)TestAll.this.myLastTestTestMethodCount) continue;
                                UsefulTestCase.printThreadDump();
                                TestAll.log("Interrupting current Test (out of time)! Test class: " + TestAll.this.myLastTestClass + " Seconds spent = " + secondsSpent);
                                TestAll.this.myInterruptedByOutOfTime = true;
                                if (currentThread != null) break;
                            }
                            currentThread.interrupt();
                            if (currentThread.isInterrupted()) break;
                            currentThread.stop();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                    TestAll.log("Time and Memory Guard finished.");
                }
            };
            timeAndMemoryGuard.setDaemon(true);
            timeAndMemoryGuard.start();
        }
        this.myStartTime = System.currentTimeMillis();
    }

    private static Thread getCurrentThread() {
        if (PlatformTestCase.ourTestThread != null) {
            return PlatformTestCase.ourTestThread;
        }
        return LightPlatformTestCase.ourTestThread;
    }

    private void addErrorMessage(TestResult testResult, String message) {
        String processedTestsMessage = this.myRunTests <= 0 ? "None of tests was run" : this.myRunTests + " tests processed";
        try {
            testResult.startTest((Test)this);
            testResult.addError((Test)this, new Throwable(processedTestsMessage + " before: " + message));
            testResult.endTest((Test)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TestResult testResult) {
        this.loadTestRecorder();
        List<Class> classes = this.myTestCaseLoader.getClasses();
        int totalTests = classes.size();
        for (Class aClass : classes) {
            boolean recording = false;
            if (this.myTestRecorder != null && this.shouldRecord(aClass)) {
                this.myTestRecorder.beginRecording(aClass, aClass.getAnnotation(RecordExecution.class));
                recording = true;
            }
            try {
                this.runNextTest(testResult, totalTests, aClass);
            }
            finally {
                if (recording) {
                    this.myTestRecorder.endRecording();
                }
            }
            if (!testResult.shouldStop()) continue;
            break;
        }
        TestAll.tryGc(10);
    }

    private boolean shouldRecord(Class aClass) {
        return aClass.getAnnotation(RecordExecution.class) != null;
    }

    private void loadTestRecorder() {
        String recorderClassName = System.getProperty("test.recorder.class");
        if (recorderClassName != null) {
            try {
                Class<?> recorderClass = Class.forName(recorderClassName);
                this.myTestRecorder = (TestRecorder)recorderClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                System.out.println("CNFE loading test recorder class: " + e);
            }
            catch (InstantiationException e) {
                System.out.println("InstantiationException loading test recorder class: " + e);
            }
            catch (IllegalAccessException e) {
                System.out.println("IAE loading test recorder class: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNextTest(TestResult testResult, int totalTests, Class testCaseClass) {
        ++this.myRunTests;
        if (!this.checkAvaliableMemory(35, testResult)) {
            testResult.stop();
            return;
        }
        if (testResult.errorCount() + testResult.failureCount() > 150) {
            this.addErrorMessage(testResult, "Too many errors. Tests stopped. Total " + this.myRunTests + " of " + totalTests + " tests run");
            testResult.stop();
            return;
        }
        if (this.myStartTime == 0L) {
            boolean ourClassLoader = this.getClass().getClassLoader().getClass().getName().startsWith("com.intellij.");
            if (!ourClassLoader) {
                this.beforeFirstTest();
            }
        } else if (this.myInterruptedByOutOfTime) {
            this.addErrorMessage(testResult, "Current Test Interrupted: OUT OF TIME! Class = " + this.myLastTestClass + " Total " + this.myRunTests + " of " + totalTests + " tests run");
            testResult.stop();
            return;
        }
        TestAll.log("\nRunning " + testCaseClass.getName());
        Test test = TestAll.getTest(testCaseClass);
        if (test == null) {
            return;
        }
        this.myLastTestClass = null;
        this.myLastTestClass = testCaseClass.getName();
        this.myLastTestStartTime = System.currentTimeMillis();
        this.myLastTestTestMethodCount = test.countTestCases();
        try {
            test.run(testResult);
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError && (ourMode & 1) != 0) {
                try {
                    this.mySavingMemorySnapshot = true;
                    TestAll.log("OutOfMemoryError detected. Saving memory snapshot started");
                }
                finally {
                    TestAll.log("Saving memory snapshot finished");
                    this.mySavingMemorySnapshot = false;
                }
            }
            testResult.addError(test, t);
        }
    }

    private boolean checkAvaliableMemory(int neededMemory, TestResult testResult) {
        if ((ourMode & 8) == 0) {
            return true;
        }
        boolean possibleOutOfMemoryError = TestAll.possibleOutOfMemory(neededMemory);
        if (possibleOutOfMemoryError) {
            TestAll.tryGc(5);
            possibleOutOfMemoryError = TestAll.possibleOutOfMemory(neededMemory);
            if (possibleOutOfMemoryError) {
                TestAll.log("OutOfMemoryError: dumping memory");
                Runtime runtime = Runtime.getRuntime();
                long total = runtime.totalMemory();
                long free = runtime.freeMemory();
                String errorMessage = "Too much memory used. Total: " + total + " free: " + free + " used: " + (total - free) + "\n";
                this.addErrorMessage(testResult, errorMessage);
            }
        }
        return !possibleOutOfMemoryError;
    }

    private static boolean possibleOutOfMemory(int neededMemory) {
        long meg;
        long needed;
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long realFreeMemory = runtime.freeMemory() + (maxMemory - runtime.totalMemory());
        return realFreeMemory < (needed = (long)neededMemory * (meg = 0x100000L));
    }

    private static boolean isPerformanceTestsRun() {
        return PERFORMANCE_TESTS_ONLY;
    }

    @Nullable
    private static Test getTest(final Class testCaseClass) {
        block8: {
            if ((testCaseClass.getModifiers() & 1) == 0) {
                return null;
            }
            Method suiteMethod = TestAll.safeFindMethod(testCaseClass, "suite");
            if (suiteMethod != null && !TestAll.isPerformanceTestsRun()) {
                try {
                    return (Test)suiteMethod.invoke(null, (Object[])ArrayUtil.EMPTY_CLASS_ARRAY);
                }
                catch (Exception e) {
                    System.err.println("Failed to execute suite ()");
                    e.printStackTrace();
                    break block8;
                }
            }
            if (TestRunnerUtil.isJUnit4TestClass(testCaseClass)) {
                JUnit4TestAdapter adapter = new JUnit4TestAdapter(testCaseClass);
                if (!TestAll.hasPerformance(testCaseClass.getSimpleName()) || !TestAll.isPerformanceTestsRun()) {
                    try {
                        adapter.filter(TestAll.isPerformanceTestsRun() ? PERFORMANCE_ONLY : NO_PERFORMANCE);
                    }
                    catch (NoTestsRemainException e1) {
                        // empty catch block
                    }
                }
                return adapter;
            }
            final int[] testsCount = new int[]{0};
            TestSuite suite = new TestSuite(testCaseClass){

                public void addTest(Test test) {
                    if (!(test instanceof TestCase)) {
                        testsCount[0] = testsCount[0] + 1;
                        super.addTest(test);
                    } else {
                        String name = ((TestCase)test).getName();
                        if ("warning".equals(name)) {
                            return;
                        }
                        if (TestAll.isPerformanceTestsRun() ^ (TestAll.hasPerformance(name) || TestAll.hasPerformance(testCaseClass.getSimpleName()))) {
                            return;
                        }
                        Method method = this.findTestMethod((TestCase)test);
                        if (method == null || !TestCaseLoader.isBombed(method)) {
                            testsCount[0] = testsCount[0] + 1;
                            super.addTest(test);
                        }
                    }
                }

                @Nullable
                private Method findTestMethod(TestCase testCase) {
                    return TestAll.safeFindMethod(testCase.getClass(), testCase.getName());
                }
            };
            return testsCount[0] > 0 ? suite : null;
        }
        return null;
    }

    private static boolean hasPerformance(String name) {
        return name.toLowerCase().contains("performance");
    }

    @Nullable
    private static Method safeFindMethod(Class klass, String name) {
        try {
            return klass.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Set<String> normalizePaths(String[] array) {
        LinkedHashSet<String> answer = new LinkedHashSet<String>(array.length);
        for (String path : array) {
            answer.add(path.replace('\\', '/'));
        }
        return answer;
    }

    public static String[] getClassRoots() {
        String testRoots = System.getProperty("test.roots");
        if (testRoots != null) {
            System.out.println("Collecting tests from roots specified by test.roots property: " + testRoots);
            return testRoots.split(";");
        }
        Object[] roots = ExternalClasspathClassLoader.getRoots();
        if (roots != null) {
            if (Comparing.equal((String)System.getProperty("idea.skip.community.tests"), (String)"true")) {
                System.out.println("Skipping community tests");
                Set<String> set = TestAll.normalizePaths((String[])roots);
                set.removeAll(TestAll.normalizePaths(ExternalClasspathClassLoader.getExcludeRoots()));
                roots = set.toArray(new String[set.size()]);
            }
            System.out.println("Collecting tests from roots specified by classpath.file property: " + Arrays.toString(roots));
            return roots;
        }
        ClassLoader loader = TestAll.class.getClassLoader();
        if (loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            Object[] classLoaderRoots = new String[urls.length];
            for (int i = 0; i < urls.length; ++i) {
                classLoaderRoots[i] = VfsUtil.urlToPath((String)VfsUtil.convertFromUrl((URL)urls[i]));
            }
            System.out.println("Collecting tests from classloader: " + Arrays.toString(classLoaderRoots));
            return classLoaderRoots;
        }
        return System.getProperty("java.class.path").split(File.pathSeparator);
    }

    public TestAll(String packageRoot) throws Throwable {
        this(packageRoot, TestAll.getClassRoots());
    }

    public TestAll(String packageRoot, String ... classRoots) throws IOException, ClassNotFoundException {
        String classFilterName = "tests/testGroups.properties";
        if (Boolean.parseBoolean(System.getProperty("idea.ignore.predefined.groups")) || (ourMode & 0x10) == 0) {
            classFilterName = "";
        }
        this.myTestCaseLoader = new TestCaseLoader(classFilterName, TestAll.isPerformanceTestsRun());
        this.myTestCaseLoader.addFirstTest(Class.forName("_FirstInSuiteTest"));
        this.myTestCaseLoader.addLastTest(Class.forName("_LastInSuiteTest"));
        TestAll.fillTestCases(this.myTestCaseLoader, packageRoot, classRoots);
    }

    public static void fillTestCases(TestCaseLoader testCaseLoader, String packageRoot, String ... classRoots) throws IOException {
        for (String classRoot : classRoots) {
            int oldCount = testCaseLoader.getClasses().size();
            ClassFinder classFinder = new ClassFinder(new File(FileUtil.toSystemDependentName((String)classRoot)), packageRoot);
            testCaseLoader.loadTestCases(classFinder.getClasses());
            int newCount = testCaseLoader.getClasses().size();
            if (newCount == oldCount) continue;
            System.out.println("Loaded " + (newCount - oldCount) + " tests from class root " + classRoot);
        }
        if (testCaseLoader.getClasses().size() == 1) {
            testCaseLoader.clearClasses();
        }
        TestAll.log("Number of test classes found: " + testCaseLoader.getClasses().size());
    }

    private static void log(String message) {
        TeamCityLogger.info(message);
    }

    public static void tryGc(int times) {
        if ((ourMode & 4) == 0) {
            return;
        }
        for (int qqq = 1; qqq < times; ++qqq) {
            try {
                Thread.sleep(qqq * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.gc();
            TestAll.log("Runtime.getRuntime().totalMemory() = " + Runtime.getRuntime().totalMemory());
        }
    }

    static {
        Logger.setFactory(TestLoggerFactory.class);
        ourMode = 17;
        PERFORMANCE_TESTS_ONLY = System.getProperty("idea.performance.tests") != null;
        PERFORMANCE_ONLY = new Filter(){

            public boolean shouldRun(Description description) {
                String className = description.getClassName();
                String methodName = description.getMethodName();
                return className != null && TestAll.hasPerformance(className) || methodName != null && TestAll.hasPerformance(methodName);
            }

            public String describe() {
                return "Performance Tests Only";
            }
        };
        NO_PERFORMANCE = new Filter(){

            public boolean shouldRun(Description description) {
                return !PERFORMANCE_ONLY.shouldRun(description);
            }

            public String describe() {
                return "All Except Performance";
            }
        };
    }
}

