/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView;

import java.util.Collection;
import java.util.Collections;
import org.intellij.plugins.xpathView.util.Copyable;
import org.intellij.plugins.xpathView.util.Namespace;
import org.intellij.plugins.xpathView.util.Variable;
import org.jetbrains.annotations.NotNull;

public final class HistoryElement
implements Copyable<HistoryElement> {
    public static final HistoryElement EMPTY = new HistoryElement();
    public final String expression;
    public final Collection<Variable> variables;
    public final Collection<Namespace> namespaces;

    public HistoryElement(String expression, @NotNull Collection<Variable> variables, @NotNull Collection<Namespace> namespaces) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/plugins/xpathView/HistoryElement", "<init>"));
        }
        if (namespaces == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/intellij/plugins/xpathView/HistoryElement", "<init>"));
        }
        this.expression = expression;
        this.variables = Collections.unmodifiableCollection(variables);
        this.namespaces = Collections.unmodifiableCollection(namespaces);
    }

    private HistoryElement() {
        this.expression = null;
        this.variables = Collections.emptySet();
        this.namespaces = Collections.emptySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryElement that = (HistoryElement)o;
        return !(this.expression == null ? that.expression != null : !this.expression.equals(that.expression));
    }

    public int hashCode() {
        return this.expression != null ? this.expression.hashCode() : 0;
    }

    @Override
    public HistoryElement copy() {
        return new HistoryElement(this.expression, Copyable.Util.copy(this.variables), Copyable.Util.copy(this.namespaces));
    }

    public HistoryElement changeContext(Collection<Namespace> namespaces, Collection<Variable> variables) {
        return new HistoryElement(this.expression, variables, namespaces);
    }

    public HistoryElement changeExpression(String expression) {
        return new HistoryElement(expression, this.variables, this.namespaces);
    }
}

