/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.xslt.context.XsltNamespaceContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QNameUtil {
    public static final QName NONE = null;
    public static final QName UNRESOLVED = new ExtendedQName("null");
    public static final QName ANY = new ExtendedQName("*");

    private QNameUtil() {
    }

    public static boolean equal(QName q1, QName q2) {
        if (q1 == UNRESOLVED || q2 == UNRESOLVED) {
            return false;
        }
        if (q1 == ANY || q2 == ANY) {
            return true;
        }
        if (Comparing.equal((Object)q1, (Object)q2)) {
            return true;
        }
        if (q1 instanceof ExtendedQName) {
            return q1.getNamespaceURI().equals(q2.getNamespaceURI());
        }
        if (q2 instanceof ExtendedQName) {
            return q2.getNamespaceURI().equals(q1.getNamespaceURI());
        }
        return false;
    }

    public static QName createAnyLocalName(String namespace) {
        return new ExtendedQName(namespace);
    }

    private static boolean isNamespaceDeclared(@Nullable XmlTag tag, String namespace) {
        if (tag == null) {
            return false;
        }
        if (tag.getLocalNamespaceDeclarations().containsValue(namespace)) {
            return true;
        }
        return QNameUtil.isNamespaceDeclared(tag.getParentTag(), namespace);
    }

    public static QName createQName(@NotNull String qname, @NotNull PsiElement context) {
        if (qname == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/util/QNameUtil", "createQName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/lang/xpath/xslt/util/QNameUtil", "createQName"));
        }
        String[] strings = qname.split(":", 2);
        if (strings.length == 1) {
            return new QName(null, qname);
        }
        XmlElement ctx = (XmlElement)PsiTreeUtil.getParentOfType((PsiElement)context, XmlElement.class, (boolean)false);
        if (ctx == null) {
            return UNRESOLVED;
        }
        String uri = XsltNamespaceContext.getNamespaceUriStatic(strings[0], ctx);
        if (uri == null) {
            return UNRESOLVED;
        }
        return new QName(uri, strings[1], strings[0]);
    }

    public static QName createQName(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/util/QNameUtil", "createQName"));
        }
        String name = attribute.getName();
        if (name.indexOf(58) != -1) {
            return new QName(attribute.getNamespace(), attribute.getLocalName());
        }
        return new QName(null, attribute.getLocalName());
    }

    public static QName createQName(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/util/QNameUtil", "createQName"));
        }
        if (QNameUtil.isNamespaceDeclared(tag, tag.getNamespace())) {
            return new QName(tag.getNamespace(), tag.getLocalName(), tag.getNamespacePrefix());
        }
        return new QName(null, tag.getLocalName());
    }

    static final class ExtendedQName
    extends QName {
        ExtendedQName(String namespace) {
            super(namespace, "*");
        }
    }
}

