/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.run;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.diagnostic.logging.DebuggerLogConsoleManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.associations.FileAssociationsManager;
import org.intellij.lang.xpath.xslt.run.CustomRegexpFilter;
import org.intellij.lang.xpath.xslt.run.HighlightingOutputConsole;
import org.intellij.lang.xpath.xslt.run.OutputTabAdapter;
import org.intellij.lang.xpath.xslt.run.XsltCommandLineState;
import org.intellij.lang.xpath.xslt.run.XsltRunSettingsEditor;
import org.intellij.lang.xpath.xslt.run.XsltRunnerExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XsltRunConfiguration
extends LocatableConfigurationBase
implements ModuleRunConfiguration,
RunConfigurationWithSuppressedDefaultDebugAction {
    private static final String NAME = "XSLT Configuration";
    private static final String STRICT_FILE_PATH_EXPR = "(file\\://?(?:/?\\p{Alpha}\\:)?(?:/\\p{Alpha}\\:)?[^:]+)";
    private static final String RELAXED_FILE_PATH_EXPR = "((?:file\\://?)?(?:/?\\p{Alpha}\\:)?(?:/\\p{Alpha}\\:)?[^:]+)";
    private static final String LOG_TAG = "(?:\\[[\\w ]+\\]\\:? +)?";
    private List<Pair<String, String>> myParameters = new ArrayList<Pair<String, String>>();
    @Nullable
    private VirtualFilePointer myXsltFile = null;
    @Nullable
    private VirtualFilePointer myXmlInputFile = null;
    @NotNull
    private OutputType myOutputType = OutputType.CONSOLE;
    private boolean mySaveToFile = false;
    @NotNull
    private JdkChoice myJdkChoice = JdkChoice.FROM_MODULE;
    @Nullable
    private FileType myFileType = StdFileTypes.XML;
    public String myOutputFile;
    public boolean myOpenOutputFile;
    public boolean myOpenInBrowser;
    public boolean mySmartErrorHandling = true;
    @Deprecated
    public int myRunnerPort = 34873;
    public String myVmArguments;
    public String myWorkingDirectory;
    public String myModule;
    public String myJdk;
    private String mySuggestedName = null;
    private static Sdk ourDefaultSdk;

    public XsltRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory, NAME);
    }

    @NotNull
    public SettingsEditor<XsltRunConfiguration> getConfigurationEditor() {
        XsltRunSettingsEditor xsltRunSettingsEditor = new XsltRunSettingsEditor(this.getProject());
        if (xsltRunSettingsEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/run/XsltRunConfiguration", "getConfigurationEditor"));
        }
        return xsltRunSettingsEditor;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment executionEnvironment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/run/XsltRunConfiguration", "getState"));
        }
        if (executionEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/lang/xpath/xslt/run/XsltRunConfiguration", "getState"));
        }
        if (this.myXsltFile == null) {
            throw new ExecutionException("No XSLT file selected");
        }
        VirtualFile baseFile = this.myXsltFile.getFile();
        XsltCommandLineState state = new XsltCommandLineState(this, executionEnvironment);
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject());
        builder.addFilter((Filter)new CustomRegexpFilter(this.getProject(), "$FILE_PATH$\\:(?:(?: line )?$LINE$)?(?:\\:(?: column )?$COLUMN$)?", baseFile, STRICT_FILE_PATH_EXPR));
        builder.addFilter((Filter)new CustomRegexpFilter(this.getProject(), "(?:\\[[\\w ]+\\]\\:? +)?$FILE_PATH$\\:(?:(?: line )?$LINE$)?(?:\\:(?: column )?$COLUMN$)?", baseFile, RELAXED_FILE_PATH_EXPR));
        builder.addFilter((Filter)new CustomRegexpFilter(this.getProject(), "$FILE_PATH$; \\w+ #$LINE$(?:; \\w+ #$COLUMN$)?", baseFile, STRICT_FILE_PATH_EXPR));
        builder.addFilter((Filter)new CustomRegexpFilter(this.getProject(), "(?:\\[[\\w ]+\\]\\:? +)?$FILE_PATH$; \\w+ #$LINE$(?:; \\w+ #$COLUMN$)?", baseFile, RELAXED_FILE_PATH_EXPR));
        builder.addFilter((Filter)new CustomRegexpFilter(this.getProject(), "(?:$FILE_PATH$)? line $LINE$(?:\\:(?: column )?$COLUMN$)?", baseFile, STRICT_FILE_PATH_EXPR));
        state.setConsoleBuilder(builder);
        return state;
    }

    public void createAdditionalTabComponents(AdditionalTabComponentManager manager, ProcessHandler startedProcess) {
        if (this.myOutputType == OutputType.CONSOLE) {
            HighlightingOutputConsole console = new HighlightingOutputConsole(this.getProject(), this.myFileType);
            List<XsltRunnerExtension> extensions = XsltRunnerExtension.getExtensions(this, manager instanceof DebuggerLogConsoleManager);
            boolean consoleTabAdded = false;
            for (XsltRunnerExtension extension : extensions) {
                if (!extension.createTabs(this.getProject(), manager, console, startedProcess)) continue;
                consoleTabAdded = true;
            }
            if (!consoleTabAdded) {
                manager.addAdditionalTabComponent((AdditionalTabComponent)console, console.getTabTitle());
            }
            OutputTabAdapter listener = new OutputTabAdapter(startedProcess, console);
            if (startedProcess.isStartNotified()) {
                listener.startNotified(new ProcessEvent(startedProcess));
            } else {
                startedProcess.addProcessListener((ProcessListener)listener);
            }
        }
    }

    public final RunConfiguration clone() {
        XsltRunConfiguration configuration = (XsltRunConfiguration)super.clone();
        configuration.myParameters = new ArrayList<Pair<String, String>>(this.myParameters);
        if (this.myXsltFile != null) {
            configuration.myXsltFile = VirtualFilePointerManager.getInstance().duplicate(this.myXsltFile, (Disposable)this.getProject(), null);
        }
        if (this.myXmlInputFile != null) {
            configuration.myXmlInputFile = VirtualFilePointerManager.getInstance().duplicate(this.myXmlInputFile, (Disposable)this.getProject(), null);
        }
        return configuration;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.myXsltFile == null) {
            throw new RuntimeConfigurationError("No XSLT File selected");
        }
        if (this.myXsltFile.getFile() == null) {
            throw new RuntimeConfigurationError("Selected XSLT File not found");
        }
        if (this.myXmlInputFile == null) {
            throw new RuntimeConfigurationError("No XML Input File selected");
        }
        if (this.myXmlInputFile.getFile() == null) {
            throw new RuntimeConfigurationError("Selected XML Input File not found");
        }
        if (this.mySaveToFile) {
            if (XsltRunConfiguration.isEmpty(this.myOutputFile)) {
                throw new RuntimeConfigurationError("No output file selected");
            }
            File f = new File(this.myOutputFile);
            if (f.isDirectory()) {
                throw new RuntimeConfigurationError("Selected output file points to a directory");
            }
            if (f.exists() && !f.canWrite()) {
                throw new RuntimeConfigurationError("Selected output file is not writable");
            }
        }
        if (this.getEffectiveJDK() == null) {
            throw new RuntimeConfigurationError("No JDK available");
        }
    }

    static boolean isEmpty(String file) {
        return file == null || file.length() == 0;
    }

    @NotNull
    public Module[] getModules() {
        Module[] moduleArray;
        if (this.getModule() != null) {
            Module[] moduleArray2 = new Module[1];
            moduleArray = moduleArray2;
            moduleArray2[0] = this.getModule();
        } else {
            moduleArray = Module.EMPTY_ARRAY;
        }
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/run/XsltRunConfiguration", "getModules"));
        }
        return moduleArray;
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element jdkChoice;
        Element fileType;
        Element outputType;
        Element parameters;
        String url;
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        Element e = element.getChild("XsltFile");
        if (e != null && (url = e.getAttributeValue("url")) != null) {
            this.myXsltFile = VirtualFilePointerManager.getInstance().create(url, (Disposable)this.getProject(), null);
        }
        if ((e = element.getChild("XmlFile")) != null && (url = e.getAttributeValue("url")) != null) {
            this.myXmlInputFile = VirtualFilePointerManager.getInstance().create(url, (Disposable)this.getProject(), null);
        }
        if ((parameters = element.getChild("parameters")) != null) {
            this.myParameters.clear();
            List params = parameters.getChildren("param");
            for (Element p : params) {
                this.myParameters.add((Pair<String, String>)Pair.create((Object)p.getAttributeValue("name"), (Object)p.getAttributeValue("value")));
            }
        }
        if ((outputType = element.getChild("OutputType")) != null) {
            String value = outputType.getAttributeValue("value");
            if (OutputType.FILE.name().equals(value)) {
                this.myOutputType = OutputType.STDOUT;
                this.mySaveToFile = true;
            } else {
                this.myOutputType = OutputType.valueOf(value);
                this.mySaveToFile = Boolean.valueOf(outputType.getAttributeValue("save-to-file"));
            }
        }
        if ((fileType = element.getChild("FileType")) != null) {
            this.myFileType = XsltRunConfiguration.getFileType(fileType.getAttributeValue("name"));
        }
        if ((jdkChoice = element.getChild("JdkChoice")) != null) {
            this.myJdkChoice = JdkChoice.valueOf(jdkChoice.getAttributeValue("value"));
        }
    }

    @Nullable
    private static FileType getFileType(String value) {
        FileType[] fileTypes;
        if (value == null) {
            return null;
        }
        for (FileType fileType : fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes()) {
            if (!fileType.getName().equals(value)) continue;
            return fileType;
        }
        return null;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        Element e = new Element("XsltFile");
        if (this.myXsltFile != null) {
            e.setAttribute("url", this.myXsltFile.getUrl());
            element.addContent(e);
        }
        e = new Element("XmlFile");
        if (this.myXmlInputFile != null) {
            e.setAttribute("url", this.myXmlInputFile.getUrl());
            element.addContent(e);
        }
        Element params = new Element("parameters");
        element.addContent(params);
        for (Pair<String, String> pair : this.myParameters) {
            Element p = new Element("param");
            params.addContent(p);
            p.setAttribute("name", (String)pair.getFirst());
            String value = (String)pair.getSecond();
            if (value == null) continue;
            p.setAttribute("value", value);
        }
        Element type = new Element("OutputType");
        type.setAttribute("value", this.myOutputType.name());
        type.setAttribute("save-to-file", String.valueOf(this.mySaveToFile));
        element.addContent(type);
        Element fileType = new Element("FileType");
        if (this.myFileType != null) {
            fileType.setAttribute("name", this.myFileType.getName());
        }
        element.addContent(fileType);
        Element choice = new Element("JdkChoice");
        choice.setAttribute("value", this.myJdkChoice.name());
        element.addContent(choice);
    }

    public List<Pair<String, String>> getParameters() {
        return this.myParameters;
    }

    public void setParameters(List<Pair<String, String>> params) {
        this.myParameters.clear();
        this.myParameters.addAll(params);
    }

    public String getVmArguments() {
        return this.myVmArguments;
    }

    public void setVmArguments(String vmArguments) {
        this.myVmArguments = vmArguments;
    }

    public void setXsltFile(@NotNull String xsltFile) {
        if (xsltFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/run/XsltRunConfiguration", "setXsltFile"));
        }
        this.myXsltFile = XsltRunConfiguration.isEmpty(xsltFile) ? null : VirtualFilePointerManager.getInstance().create(VfsUtilCore.pathToUrl((String)xsltFile).replace(File.separatorChar, '/'), (Disposable)this.getProject(), null);
    }

    private void setXsltFile(VirtualFile virtualFile) {
        this.myXsltFile = VirtualFilePointerManager.getInstance().create(virtualFile, (Disposable)this.getProject(), null);
    }

    @Nullable
    public String getXsltFile() {
        return this.myXsltFile != null ? this.myXsltFile.getPresentableUrl() : null;
    }

    @Nullable
    public VirtualFile findXsltFile() {
        return this.myXsltFile != null ? this.myXsltFile.getFile() : null;
    }

    @Nullable
    public VirtualFile findXmlInputFile() {
        return this.myXmlInputFile != null ? this.myXmlInputFile.getFile() : null;
    }

    @Nullable
    public String getXmlInputFile() {
        return this.myXmlInputFile != null ? this.myXmlInputFile.getPresentableUrl() : null;
    }

    @Nullable
    public FileType getFileType() {
        return this.myFileType;
    }

    public void setFileType(@Nullable FileType fileType) {
        this.myFileType = fileType;
    }

    @Nullable
    public Module getModule() {
        return this.myModule != null ? ModuleManager.getInstance((Project)this.getProject()).findModuleByName(this.myModule) : null;
    }

    @Nullable
    public Sdk getJdk() {
        return this.myJdk != null ? ProjectJdkTable.getInstance().findJdk(this.myJdk) : null;
    }

    public void setXmlInputFile(@NotNull String xmlInputFile) {
        if (xmlInputFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/run/XsltRunConfiguration", "setXmlInputFile"));
        }
        this.myXmlInputFile = XsltRunConfiguration.isEmpty(xmlInputFile) ? null : VirtualFilePointerManager.getInstance().create(VfsUtilCore.pathToUrl((String)xmlInputFile).replace(File.separatorChar, '/'), (Disposable)this.getProject(), null);
    }

    public void setXmlInputFile(VirtualFile xmlInputFile) {
        this.myXmlInputFile = VirtualFilePointerManager.getInstance().create(xmlInputFile, (Disposable)this.getProject(), null);
    }

    public void setModule(Module module) {
        this.myModule = module != null ? module.getName() : null;
    }

    public void setJDK(Sdk projectJdk) {
        this.myJdk = projectJdk != null ? projectJdk.getName() : null;
    }

    @NotNull
    public OutputType getOutputType() {
        OutputType outputType = this.myOutputType;
        if (outputType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/run/XsltRunConfiguration", "getOutputType"));
        }
        return outputType;
    }

    public void setOutputType(@NotNull OutputType outputType) {
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/run/XsltRunConfiguration", "setOutputType"));
        }
        this.myOutputType = outputType;
    }

    public boolean isSaveToFile() {
        return this.mySaveToFile;
    }

    public void setSaveToFile(boolean saveToFile) {
        this.mySaveToFile = saveToFile;
    }

    @NotNull
    public JdkChoice getJdkChoice() {
        JdkChoice jdkChoice = this.myJdkChoice;
        if (jdkChoice == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/run/XsltRunConfiguration", "getJdkChoice"));
        }
        return jdkChoice;
    }

    public void setJdkChoice(@NotNull JdkChoice jdkChoice) {
        if (jdkChoice == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/run/XsltRunConfiguration", "setJdkChoice"));
        }
        this.myJdkChoice = jdkChoice;
    }

    private static synchronized Sdk getDefaultSdk() {
        if (ourDefaultSdk == null) {
            String jdkHome = SystemProperties.getJavaHome();
            String versionName = ProjectBundle.message((String)"sdk.java.name.template", (Object[])new Object[]{SystemProperties.getJavaVersion()});
            Sdk sdk = ProjectJdkTable.getInstance().createSdk(versionName, (SdkTypeId)new SimpleJavaSdkType());
            SdkModificator modificator = sdk.getSdkModificator();
            modificator.setHomePath(jdkHome);
            modificator.commitChanges();
            ourDefaultSdk = sdk;
        }
        return ourDefaultSdk;
    }

    @Nullable
    public Sdk getEffectiveJDK() {
        if (!XsltRunSettingsEditor.ALLOW_CHOOSING_SDK) {
            return XsltRunConfiguration.getDefaultSdk();
        }
        if (this.myJdkChoice == JdkChoice.JDK) {
            return this.myJdk != null ? ProjectJdkTable.getInstance().findJdk(this.myJdk) : null;
        }
        Sdk jdk = null;
        Module module = this.getEffectiveModule();
        if (module != null) {
            jdk = ModuleRootManager.getInstance((Module)module).getSdk();
        }
        if (jdk == null) {
            jdk = ProjectRootManager.getInstance((Project)this.getProject()).getProjectSdk();
        }
        if (jdk == null || !(jdk.getSdkType() instanceof JavaSdkType)) {
            return XsltRunConfiguration.getDefaultSdk();
        }
        return jdk;
    }

    @Nullable
    public Module getEffectiveModule() {
        VirtualFile file;
        Module module;
        Module module2 = module = this.myJdkChoice == JdkChoice.FROM_MODULE ? this.getModule() : null;
        if (module == null && this.myXsltFile != null && (file = this.myXsltFile.getFile()) != null) {
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
            module = index.getModuleForFile(file);
        }
        return module;
    }

    public String suggestedName() {
        return this.mySuggestedName;
    }

    public XsltRunConfiguration initFromFile(@NotNull XmlFile file) {
        XmlTag[] outputs;
        XmlTag[] params;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/run/XsltRunConfiguration", "initFromFile"));
        }
        assert (XsltSupport.isXsltFile((PsiFile)file)) : "Not an XSLT file: " + file.getName();
        this.mySuggestedName = file.getName();
        VirtualFile virtualFile = file.getVirtualFile();
        assert (virtualFile != null) : "No VirtualFile for " + file.getName();
        this.setXsltFile(virtualFile);
        PsiFile[] associations = FileAssociationsManager.getInstance(file.getProject()).getAssociationsFor((PsiFile)file);
        if (associations.length > 0) {
            VirtualFile assoc = associations[0].getVirtualFile();
            assert (assoc != null);
            this.setXmlInputFile(assoc);
        }
        XmlDocument document = file.getDocument();
        assert (document != null) : "XSLT file without document?";
        XmlTag rootTag = document.getRootTag();
        assert (rootTag != null) : "XSLT file without root element?";
        for (XmlTag param : params = rootTag.findSubTags("param", "http://www.w3.org/1999/XSL/Transform")) {
            String name = param.getAttributeValue("name");
            if (name == null) continue;
            Pair pair = Pair.create((Object)name, null);
            this.myParameters.add((Pair<String, String>)pair);
        }
        for (XmlTag output : outputs = rootTag.findSubTags("output", "http://www.w3.org/1999/XSL/Transform")) {
            String method = output.getAttributeValue("method");
            if ("xml".equals(method)) {
                this.setFileType((FileType)StdFileTypes.XML);
                continue;
            }
            if ("html".equals(method)) {
                this.setFileType((FileType)StdFileTypes.HTML);
                continue;
            }
            if (!"text".equals(method)) continue;
            this.setFileType((FileType)FileTypes.PLAIN_TEXT);
        }
        return this;
    }

    public static enum JdkChoice {
        FROM_MODULE,
        JDK;

    }

    public static enum OutputType {
        CONSOLE,
        STDOUT,
        FILE;

    }
}

