/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.xslt.quickfix.AbstractFix;
import org.jetbrains.annotations.NotNull;

public class RemoveParamFix
extends AbstractFix {
    private final XmlTag myTag;
    private final String myName;

    public RemoveParamFix(XmlTag tag, String name) {
        this.myName = name;
        this.myTag = tag;
    }

    @NotNull
    public String getText() {
        String string = "Remove Argument '" + this.myName + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/quickfix/RemoveParamFix", "getText"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/quickfix/RemoveParamFix", "invoke"));
        }
        this.myTag.delete();
    }

    @Override
    public boolean isAvailableImpl(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/quickfix/RemoveParamFix", "isAvailableImpl"));
        }
        return this.myTag.isValid();
    }

    @Override
    protected boolean requiresEditor() {
        return false;
    }
}

