/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.psi.XPathBinaryExpression;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathToken;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.intellij.lang.xpath.xslt.quickfix.AbstractFix;
import org.jetbrains.annotations.NotNull;

public class FlipOperandsFix
extends AbstractFix {
    private final XPathBinaryExpression myExpression;
    private final XPathToken myToken;

    public FlipOperandsFix(XPathToken token) {
        this.myToken = token;
        this.myExpression = (XPathBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)token, XPathBinaryExpression.class);
    }

    @NotNull
    public String getText() {
        String string = "Flip '" + this.myToken.getText() + "' to '" + this.myToken.getText().replace('<', '>') + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/quickfix/FlipOperandsFix", "getText"));
        }
        return string;
    }

    @Override
    public boolean isAvailableImpl(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/quickfix/FlipOperandsFix", "isAvailableImpl"));
        }
        return this.myExpression != null && this.myExpression.isValid() && this.myExpression.getType() == XPathType.BOOLEAN && this.myExpression.getROperand() != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/quickfix/FlipOperandsFix", "invoke"));
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getContextOfType((PsiElement)this.myToken, XmlAttribute.class, (boolean)true);
        assert (attribute != null);
        XPathFile f = XPathChangeUtil.createXPathFile(this.myToken, FlipOperandsFix.getOperandText(this.myExpression.getROperand()) + " " + this.myToken.getText().replace('<', '>') + " " + FlipOperandsFix.getOperandText(this.myExpression.getLOperand()));
        PsiElement firstChild = f.getFirstChild();
        assert (firstChild != null);
        this.myExpression.replace(firstChild);
    }

    private static String getOperandText(XPathExpression operand) {
        return operand != null ? operand.getText() : "";
    }

    @Override
    protected boolean requiresEditor() {
        return false;
    }
}

