/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.xslt.psi.XsltVariable;
import org.jetbrains.annotations.NotNull;

public abstract class DeleteUnusedElementBase<T extends XsltVariable>
implements LocalQuickFix {
    private final String myName;
    private final T myElement;

    protected DeleteUnusedElementBase(String name, T element) {
        this.myName = name;
        this.myElement = element;
    }

    @NotNull
    public String getFamilyName() {
        if ("Delete Unused Element" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/quickfix/DeleteUnusedElementBase", "getFamilyName"));
        }
        return "Delete Unused Element";
    }

    @NotNull
    public String getName() {
        String string = "Delete unused " + this.getType() + " '" + this.myName + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/quickfix/DeleteUnusedElementBase", "getName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/quickfix/DeleteUnusedElementBase", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/lang/xpath/xslt/quickfix/DeleteUnusedElementBase", "applyFix"));
        }
        try {
            this.deleteElement(this.myElement);
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance((String)this.getClass().getName()).error((Throwable)e);
        }
    }

    public abstract String getType();

    protected void deleteElement(@NotNull T obj) throws IncorrectOperationException {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/quickfix/DeleteUnusedElementBase", "deleteElement"));
        }
        obj.delete();
    }
}

